package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.request.AndroidCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.AndroidUsernameSource;
import odata.msgraph.client.beta.enums.DomainNameSource;
import odata.msgraph.client.beta.enums.EasAuthenticationMethod;
import odata.msgraph.client.beta.enums.EmailSyncDuration;
import odata.msgraph.client.beta.enums.EmailSyncSchedule;
import odata.msgraph.client.beta.enums.UserEmailSource;


/**
 * <i>“By providing configurations in this profile you can instruct the native email
 * client on KNOX devices to communicate with an Exchange server and get email,
 * contacts, calendar, tasks, and notes. Furthermore, you can also specify how much
 * email to sync and how often the device should sync.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountName", 
    "authenticationMethod", 
    "customDomainName", 
    "durationOfEmailToSync", 
    "emailAddressSource", 
    "emailSyncSchedule", 
    "hostName", 
    "requireSmime", 
    "requireSsl", 
    "syncCalendar", 
    "syncContacts", 
    "syncNotes", 
    "syncTasks", 
    "userDomainNameSource", 
    "usernameSource"})
@JsonInclude(Include.NON_NULL)
public class AndroidEasEmailProfileConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidEasEmailProfileConfiguration";
    }

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("authenticationMethod")
    protected EasAuthenticationMethod authenticationMethod;

    @JsonProperty("customDomainName")
    protected String customDomainName;

    @JsonProperty("durationOfEmailToSync")
    protected EmailSyncDuration durationOfEmailToSync;

    @JsonProperty("emailAddressSource")
    protected UserEmailSource emailAddressSource;

    @JsonProperty("emailSyncSchedule")
    protected EmailSyncSchedule emailSyncSchedule;

    @JsonProperty("hostName")
    protected String hostName;

    @JsonProperty("requireSmime")
    protected Boolean requireSmime;

    @JsonProperty("requireSsl")
    protected Boolean requireSsl;

    @JsonProperty("syncCalendar")
    protected Boolean syncCalendar;

    @JsonProperty("syncContacts")
    protected Boolean syncContacts;

    @JsonProperty("syncNotes")
    protected Boolean syncNotes;

    @JsonProperty("syncTasks")
    protected Boolean syncTasks;

    @JsonProperty("userDomainNameSource")
    protected DomainNameSource userDomainNameSource;

    @JsonProperty("usernameSource")
    protected AndroidUsernameSource usernameSource;

    protected AndroidEasEmailProfileConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidEasEmailProfileConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private String accountName;
        private EasAuthenticationMethod authenticationMethod;
        private String customDomainName;
        private EmailSyncDuration durationOfEmailToSync;
        private UserEmailSource emailAddressSource;
        private EmailSyncSchedule emailSyncSchedule;
        private String hostName;
        private Boolean requireSmime;
        private Boolean requireSsl;
        private Boolean syncCalendar;
        private Boolean syncContacts;
        private Boolean syncNotes;
        private Boolean syncTasks;
        private DomainNameSource userDomainNameSource;
        private AndroidUsernameSource usernameSource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Exchange ActiveSync account name, displayed to users as name of EAS (this)
         * profile.”</i>
         * 
         * @param accountName
         *            value of {@code accountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        /**
         * <i>“Authentication method for Exchange ActiveSync.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(EasAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Custom domain name value used while generating an email profile before
         * installing on the device.”</i>
         * 
         * @param customDomainName
         *            value of {@code customDomainName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            this.changedFields = changedFields.add("customDomainName");
            return this;
        }

        /**
         * <i>“Duration of time email should be synced to.”</i>
         * 
         * @param durationOfEmailToSync
         *            value of {@code durationOfEmailToSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder durationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
            this.durationOfEmailToSync = durationOfEmailToSync;
            this.changedFields = changedFields.add("durationOfEmailToSync");
            return this;
        }

        /**
         * <i>“Email attribute that is picked from AAD and injected into this profile before
         * installing on the device.”</i>
         * 
         * @param emailAddressSource
         *            value of {@code emailAddressSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailAddressSource(UserEmailSource emailAddressSource) {
            this.emailAddressSource = emailAddressSource;
            this.changedFields = changedFields.add("emailAddressSource");
            return this;
        }

        /**
         * <i>“Email sync schedule.”</i>
         * 
         * @param emailSyncSchedule
         *            value of {@code emailSyncSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailSyncSchedule(EmailSyncSchedule emailSyncSchedule) {
            this.emailSyncSchedule = emailSyncSchedule;
            this.changedFields = changedFields.add("emailSyncSchedule");
            return this;
        }

        /**
         * <i>“Exchange location (URL) that the native mail app connects to.”</i>
         * 
         * @param hostName
         *            value of {@code hostName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.changedFields = changedFields.add("hostName");
            return this;
        }

        /**
         * <i>“Indicates whether or not to use S/MIME certificate.”</i>
         * 
         * @param requireSmime
         *            value of {@code requireSmime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireSmime(Boolean requireSmime) {
            this.requireSmime = requireSmime;
            this.changedFields = changedFields.add("requireSmime");
            return this;
        }

        /**
         * <i>“Indicates whether or not to use SSL.”</i>
         * 
         * @param requireSsl
         *            value of {@code requireSsl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireSsl(Boolean requireSsl) {
            this.requireSsl = requireSsl;
            this.changedFields = changedFields.add("requireSsl");
            return this;
        }

        /**
         * <i>“Toggles syncing the calendar. If set to false calendar is turned off on the
         * device.”</i>
         * 
         * @param syncCalendar
         *            value of {@code syncCalendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncCalendar(Boolean syncCalendar) {
            this.syncCalendar = syncCalendar;
            this.changedFields = changedFields.add("syncCalendar");
            return this;
        }

        /**
         * <i>“Toggles syncing contacts. If set to false contacts are turned off on the device.”</i>
         * 
         * @param syncContacts
         *            value of {@code syncContacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncContacts(Boolean syncContacts) {
            this.syncContacts = syncContacts;
            this.changedFields = changedFields.add("syncContacts");
            return this;
        }

        /**
         * <i>“Toggles syncing notes. If set to false notes are turned off on the device.”</i>
         * 
         * @param syncNotes
         *            value of {@code syncNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncNotes(Boolean syncNotes) {
            this.syncNotes = syncNotes;
            this.changedFields = changedFields.add("syncNotes");
            return this;
        }

        /**
         * <i>“Toggles syncing tasks. If set to false tasks are turned off on the device.”</i>
         * 
         * @param syncTasks
         *            value of {@code syncTasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncTasks(Boolean syncTasks) {
            this.syncTasks = syncTasks;
            this.changedFields = changedFields.add("syncTasks");
            return this;
        }

        /**
         * <i>“UserDomainname attribute that is picked from AAD and injected into this profile
         * before installing on the device.”</i>
         * 
         * @param userDomainNameSource
         *            value of {@code userDomainNameSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDomainNameSource(DomainNameSource userDomainNameSource) {
            this.userDomainNameSource = userDomainNameSource;
            this.changedFields = changedFields.add("userDomainNameSource");
            return this;
        }

        /**
         * <i>“Username attribute that is picked from AAD and injected into this profile before
         * installing on the device.”</i>
         * 
         * @param usernameSource
         *            value of {@code usernameSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usernameSource(AndroidUsernameSource usernameSource) {
            this.usernameSource = usernameSource;
            this.changedFields = changedFields.add("usernameSource");
            return this;
        }

        public AndroidEasEmailProfileConfiguration build() {
            AndroidEasEmailProfileConfiguration _x = new AndroidEasEmailProfileConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidEasEmailProfileConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.accountName = accountName;
            _x.authenticationMethod = authenticationMethod;
            _x.customDomainName = customDomainName;
            _x.durationOfEmailToSync = durationOfEmailToSync;
            _x.emailAddressSource = emailAddressSource;
            _x.emailSyncSchedule = emailSyncSchedule;
            _x.hostName = hostName;
            _x.requireSmime = requireSmime;
            _x.requireSsl = requireSsl;
            _x.syncCalendar = syncCalendar;
            _x.syncContacts = syncContacts;
            _x.syncNotes = syncNotes;
            _x.syncTasks = syncTasks;
            _x.userDomainNameSource = userDomainNameSource;
            _x.usernameSource = usernameSource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Exchange ActiveSync account name, displayed to users as name of EAS (this)
     * profile.”</i>
     * 
     * @return property accountName
     */
    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accountName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Exchange ActiveSync account name, displayed to users as name of EAS (this)
     * profile.”</i>
     * 
     * @param accountName
     *            new value of {@code accountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountName} field changed
     */
    public AndroidEasEmailProfileConfiguration withAccountName(String accountName) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.accountName = accountName;
        return _x;
    }

    /**
     * <i>“Authentication method for Exchange ActiveSync.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<EasAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method for Exchange ActiveSync.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidEasEmailProfileConfiguration withAuthenticationMethod(EasAuthenticationMethod authenticationMethod) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Custom domain name value used while generating an email profile before
     * installing on the device.”</i>
     * 
     * @return property customDomainName
     */
    @Property(name="customDomainName")
    @JsonIgnore
    public Optional<String> getCustomDomainName() {
        return Optional.ofNullable(customDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customDomainName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Custom domain name value used while generating an email profile before
     * installing on the device.”</i>
     * 
     * @param customDomainName
     *            new value of {@code customDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDomainName} field changed
     */
    public AndroidEasEmailProfileConfiguration withCustomDomainName(String customDomainName) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.customDomainName = customDomainName;
        return _x;
    }

    /**
     * <i>“Duration of time email should be synced to.”</i>
     * 
     * @return property durationOfEmailToSync
     */
    @Property(name="durationOfEmailToSync")
    @JsonIgnore
    public Optional<EmailSyncDuration> getDurationOfEmailToSync() {
        return Optional.ofNullable(durationOfEmailToSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * durationOfEmailToSync} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Duration of time email should be synced to.”</i>
     * 
     * @param durationOfEmailToSync
     *            new value of {@code durationOfEmailToSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code durationOfEmailToSync} field changed
     */
    public AndroidEasEmailProfileConfiguration withDurationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("durationOfEmailToSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.durationOfEmailToSync = durationOfEmailToSync;
        return _x;
    }

    /**
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property emailAddressSource
     */
    @Property(name="emailAddressSource")
    @JsonIgnore
    public Optional<UserEmailSource> getEmailAddressSource() {
        return Optional.ofNullable(emailAddressSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * emailAddressSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param emailAddressSource
     *            new value of {@code emailAddressSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddressSource} field changed
     */
    public AndroidEasEmailProfileConfiguration withEmailAddressSource(UserEmailSource emailAddressSource) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailAddressSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.emailAddressSource = emailAddressSource;
        return _x;
    }

    /**
     * <i>“Email sync schedule.”</i>
     * 
     * @return property emailSyncSchedule
     */
    @Property(name="emailSyncSchedule")
    @JsonIgnore
    public Optional<EmailSyncSchedule> getEmailSyncSchedule() {
        return Optional.ofNullable(emailSyncSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code emailSyncSchedule
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Email sync schedule.”</i>
     * 
     * @param emailSyncSchedule
     *            new value of {@code emailSyncSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailSyncSchedule} field changed
     */
    public AndroidEasEmailProfileConfiguration withEmailSyncSchedule(EmailSyncSchedule emailSyncSchedule) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailSyncSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.emailSyncSchedule = emailSyncSchedule;
        return _x;
    }

    /**
     * <i>“Exchange location (URL) that the native mail app connects to.”</i>
     * 
     * @return property hostName
     */
    @Property(name="hostName")
    @JsonIgnore
    public Optional<String> getHostName() {
        return Optional.ofNullable(hostName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hostName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exchange location (URL) that the native mail app connects to.”</i>
     * 
     * @param hostName
     *            new value of {@code hostName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hostName} field changed
     */
    public AndroidEasEmailProfileConfiguration withHostName(String hostName) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("hostName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.hostName = hostName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use S/MIME certificate.”</i>
     * 
     * @return property requireSmime
     */
    @Property(name="requireSmime")
    @JsonIgnore
    public Optional<Boolean> getRequireSmime() {
        return Optional.ofNullable(requireSmime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSmime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to use S/MIME certificate.”</i>
     * 
     * @param requireSmime
     *            new value of {@code requireSmime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSmime} field changed
     */
    public AndroidEasEmailProfileConfiguration withRequireSmime(Boolean requireSmime) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireSmime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.requireSmime = requireSmime;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @return property requireSsl
     */
    @Property(name="requireSsl")
    @JsonIgnore
    public Optional<Boolean> getRequireSsl() {
        return Optional.ofNullable(requireSsl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSsl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @param requireSsl
     *            new value of {@code requireSsl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSsl} field changed
     */
    public AndroidEasEmailProfileConfiguration withRequireSsl(Boolean requireSsl) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireSsl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.requireSsl = requireSsl;
        return _x;
    }

    /**
     * <i>“Toggles syncing the calendar. If set to false calendar is turned off on the
     * device.”</i>
     * 
     * @return property syncCalendar
     */
    @Property(name="syncCalendar")
    @JsonIgnore
    public Optional<Boolean> getSyncCalendar() {
        return Optional.ofNullable(syncCalendar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncCalendar}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Toggles syncing the calendar. If set to false calendar is turned off on the
     * device.”</i>
     * 
     * @param syncCalendar
     *            new value of {@code syncCalendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncCalendar} field changed
     */
    public AndroidEasEmailProfileConfiguration withSyncCalendar(Boolean syncCalendar) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncCalendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.syncCalendar = syncCalendar;
        return _x;
    }

    /**
     * <i>“Toggles syncing contacts. If set to false contacts are turned off on the device.”</i>
     * 
     * @return property syncContacts
     */
    @Property(name="syncContacts")
    @JsonIgnore
    public Optional<Boolean> getSyncContacts() {
        return Optional.ofNullable(syncContacts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncContacts}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Toggles syncing contacts. If set to false contacts are turned off on the device.”</i>
     * 
     * @param syncContacts
     *            new value of {@code syncContacts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncContacts} field changed
     */
    public AndroidEasEmailProfileConfiguration withSyncContacts(Boolean syncContacts) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncContacts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.syncContacts = syncContacts;
        return _x;
    }

    /**
     * <i>“Toggles syncing notes. If set to false notes are turned off on the device.”</i>
     * 
     * @return property syncNotes
     */
    @Property(name="syncNotes")
    @JsonIgnore
    public Optional<Boolean> getSyncNotes() {
        return Optional.ofNullable(syncNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncNotes} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Toggles syncing notes. If set to false notes are turned off on the device.”</i>
     * 
     * @param syncNotes
     *            new value of {@code syncNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncNotes} field changed
     */
    public AndroidEasEmailProfileConfiguration withSyncNotes(Boolean syncNotes) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.syncNotes = syncNotes;
        return _x;
    }

    /**
     * <i>“Toggles syncing tasks. If set to false tasks are turned off on the device.”</i>
     * 
     * @return property syncTasks
     */
    @Property(name="syncTasks")
    @JsonIgnore
    public Optional<Boolean> getSyncTasks() {
        return Optional.ofNullable(syncTasks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncTasks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Toggles syncing tasks. If set to false tasks are turned off on the device.”</i>
     * 
     * @param syncTasks
     *            new value of {@code syncTasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncTasks} field changed
     */
    public AndroidEasEmailProfileConfiguration withSyncTasks(Boolean syncTasks) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncTasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.syncTasks = syncTasks;
        return _x;
    }

    /**
     * <i>“UserDomainname attribute that is picked from AAD and injected into this profile
     * before installing on the device.”</i>
     * 
     * @return property userDomainNameSource
     */
    @Property(name="userDomainNameSource")
    @JsonIgnore
    public Optional<DomainNameSource> getUserDomainNameSource() {
        return Optional.ofNullable(userDomainNameSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userDomainNameSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“UserDomainname attribute that is picked from AAD and injected into this profile
     * before installing on the device.”</i>
     * 
     * @param userDomainNameSource
     *            new value of {@code userDomainNameSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDomainNameSource} field changed
     */
    public AndroidEasEmailProfileConfiguration withUserDomainNameSource(DomainNameSource userDomainNameSource) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userDomainNameSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.userDomainNameSource = userDomainNameSource;
        return _x;
    }

    /**
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property usernameSource
     */
    @Property(name="usernameSource")
    @JsonIgnore
    public Optional<AndroidUsernameSource> getUsernameSource() {
        return Optional.ofNullable(usernameSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usernameSource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param usernameSource
     *            new value of {@code usernameSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameSource} field changed
     */
    public AndroidEasEmailProfileConfiguration withUsernameSource(AndroidUsernameSource usernameSource) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usernameSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEasEmailProfileConfiguration");
        _x.usernameSource = usernameSource;
        return _x;
    }

    public AndroidEasEmailProfileConfiguration withUnmappedField(String name, Object value) {
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Identity certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public AndroidCertificateProfileBaseRequest getIdentityCertificate() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), RequestHelper.getValue(unmappedFields, "identityCertificate"));
    }

    /**
     * <i>“S/MIME signing certificate.”</i>
     * 
     * @return navigational property smimeSigningCertificate
     */
    @NavigationProperty(name="smimeSigningCertificate")
    @JsonIgnore
    public AndroidCertificateProfileBaseRequest getSmimeSigningCertificate() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("smimeSigningCertificate"), RequestHelper.getValue(unmappedFields, "smimeSigningCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidEasEmailProfileConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidEasEmailProfileConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidEasEmailProfileConfiguration _copy() {
        AndroidEasEmailProfileConfiguration _x = new AndroidEasEmailProfileConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.accountName = accountName;
        _x.authenticationMethod = authenticationMethod;
        _x.customDomainName = customDomainName;
        _x.durationOfEmailToSync = durationOfEmailToSync;
        _x.emailAddressSource = emailAddressSource;
        _x.emailSyncSchedule = emailSyncSchedule;
        _x.hostName = hostName;
        _x.requireSmime = requireSmime;
        _x.requireSsl = requireSsl;
        _x.syncCalendar = syncCalendar;
        _x.syncContacts = syncContacts;
        _x.syncNotes = syncNotes;
        _x.syncTasks = syncTasks;
        _x.userDomainNameSource = userDomainNameSource;
        _x.usernameSource = usernameSource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidEasEmailProfileConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("customDomainName=");
        b.append(this.customDomainName);
        b.append(", ");
        b.append("durationOfEmailToSync=");
        b.append(this.durationOfEmailToSync);
        b.append(", ");
        b.append("emailAddressSource=");
        b.append(this.emailAddressSource);
        b.append(", ");
        b.append("emailSyncSchedule=");
        b.append(this.emailSyncSchedule);
        b.append(", ");
        b.append("hostName=");
        b.append(this.hostName);
        b.append(", ");
        b.append("requireSmime=");
        b.append(this.requireSmime);
        b.append(", ");
        b.append("requireSsl=");
        b.append(this.requireSsl);
        b.append(", ");
        b.append("syncCalendar=");
        b.append(this.syncCalendar);
        b.append(", ");
        b.append("syncContacts=");
        b.append(this.syncContacts);
        b.append(", ");
        b.append("syncNotes=");
        b.append(this.syncNotes);
        b.append(", ");
        b.append("syncTasks=");
        b.append(this.syncTasks);
        b.append(", ");
        b.append("userDomainNameSource=");
        b.append(this.userDomainNameSource);
        b.append(", ");
        b.append("usernameSource=");
        b.append(this.usernameSource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
