package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Local Action Lock Device with Passcode Configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passcode", 
    "passcodeSignInFailureCountBeforeWipe"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceComplianceLocalActionLockDeviceWithPasscode extends AndroidDeviceComplianceLocalActionBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceComplianceLocalActionLockDeviceWithPasscode";
    }

    @JsonProperty("passcode")
    protected String passcode;

    @JsonProperty("passcodeSignInFailureCountBeforeWipe")
    protected Integer passcodeSignInFailureCountBeforeWipe;

    protected AndroidDeviceComplianceLocalActionLockDeviceWithPasscode() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceComplianceLocalActionLockDeviceWithPasscode() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer gracePeriodInMinutes;
        private String passcode;
        private Integer passcodeSignInFailureCountBeforeWipe;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder gracePeriodInMinutes(Integer gracePeriodInMinutes) {
            this.gracePeriodInMinutes = gracePeriodInMinutes;
            this.changedFields = changedFields.add("gracePeriodInMinutes");
            return this;
        }

        /**
         * <i>“Passcode to reset to Android device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param passcode
         *            value of {@code passcode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcode(String passcode) {
            this.passcode = passcode;
            this.changedFields = changedFields.add("passcode");
            return this;
        }

        /**
         * <i>“Number of sign in failures before wiping device, the value can be 4-11. Valid
         * values 4 to 11”</i>
         * 
         * @param passcodeSignInFailureCountBeforeWipe
         *            value of {@code passcodeSignInFailureCountBeforeWipe} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeSignInFailureCountBeforeWipe(Integer passcodeSignInFailureCountBeforeWipe) {
            this.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
            this.changedFields = changedFields.add("passcodeSignInFailureCountBeforeWipe");
            return this;
        }

        public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode build() {
            AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = new AndroidDeviceComplianceLocalActionLockDeviceWithPasscode();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceComplianceLocalActionLockDeviceWithPasscode";
            _x.id = id;
            _x.gracePeriodInMinutes = gracePeriodInMinutes;
            _x.passcode = passcode;
            _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Passcode to reset to Android device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property passcode
     */
    @Property(name="passcode")
    @JsonIgnore
    public Optional<String> getPasscode() {
        return Optional.ofNullable(passcode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passcode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Passcode to reset to Android device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param passcode
     *            new value of {@code passcode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcode} field changed
     */
    public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode withPasscode(String passcode) {
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = _copy();
        _x.changedFields = changedFields.add("passcode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceComplianceLocalActionLockDeviceWithPasscode");
        _x.passcode = passcode;
        return _x;
    }

    /**
     * <i>“Number of sign in failures before wiping device, the value can be 4-11. Valid
     * values 4 to 11”</i>
     * 
     * @return property passcodeSignInFailureCountBeforeWipe
     */
    @Property(name="passcodeSignInFailureCountBeforeWipe")
    @JsonIgnore
    public Optional<Integer> getPasscodeSignInFailureCountBeforeWipe() {
        return Optional.ofNullable(passcodeSignInFailureCountBeforeWipe);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeSignInFailureCountBeforeWipe} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of sign in failures before wiping device, the value can be 4-11. Valid
     * values 4 to 11”</i>
     * 
     * @param passcodeSignInFailureCountBeforeWipe
     *            new value of {@code passcodeSignInFailureCountBeforeWipe} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeSignInFailureCountBeforeWipe} field changed
     */
    public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode withPasscodeSignInFailureCountBeforeWipe(Integer passcodeSignInFailureCountBeforeWipe) {
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = _copy();
        _x.changedFields = changedFields.add("passcodeSignInFailureCountBeforeWipe");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceComplianceLocalActionLockDeviceWithPasscode");
        _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
        return _x;
    }

    public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode withUnmappedField(String name, Object value) {
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceComplianceLocalActionLockDeviceWithPasscode put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _copy() {
        AndroidDeviceComplianceLocalActionLockDeviceWithPasscode _x = new AndroidDeviceComplianceLocalActionLockDeviceWithPasscode();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.gracePeriodInMinutes = gracePeriodInMinutes;
        _x.passcode = passcode;
        _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceComplianceLocalActionLockDeviceWithPasscode[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("gracePeriodInMinutes=");
        b.append(this.gracePeriodInMinutes);
        b.append(", ");
        b.append("passcode=");
        b.append(this.passcode);
        b.append(", ");
        b.append("passcodeSignInFailureCountBeforeWipe=");
        b.append(this.passcodeSignInFailureCountBeforeWipe);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
