package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest;


/**
 * <i>“Windows defender advanced threat protection onboarding state summary across the
 * account.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "compliantDeviceCount", 
    "conflictDeviceCount", 
    "errorDeviceCount", 
    "nonCompliantDeviceCount", 
    "notApplicableDeviceCount", 
    "notAssignedDeviceCount", 
    "remediatedDeviceCount", 
    "unknownDeviceCount", 
    "advancedThreatProtectionOnboardingDeviceSettingStates"})
@JsonInclude(Include.NON_NULL)
public class AdvancedThreatProtectionOnboardingStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.advancedThreatProtectionOnboardingStateSummary";
    }

    @JsonProperty("compliantDeviceCount")
    protected Integer compliantDeviceCount;

    @JsonProperty("conflictDeviceCount")
    protected Integer conflictDeviceCount;

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("nonCompliantDeviceCount")
    protected Integer nonCompliantDeviceCount;

    @JsonProperty("notApplicableDeviceCount")
    protected Integer notApplicableDeviceCount;

    @JsonProperty("notAssignedDeviceCount")
    protected Integer notAssignedDeviceCount;

    @JsonProperty("remediatedDeviceCount")
    protected Integer remediatedDeviceCount;

    @JsonProperty("unknownDeviceCount")
    protected Integer unknownDeviceCount;

    @JsonProperty("advancedThreatProtectionOnboardingDeviceSettingStates")
    protected List<AdvancedThreatProtectionOnboardingDeviceSettingState> advancedThreatProtectionOnboardingDeviceSettingStates;

    protected AdvancedThreatProtectionOnboardingStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAdvancedThreatProtectionOnboardingStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer compliantDeviceCount;
        private Integer conflictDeviceCount;
        private Integer errorDeviceCount;
        private Integer nonCompliantDeviceCount;
        private Integer notApplicableDeviceCount;
        private Integer notAssignedDeviceCount;
        private Integer remediatedDeviceCount;
        private Integer unknownDeviceCount;
        private List<AdvancedThreatProtectionOnboardingDeviceSettingState> advancedThreatProtectionOnboardingDeviceSettingStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of compliant devices”</i>
         * 
         * @param compliantDeviceCount
         *            value of {@code compliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantDeviceCount(Integer compliantDeviceCount) {
            this.compliantDeviceCount = compliantDeviceCount;
            this.changedFields = changedFields.add("compliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of conflict devices”</i>
         * 
         * @param conflictDeviceCount
         *            value of {@code conflictDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictDeviceCount(Integer conflictDeviceCount) {
            this.conflictDeviceCount = conflictDeviceCount;
            this.changedFields = changedFields.add("conflictDeviceCount");
            return this;
        }

        /**
         * <i>“Number of error devices”</i>
         * 
         * @param errorDeviceCount
         *            value of {@code errorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of NonCompliant devices”</i>
         * 
         * @param nonCompliantDeviceCount
         *            value of {@code nonCompliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
            this.nonCompliantDeviceCount = nonCompliantDeviceCount;
            this.changedFields = changedFields.add("nonCompliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices”</i>
         * 
         * @param notApplicableDeviceCount
         *            value of {@code notApplicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableDeviceCount(Integer notApplicableDeviceCount) {
            this.notApplicableDeviceCount = notApplicableDeviceCount;
            this.changedFields = changedFields.add("notApplicableDeviceCount");
            return this;
        }

        /**
         * <i>“Number of not assigned devices”</i>
         * 
         * @param notAssignedDeviceCount
         *            value of {@code notAssignedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notAssignedDeviceCount(Integer notAssignedDeviceCount) {
            this.notAssignedDeviceCount = notAssignedDeviceCount;
            this.changedFields = changedFields.add("notAssignedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of remediated devices”</i>
         * 
         * @param remediatedDeviceCount
         *            value of {@code remediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedDeviceCount(Integer remediatedDeviceCount) {
            this.remediatedDeviceCount = remediatedDeviceCount;
            this.changedFields = changedFields.add("remediatedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of unknown devices”</i>
         * 
         * @param unknownDeviceCount
         *            value of {@code unknownDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownDeviceCount(Integer unknownDeviceCount) {
            this.unknownDeviceCount = unknownDeviceCount;
            this.changedFields = changedFields.add("unknownDeviceCount");
            return this;
        }

        public Builder advancedThreatProtectionOnboardingDeviceSettingStates(List<AdvancedThreatProtectionOnboardingDeviceSettingState> advancedThreatProtectionOnboardingDeviceSettingStates) {
            this.advancedThreatProtectionOnboardingDeviceSettingStates = advancedThreatProtectionOnboardingDeviceSettingStates;
            this.changedFields = changedFields.add("advancedThreatProtectionOnboardingDeviceSettingStates");
            return this;
        }

        public Builder advancedThreatProtectionOnboardingDeviceSettingStates(AdvancedThreatProtectionOnboardingDeviceSettingState... advancedThreatProtectionOnboardingDeviceSettingStates) {
            return advancedThreatProtectionOnboardingDeviceSettingStates(Arrays.asList(advancedThreatProtectionOnboardingDeviceSettingStates));
        }

        public AdvancedThreatProtectionOnboardingStateSummary build() {
            AdvancedThreatProtectionOnboardingStateSummary _x = new AdvancedThreatProtectionOnboardingStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.advancedThreatProtectionOnboardingStateSummary";
            _x.id = id;
            _x.compliantDeviceCount = compliantDeviceCount;
            _x.conflictDeviceCount = conflictDeviceCount;
            _x.errorDeviceCount = errorDeviceCount;
            _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
            _x.notApplicableDeviceCount = notApplicableDeviceCount;
            _x.notAssignedDeviceCount = notAssignedDeviceCount;
            _x.remediatedDeviceCount = remediatedDeviceCount;
            _x.unknownDeviceCount = unknownDeviceCount;
            _x.advancedThreatProtectionOnboardingDeviceSettingStates = advancedThreatProtectionOnboardingDeviceSettingStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of compliant devices”</i>
     * 
     * @return property compliantDeviceCount
     */
    @Property(name="compliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCompliantDeviceCount() {
        return Optional.ofNullable(compliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of compliant devices”</i>
     * 
     * @param compliantDeviceCount
     *            new value of {@code compliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withCompliantDeviceCount(Integer compliantDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("compliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.compliantDeviceCount = compliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of conflict devices”</i>
     * 
     * @return property conflictDeviceCount
     */
    @Property(name="conflictDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConflictDeviceCount() {
        return Optional.ofNullable(conflictDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * conflictDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of conflict devices”</i>
     * 
     * @param conflictDeviceCount
     *            new value of {@code conflictDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withConflictDeviceCount(Integer conflictDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.conflictDeviceCount = conflictDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of error devices”</i>
     * 
     * @return property errorDeviceCount
     */
    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of error devices”</i>
     * 
     * @param errorDeviceCount
     *            new value of {@code errorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withErrorDeviceCount(Integer errorDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of NonCompliant devices”</i>
     * 
     * @return property nonCompliantDeviceCount
     */
    @Property(name="nonCompliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantDeviceCount() {
        return Optional.ofNullable(nonCompliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of NonCompliant devices”</i>
     * 
     * @param nonCompliantDeviceCount
     *            new value of {@code nonCompliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withNonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("nonCompliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices”</i>
     * 
     * @return property notApplicableDeviceCount
     */
    @Property(name="notApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableDeviceCount() {
        return Optional.ofNullable(notApplicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices”</i>
     * 
     * @param notApplicableDeviceCount
     *            new value of {@code notApplicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withNotApplicableDeviceCount(Integer notApplicableDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of not assigned devices”</i>
     * 
     * @return property notAssignedDeviceCount
     */
    @Property(name="notAssignedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotAssignedDeviceCount() {
        return Optional.ofNullable(notAssignedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notAssignedDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not assigned devices”</i>
     * 
     * @param notAssignedDeviceCount
     *            new value of {@code notAssignedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notAssignedDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withNotAssignedDeviceCount(Integer notAssignedDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notAssignedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.notAssignedDeviceCount = notAssignedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of remediated devices”</i>
     * 
     * @return property remediatedDeviceCount
     */
    @Property(name="remediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedDeviceCount() {
        return Optional.ofNullable(remediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of remediated devices”</i>
     * 
     * @param remediatedDeviceCount
     *            new value of {@code remediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withRemediatedDeviceCount(Integer remediatedDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("remediatedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.remediatedDeviceCount = remediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of unknown devices”</i>
     * 
     * @return property unknownDeviceCount
     */
    @Property(name="unknownDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnknownDeviceCount() {
        return Optional.ofNullable(unknownDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unknownDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of unknown devices”</i>
     * 
     * @param unknownDeviceCount
     *            new value of {@code unknownDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownDeviceCount} field changed
     */
    public AdvancedThreatProtectionOnboardingStateSummary withUnknownDeviceCount(Integer unknownDeviceCount) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    public AdvancedThreatProtectionOnboardingStateSummary withUnmappedField(String name, Object value) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="advancedThreatProtectionOnboardingDeviceSettingStates")
    @JsonIgnore
    public AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest getAdvancedThreatProtectionOnboardingDeviceSettingStates() {
        return new AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest(
                        contextPath.addSegment("advancedThreatProtectionOnboardingDeviceSettingStates"), Optional.ofNullable(advancedThreatProtectionOnboardingDeviceSettingStates));
    }

    public AdvancedThreatProtectionOnboardingStateSummary withAdvancedThreatProtectionOnboardingDeviceSettingStates(List<AdvancedThreatProtectionOnboardingDeviceSettingState> advancedThreatProtectionOnboardingDeviceSettingStates) {
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOnboardingDeviceSettingStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingStateSummary");
        _x.advancedThreatProtectionOnboardingDeviceSettingStates = advancedThreatProtectionOnboardingDeviceSettingStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AdvancedThreatProtectionOnboardingStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AdvancedThreatProtectionOnboardingStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AdvancedThreatProtectionOnboardingStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AdvancedThreatProtectionOnboardingStateSummary _copy() {
        AdvancedThreatProtectionOnboardingStateSummary _x = new AdvancedThreatProtectionOnboardingStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliantDeviceCount = compliantDeviceCount;
        _x.conflictDeviceCount = conflictDeviceCount;
        _x.errorDeviceCount = errorDeviceCount;
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        _x.notAssignedDeviceCount = notAssignedDeviceCount;
        _x.remediatedDeviceCount = remediatedDeviceCount;
        _x.unknownDeviceCount = unknownDeviceCount;
        _x.advancedThreatProtectionOnboardingDeviceSettingStates = advancedThreatProtectionOnboardingDeviceSettingStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AdvancedThreatProtectionOnboardingStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliantDeviceCount=");
        b.append(this.compliantDeviceCount);
        b.append(", ");
        b.append("conflictDeviceCount=");
        b.append(this.conflictDeviceCount);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("nonCompliantDeviceCount=");
        b.append(this.nonCompliantDeviceCount);
        b.append(", ");
        b.append("notApplicableDeviceCount=");
        b.append(this.notApplicableDeviceCount);
        b.append(", ");
        b.append("notAssignedDeviceCount=");
        b.append(this.notAssignedDeviceCount);
        b.append(", ");
        b.append("remediatedDeviceCount=");
        b.append(this.remediatedDeviceCount);
        b.append(", ");
        b.append("unknownDeviceCount=");
        b.append(this.unknownDeviceCount);
        b.append(", ");
        b.append("advancedThreatProtectionOnboardingDeviceSettingStates=");
        b.append(this.advancedThreatProtectionOnboardingDeviceSettingStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
