package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ComplianceStatus;
import odata.msgraph.client.beta.enums.DeviceType;


/**
 * <i>“ATP onboarding State for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "complianceGracePeriodExpirationDateTime", 
    "deviceId", 
    "deviceModel", 
    "deviceName", 
    "platformType", 
    "setting", 
    "settingName", 
    "state", 
    "userEmail", 
    "userId", 
    "userName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AdvancedThreatProtectionOnboardingDeviceSettingState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState";
    }

    @JsonProperty("complianceGracePeriodExpirationDateTime")
    protected OffsetDateTime complianceGracePeriodExpirationDateTime;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceModel")
    protected String deviceModel;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("platformType")
    protected DeviceType platformType;

    @JsonProperty("setting")
    protected String setting;

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("state")
    protected ComplianceStatus state;

    @JsonProperty("userEmail")
    protected String userEmail;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected AdvancedThreatProtectionOnboardingDeviceSettingState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAdvancedThreatProtectionOnboardingDeviceSettingState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime complianceGracePeriodExpirationDateTime;
        private String deviceId;
        private String deviceModel;
        private String deviceName;
        private DeviceType platformType;
        private String setting;
        private String settingName;
        private ComplianceStatus state;
        private String userEmail;
        private String userId;
        private String userName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The DateTime when device compliance grace period expires”</i>
         * 
         * @param complianceGracePeriodExpirationDateTime
         *            value of {@code complianceGracePeriodExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
            this.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            this.changedFields = changedFields.add("complianceGracePeriodExpirationDateTime");
            return this;
        }

        /**
         * <i>“The Device Id that is being reported”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The device model that is being reported”</i>
         * 
         * @param deviceModel
         *            value of {@code deviceModel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            this.changedFields = changedFields.add("deviceModel");
            return this;
        }

        /**
         * <i>“The Device Name that is being reported”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Device platform type”</i>
         * 
         * @param platformType
         *            value of {@code platformType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformType(DeviceType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        /**
         * <i>“The setting class name and property name.”</i>
         * 
         * @param setting
         *            value of {@code setting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setting(String setting) {
            this.setting = setting;
            this.changedFields = changedFields.add("setting");
            return this;
        }

        /**
         * <i>“The Setting Name that is being reported”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        /**
         * <i>“The compliance state of the setting”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(ComplianceStatus state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The User email address that is being reported”</i>
         * 
         * @param userEmail
         *            value of {@code userEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            this.changedFields = changedFields.add("userEmail");
            return this;
        }

        /**
         * <i>“The user Id that is being reported”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The User Name that is being reported”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“The User PrincipalName that is being reported”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public AdvancedThreatProtectionOnboardingDeviceSettingState build() {
            AdvancedThreatProtectionOnboardingDeviceSettingState _x = new AdvancedThreatProtectionOnboardingDeviceSettingState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState";
            _x.id = id;
            _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            _x.deviceId = deviceId;
            _x.deviceModel = deviceModel;
            _x.deviceName = deviceName;
            _x.platformType = platformType;
            _x.setting = setting;
            _x.settingName = settingName;
            _x.state = state;
            _x.userEmail = userEmail;
            _x.userId = userId;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The DateTime when device compliance grace period expires”</i>
     * 
     * @return property complianceGracePeriodExpirationDateTime
     */
    @Property(name="complianceGracePeriodExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComplianceGracePeriodExpirationDateTime() {
        return Optional.ofNullable(complianceGracePeriodExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * complianceGracePeriodExpirationDateTime} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The DateTime when device compliance grace period expires”</i>
     * 
     * @param complianceGracePeriodExpirationDateTime
     *            new value of {@code complianceGracePeriodExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceGracePeriodExpirationDateTime} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withComplianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("complianceGracePeriodExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        return _x;
    }

    /**
     * <i>“The Device Id that is being reported”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Device Id that is being reported”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withDeviceId(String deviceId) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The device model that is being reported”</i>
     * 
     * @return property deviceModel
     */
    @Property(name="deviceModel")
    @JsonIgnore
    public Optional<String> getDeviceModel() {
        return Optional.ofNullable(deviceModel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceModel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The device model that is being reported”</i>
     * 
     * @param deviceModel
     *            new value of {@code deviceModel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceModel} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withDeviceModel(String deviceModel) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("deviceModel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.deviceModel = deviceModel;
        return _x;
    }

    /**
     * <i>“The Device Name that is being reported”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Device Name that is being reported”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withDeviceName(String deviceName) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Device platform type”</i>
     * 
     * @return property platformType
     */
    @Property(name="platformType")
    @JsonIgnore
    public Optional<DeviceType> getPlatformType() {
        return Optional.ofNullable(platformType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device platform type”</i>
     * 
     * @param platformType
     *            new value of {@code platformType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformType} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withPlatformType(DeviceType platformType) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("platformType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.platformType = platformType;
        return _x;
    }

    /**
     * <i>“The setting class name and property name.”</i>
     * 
     * @return property setting
     */
    @Property(name="setting")
    @JsonIgnore
    public Optional<String> getSetting() {
        return Optional.ofNullable(setting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setting} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The setting class name and property name.”</i>
     * 
     * @param setting
     *            new value of {@code setting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setting} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withSetting(String setting) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("setting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.setting = setting;
        return _x;
    }

    /**
     * <i>“The Setting Name that is being reported”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Setting Name that is being reported”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withSettingName(String settingName) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.settingName = settingName;
        return _x;
    }

    /**
     * <i>“The compliance state of the setting”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<ComplianceStatus> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The compliance state of the setting”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withState(ComplianceStatus state) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The User email address that is being reported”</i>
     * 
     * @return property userEmail
     */
    @Property(name="userEmail")
    @JsonIgnore
    public Optional<String> getUserEmail() {
        return Optional.ofNullable(userEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userEmail} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The User email address that is being reported”</i>
     * 
     * @param userEmail
     *            new value of {@code userEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userEmail} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withUserEmail(String userEmail) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("userEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.userEmail = userEmail;
        return _x;
    }

    /**
     * <i>“The user Id that is being reported”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user Id that is being reported”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withUserId(String userId) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The User Name that is being reported”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The User Name that is being reported”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withUserName(String userName) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“The User PrincipalName that is being reported”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The User PrincipalName that is being reported”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState withUserPrincipalName(String userPrincipalName) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.advancedThreatProtectionOnboardingDeviceSettingState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public AdvancedThreatProtectionOnboardingDeviceSettingState withUnmappedField(String name, Object value) {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AdvancedThreatProtectionOnboardingDeviceSettingState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AdvancedThreatProtectionOnboardingDeviceSettingState _copy() {
        AdvancedThreatProtectionOnboardingDeviceSettingState _x = new AdvancedThreatProtectionOnboardingDeviceSettingState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        _x.deviceId = deviceId;
        _x.deviceModel = deviceModel;
        _x.deviceName = deviceName;
        _x.platformType = platformType;
        _x.setting = setting;
        _x.settingName = settingName;
        _x.state = state;
        _x.userEmail = userEmail;
        _x.userId = userId;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AdvancedThreatProtectionOnboardingDeviceSettingState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("complianceGracePeriodExpirationDateTime=");
        b.append(this.complianceGracePeriodExpirationDateTime);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceModel=");
        b.append(this.deviceModel);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("setting=");
        b.append(this.setting);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("userEmail=");
        b.append(this.userEmail);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
