package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewHistoryScheduleSettings;
import odata.msgraph.client.beta.complex.AccessReviewScope;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewHistoryInstanceCollectionRequest;
import odata.msgraph.client.beta.enums.AccessReviewHistoryDecisionFilter;
import odata.msgraph.client.beta.enums.AccessReviewHistoryStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "decisions", 
    "displayName", 
    "downloadUri", 
    "fulfilledDateTime", 
    "reviewHistoryPeriodEndDateTime", 
    "reviewHistoryPeriodStartDateTime", 
    "scheduleSettings", 
    "scopes", 
    "status", 
    "instances"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewHistoryDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewHistoryDefinition";
    }

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("decisions")
    protected List<AccessReviewHistoryDecisionFilter> decisions;

    @JsonProperty("decisions@nextLink")
    protected String decisionsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("downloadUri")
    protected String downloadUri;

    @JsonProperty("fulfilledDateTime")
    protected OffsetDateTime fulfilledDateTime;

    @JsonProperty("reviewHistoryPeriodEndDateTime")
    protected OffsetDateTime reviewHistoryPeriodEndDateTime;

    @JsonProperty("reviewHistoryPeriodStartDateTime")
    protected OffsetDateTime reviewHistoryPeriodStartDateTime;

    @JsonProperty("scheduleSettings")
    protected AccessReviewHistoryScheduleSettings scheduleSettings;

    @JsonProperty("scopes")
    protected List<AccessReviewScope> scopes;

    @JsonProperty("scopes@nextLink")
    protected String scopesNextLink;

    @JsonProperty("status")
    protected AccessReviewHistoryStatus status;

    @JsonProperty("instances")
    protected List<AccessReviewHistoryInstance> instances;

    protected AccessReviewHistoryDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewHistoryDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UserIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private List<AccessReviewHistoryDecisionFilter> decisions;
        private String decisionsNextLink;
        private String displayName;
        private String downloadUri;
        private OffsetDateTime fulfilledDateTime;
        private OffsetDateTime reviewHistoryPeriodEndDateTime;
        private OffsetDateTime reviewHistoryPeriodStartDateTime;
        private AccessReviewHistoryScheduleSettings scheduleSettings;
        private List<AccessReviewScope> scopes;
        private String scopesNextLink;
        private AccessReviewHistoryStatus status;
        private List<AccessReviewHistoryInstance> instances;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder decisions(List<AccessReviewHistoryDecisionFilter> decisions) {
            this.decisions = decisions;
            this.changedFields = changedFields.add("decisions");
            return this;
        }

        public Builder decisions(AccessReviewHistoryDecisionFilter... decisions) {
            return decisions(Arrays.asList(decisions));
        }

        public Builder decisionsNextLink(String decisionsNextLink) {
            this.decisionsNextLink = decisionsNextLink;
            this.changedFields = changedFields.add("decisions");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param downloadUri
         *            value of {@code downloadUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder downloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
            this.changedFields = changedFields.add("downloadUri");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param fulfilledDateTime
         *            value of {@code fulfilledDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fulfilledDateTime(OffsetDateTime fulfilledDateTime) {
            this.fulfilledDateTime = fulfilledDateTime;
            this.changedFields = changedFields.add("fulfilledDateTime");
            return this;
        }

        public Builder reviewHistoryPeriodEndDateTime(OffsetDateTime reviewHistoryPeriodEndDateTime) {
            this.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
            this.changedFields = changedFields.add("reviewHistoryPeriodEndDateTime");
            return this;
        }

        public Builder reviewHistoryPeriodStartDateTime(OffsetDateTime reviewHistoryPeriodStartDateTime) {
            this.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
            this.changedFields = changedFields.add("reviewHistoryPeriodStartDateTime");
            return this;
        }

        public Builder scheduleSettings(AccessReviewHistoryScheduleSettings scheduleSettings) {
            this.scheduleSettings = scheduleSettings;
            this.changedFields = changedFields.add("scheduleSettings");
            return this;
        }

        public Builder scopes(List<AccessReviewScope> scopes) {
            this.scopes = scopes;
            this.changedFields = changedFields.add("scopes");
            return this;
        }

        public Builder scopes(AccessReviewScope... scopes) {
            return scopes(Arrays.asList(scopes));
        }

        public Builder scopesNextLink(String scopesNextLink) {
            this.scopesNextLink = scopesNextLink;
            this.changedFields = changedFields.add("scopes");
            return this;
        }

        public Builder status(AccessReviewHistoryStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder instances(List<AccessReviewHistoryInstance> instances) {
            this.instances = instances;
            this.changedFields = changedFields.add("instances");
            return this;
        }

        public Builder instances(AccessReviewHistoryInstance... instances) {
            return instances(Arrays.asList(instances));
        }

        public AccessReviewHistoryDefinition build() {
            AccessReviewHistoryDefinition _x = new AccessReviewHistoryDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewHistoryDefinition";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.decisions = decisions;
            _x.decisionsNextLink = decisionsNextLink;
            _x.displayName = displayName;
            _x.downloadUri = downloadUri;
            _x.fulfilledDateTime = fulfilledDateTime;
            _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
            _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
            _x.scheduleSettings = scheduleSettings;
            _x.scopes = scopes;
            _x.scopesNextLink = scopesNextLink;
            _x.status = status;
            _x.instances = instances;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessReviewHistoryDefinition withCreatedBy(UserIdentity createdBy) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessReviewHistoryDefinition withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="decisions")
    @JsonIgnore
    public CollectionPage<AccessReviewHistoryDecisionFilter> getDecisions() {
        return new CollectionPage<AccessReviewHistoryDecisionFilter>(contextPath, AccessReviewHistoryDecisionFilter.class, this.decisions, Optional.ofNullable(decisionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewHistoryDefinition withDecisions(List<AccessReviewHistoryDecisionFilter> decisions) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("decisions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.decisions = decisions;
        return _x;
    }

    @Property(name="decisions")
    @JsonIgnore
    public CollectionPage<AccessReviewHistoryDecisionFilter> getDecisions(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewHistoryDecisionFilter>(contextPath, AccessReviewHistoryDecisionFilter.class, this.decisions, Optional.ofNullable(decisionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessReviewHistoryDefinition withDisplayName(String displayName) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property downloadUri
     */
    @Property(name="downloadUri")
    @JsonIgnore
    public Optional<String> getDownloadUri() {
        return Optional.ofNullable(downloadUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code downloadUri}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param downloadUri
     *            new value of {@code downloadUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code downloadUri} field changed
     */
    public AccessReviewHistoryDefinition withDownloadUri(String downloadUri) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("downloadUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.downloadUri = downloadUri;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property fulfilledDateTime
     */
    @Property(name="fulfilledDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFulfilledDateTime() {
        return Optional.ofNullable(fulfilledDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fulfilledDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param fulfilledDateTime
     *            new value of {@code fulfilledDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fulfilledDateTime} field changed
     */
    public AccessReviewHistoryDefinition withFulfilledDateTime(OffsetDateTime fulfilledDateTime) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("fulfilledDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.fulfilledDateTime = fulfilledDateTime;
        return _x;
    }

    @Property(name="reviewHistoryPeriodEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewHistoryPeriodEndDateTime() {
        return Optional.ofNullable(reviewHistoryPeriodEndDateTime);
    }

    public AccessReviewHistoryDefinition withReviewHistoryPeriodEndDateTime(OffsetDateTime reviewHistoryPeriodEndDateTime) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("reviewHistoryPeriodEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
        return _x;
    }

    @Property(name="reviewHistoryPeriodStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewHistoryPeriodStartDateTime() {
        return Optional.ofNullable(reviewHistoryPeriodStartDateTime);
    }

    public AccessReviewHistoryDefinition withReviewHistoryPeriodStartDateTime(OffsetDateTime reviewHistoryPeriodStartDateTime) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("reviewHistoryPeriodStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
        return _x;
    }

    @Property(name="scheduleSettings")
    @JsonIgnore
    public Optional<AccessReviewHistoryScheduleSettings> getScheduleSettings() {
        return Optional.ofNullable(scheduleSettings);
    }

    public AccessReviewHistoryDefinition withScheduleSettings(AccessReviewHistoryScheduleSettings scheduleSettings) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("scheduleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.scheduleSettings = scheduleSettings;
        return _x;
    }

    @Property(name="scopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getScopes() {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.scopes, Optional.ofNullable(scopesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewHistoryDefinition withScopes(List<AccessReviewScope> scopes) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("scopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.scopes = scopes;
        return _x;
    }

    @Property(name="scopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getScopes(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.scopes, Optional.ofNullable(scopesNextLink), Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AccessReviewHistoryStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewHistoryDefinition withStatus(AccessReviewHistoryStatus status) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.status = status;
        return _x;
    }

    public AccessReviewHistoryDefinition withUnmappedField(String name, Object value) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="instances")
    @JsonIgnore
    public AccessReviewHistoryInstanceCollectionRequest getInstances() {
        return new AccessReviewHistoryInstanceCollectionRequest(
                        contextPath.addSegment("instances"), Optional.ofNullable(instances));
    }

    public AccessReviewHistoryDefinition withInstances(List<AccessReviewHistoryInstance> instances) {
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("instances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryDefinition");
        _x.instances = instances;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewHistoryDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewHistoryDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewHistoryDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewHistoryDefinition _copy() {
        AccessReviewHistoryDefinition _x = new AccessReviewHistoryDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.decisions = decisions;
        _x.displayName = displayName;
        _x.downloadUri = downloadUri;
        _x.fulfilledDateTime = fulfilledDateTime;
        _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
        _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
        _x.scheduleSettings = scheduleSettings;
        _x.scopes = scopes;
        _x.status = status;
        _x.instances = instances;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewHistoryDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("decisions=");
        b.append(this.decisions);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("downloadUri=");
        b.append(this.downloadUri);
        b.append(", ");
        b.append("fulfilledDateTime=");
        b.append(this.fulfilledDateTime);
        b.append(", ");
        b.append("reviewHistoryPeriodEndDateTime=");
        b.append(this.reviewHistoryPeriodEndDateTime);
        b.append(", ");
        b.append("reviewHistoryPeriodStartDateTime=");
        b.append(this.reviewHistoryPeriodStartDateTime);
        b.append(", ");
        b.append("scheduleSettings=");
        b.append(this.scheduleSettings);
        b.append(", ");
        b.append("scopes=");
        b.append(this.scopes);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("instances=");
        b.append(this.instances);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
