package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewSettings;
import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewDecisionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewReviewerCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "businessFlowTemplateId", 
    "createdBy", 
    "description", 
    "displayName", 
    "endDateTime", 
    "reviewedEntity", 
    "reviewerType", 
    "settings", 
    "startDateTime", 
    "status", 
    "decisions", 
    "instances", 
    "myDecisions", 
    "reviewers"})
@JsonInclude(Include.NON_NULL)
public class AccessReview extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReview";
    }

    @JsonProperty("businessFlowTemplateId")
    protected String businessFlowTemplateId;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("reviewedEntity")
    protected Identity reviewedEntity;

    @JsonProperty("reviewerType")
    protected String reviewerType;

    @JsonProperty("settings")
    protected AccessReviewSettings settings;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("decisions")
    protected List<AccessReviewDecision> decisions;

    @JsonProperty("instances")
    protected List<AccessReview> instances;

    @JsonProperty("myDecisions")
    protected List<AccessReviewDecision> myDecisions;

    @JsonProperty("reviewers")
    protected List<AccessReviewReviewer> reviewers;

    protected AccessReview() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReview() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String businessFlowTemplateId;
        private UserIdentity createdBy;
        private String description;
        private String displayName;
        private OffsetDateTime endDateTime;
        private Identity reviewedEntity;
        private String reviewerType;
        private AccessReviewSettings settings;
        private OffsetDateTime startDateTime;
        private String status;
        private List<AccessReviewDecision> decisions;
        private List<AccessReview> instances;
        private List<AccessReviewDecision> myDecisions;
        private List<AccessReviewReviewer> reviewers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder businessFlowTemplateId(String businessFlowTemplateId) {
            this.businessFlowTemplateId = businessFlowTemplateId;
            this.changedFields = changedFields.add("businessFlowTemplateId");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder reviewedEntity(Identity reviewedEntity) {
            this.reviewedEntity = reviewedEntity;
            this.changedFields = changedFields.add("reviewedEntity");
            return this;
        }

        public Builder reviewerType(String reviewerType) {
            this.reviewerType = reviewerType;
            this.changedFields = changedFields.add("reviewerType");
            return this;
        }

        public Builder settings(AccessReviewSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder decisions(List<AccessReviewDecision> decisions) {
            this.decisions = decisions;
            this.changedFields = changedFields.add("decisions");
            return this;
        }

        public Builder decisions(AccessReviewDecision... decisions) {
            return decisions(Arrays.asList(decisions));
        }

        public Builder instances(List<AccessReview> instances) {
            this.instances = instances;
            this.changedFields = changedFields.add("instances");
            return this;
        }

        public Builder instances(AccessReview... instances) {
            return instances(Arrays.asList(instances));
        }

        public Builder myDecisions(List<AccessReviewDecision> myDecisions) {
            this.myDecisions = myDecisions;
            this.changedFields = changedFields.add("myDecisions");
            return this;
        }

        public Builder myDecisions(AccessReviewDecision... myDecisions) {
            return myDecisions(Arrays.asList(myDecisions));
        }

        public Builder reviewers(List<AccessReviewReviewer> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(AccessReviewReviewer... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public AccessReview build() {
            AccessReview _x = new AccessReview();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReview";
            _x.id = id;
            _x.businessFlowTemplateId = businessFlowTemplateId;
            _x.createdBy = createdBy;
            _x.description = description;
            _x.displayName = displayName;
            _x.endDateTime = endDateTime;
            _x.reviewedEntity = reviewedEntity;
            _x.reviewerType = reviewerType;
            _x.settings = settings;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.decisions = decisions;
            _x.instances = instances;
            _x.myDecisions = myDecisions;
            _x.reviewers = reviewers;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="businessFlowTemplateId")
    @JsonIgnore
    public Optional<String> getBusinessFlowTemplateId() {
        return Optional.ofNullable(businessFlowTemplateId);
    }

    public AccessReview withBusinessFlowTemplateId(String businessFlowTemplateId) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("businessFlowTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.businessFlowTemplateId = businessFlowTemplateId;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessReview withCreatedBy(UserIdentity createdBy) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessReview withDescription(String description) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessReview withDisplayName(String displayName) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public AccessReview withEndDateTime(OffsetDateTime endDateTime) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="reviewedEntity")
    @JsonIgnore
    public Optional<Identity> getReviewedEntity() {
        return Optional.ofNullable(reviewedEntity);
    }

    public AccessReview withReviewedEntity(Identity reviewedEntity) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("reviewedEntity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.reviewedEntity = reviewedEntity;
        return _x;
    }

    @Property(name="reviewerType")
    @JsonIgnore
    public Optional<String> getReviewerType() {
        return Optional.ofNullable(reviewerType);
    }

    public AccessReview withReviewerType(String reviewerType) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("reviewerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.reviewerType = reviewerType;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<AccessReviewSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public AccessReview withSettings(AccessReviewSettings settings) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.settings = settings;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AccessReview withStartDateTime(OffsetDateTime startDateTime) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReview withStatus(String status) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.status = status;
        return _x;
    }

    public AccessReview withUnmappedField(String name, Object value) {
        AccessReview _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="decisions")
    @JsonIgnore
    public AccessReviewDecisionCollectionRequest getDecisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.ofNullable(decisions));
    }

    @NavigationProperty(name="instances")
    @JsonIgnore
    public AccessReviewCollectionRequest getInstances() {
        return new AccessReviewCollectionRequest(
                        contextPath.addSegment("instances"), Optional.ofNullable(instances));
    }

    @NavigationProperty(name="myDecisions")
    @JsonIgnore
    public AccessReviewDecisionCollectionRequest getMyDecisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("myDecisions"), Optional.ofNullable(myDecisions));
    }

    @NavigationProperty(name="reviewers")
    @JsonIgnore
    public AccessReviewReviewerCollectionRequest getReviewers() {
        return new AccessReviewReviewerCollectionRequest(
                        contextPath.addSegment("reviewers"), Optional.ofNullable(reviewers));
    }

    public AccessReview withDecisions(List<AccessReviewDecision> decisions) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("decisions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.decisions = decisions;
        return _x;
    }

    public AccessReview withInstances(List<AccessReview> instances) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("instances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.instances = instances;
        return _x;
    }

    public AccessReview withMyDecisions(List<AccessReviewDecision> myDecisions) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("myDecisions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.myDecisions = myDecisions;
        return _x;
    }

    public AccessReview withReviewers(List<AccessReviewReviewer> reviewers) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("reviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.reviewers = reviewers;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReview patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReview put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReview _copy() {
        AccessReview _x = new AccessReview();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.businessFlowTemplateId = businessFlowTemplateId;
        _x.createdBy = createdBy;
        _x.description = description;
        _x.displayName = displayName;
        _x.endDateTime = endDateTime;
        _x.reviewedEntity = reviewedEntity;
        _x.reviewerType = reviewerType;
        _x.settings = settings;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.decisions = decisions;
        _x.instances = instances;
        _x.myDecisions = myDecisions;
        _x.reviewers = reviewers;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReview[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("businessFlowTemplateId=");
        b.append(this.businessFlowTemplateId);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("reviewedEntity=");
        b.append(this.reviewedEntity);
        b.append(", ");
        b.append("reviewerType=");
        b.append(this.reviewerType);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("decisions=");
        b.append(this.decisions);
        b.append(", ");
        b.append("instances=");
        b.append(this.instances);
        b.append(", ");
        b.append("myDecisions=");
        b.append(this.myDecisions);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
