package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isRootScope", 
    "originId", 
    "originSystem", 
    "roleOriginId", 
    "url", 
    "accessPackageResource"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceScope extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceScope";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isRootScope")
    protected Boolean isRootScope;

    @JsonProperty("originId")
    protected String originId;

    @JsonProperty("originSystem")
    protected String originSystem;

    @JsonProperty("roleOriginId")
    protected String roleOriginId;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("accessPackageResource")
    protected AccessPackageResource accessPackageResource;

    protected AccessPackageResourceScope() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResourceScope() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Boolean isRootScope;
        private String originId;
        private String originSystem;
        private String roleOriginId;
        private String url;
        private AccessPackageResource accessPackageResource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isRootScope(Boolean isRootScope) {
            this.isRootScope = isRootScope;
            this.changedFields = changedFields.add("isRootScope");
            return this;
        }

        public Builder originId(String originId) {
            this.originId = originId;
            this.changedFields = changedFields.add("originId");
            return this;
        }

        public Builder originSystem(String originSystem) {
            this.originSystem = originSystem;
            this.changedFields = changedFields.add("originSystem");
            return this;
        }

        public Builder roleOriginId(String roleOriginId) {
            this.roleOriginId = roleOriginId;
            this.changedFields = changedFields.add("roleOriginId");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder accessPackageResource(AccessPackageResource accessPackageResource) {
            this.accessPackageResource = accessPackageResource;
            this.changedFields = changedFields.add("accessPackageResource");
            return this;
        }

        public AccessPackageResourceScope build() {
            AccessPackageResourceScope _x = new AccessPackageResourceScope();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResourceScope";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.isRootScope = isRootScope;
            _x.originId = originId;
            _x.originSystem = originSystem;
            _x.roleOriginId = roleOriginId;
            _x.url = url;
            _x.accessPackageResource = accessPackageResource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageResourceScope withDescription(String description) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageResourceScope withDisplayName(String displayName) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isRootScope")
    @JsonIgnore
    public Optional<Boolean> getIsRootScope() {
        return Optional.ofNullable(isRootScope);
    }

    public AccessPackageResourceScope withIsRootScope(Boolean isRootScope) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("isRootScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.isRootScope = isRootScope;
        return _x;
    }

    @Property(name="originId")
    @JsonIgnore
    public Optional<String> getOriginId() {
        return Optional.ofNullable(originId);
    }

    public AccessPackageResourceScope withOriginId(String originId) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("originId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.originId = originId;
        return _x;
    }

    @Property(name="originSystem")
    @JsonIgnore
    public Optional<String> getOriginSystem() {
        return Optional.ofNullable(originSystem);
    }

    public AccessPackageResourceScope withOriginSystem(String originSystem) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("originSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.originSystem = originSystem;
        return _x;
    }

    @Property(name="roleOriginId")
    @JsonIgnore
    public Optional<String> getRoleOriginId() {
        return Optional.ofNullable(roleOriginId);
    }

    public AccessPackageResourceScope withRoleOriginId(String roleOriginId) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("roleOriginId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.roleOriginId = roleOriginId;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public AccessPackageResourceScope withUrl(String url) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.url = url;
        return _x;
    }

    public AccessPackageResourceScope withUnmappedField(String name, Object value) {
        AccessPackageResourceScope _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageResource")
    @JsonIgnore
    public AccessPackageResourceRequest getAccessPackageResource() {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResource"), Optional.ofNullable(accessPackageResource));
    }

    public AccessPackageResourceScope withAccessPackageResource(AccessPackageResource accessPackageResource) {
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceScope");
        _x.accessPackageResource = accessPackageResource;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceScope patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceScope put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceScope _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResourceScope _copy() {
        AccessPackageResourceScope _x = new AccessPackageResourceScope();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.isRootScope = isRootScope;
        _x.originId = originId;
        _x.originSystem = originSystem;
        _x.roleOriginId = roleOriginId;
        _x.url = url;
        _x.accessPackageResource = accessPackageResource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceScope[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isRootScope=");
        b.append(this.isRootScope);
        b.append(", ");
        b.append("originId=");
        b.append(this.originId);
        b.append(", ");
        b.append("originSystem=");
        b.append(this.originSystem);
        b.append(", ");
        b.append("roleOriginId=");
        b.append(this.roleOriginId);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("accessPackageResource=");
        b.append(this.accessPackageResource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
