package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "originId", 
    "originSystem", 
    "status", 
    "accessPackageAssignments", 
    "accessPackageResourceRole", 
    "accessPackageResourceScope", 
    "accessPackageSubject"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAssignmentResourceRole extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAssignmentResourceRole";
    }

    @JsonProperty("originId")
    protected String originId;

    @JsonProperty("originSystem")
    protected String originSystem;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("accessPackageAssignments")
    protected List<AccessPackageAssignment> accessPackageAssignments;

    @JsonProperty("accessPackageResourceRole")
    protected AccessPackageResourceRole accessPackageResourceRole;

    @JsonProperty("accessPackageResourceScope")
    protected AccessPackageResourceScope accessPackageResourceScope;

    @JsonProperty("accessPackageSubject")
    protected AccessPackageSubject accessPackageSubject;

    protected AccessPackageAssignmentResourceRole() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageAssignmentResourceRole() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String originId;
        private String originSystem;
        private String status;
        private List<AccessPackageAssignment> accessPackageAssignments;
        private AccessPackageResourceRole accessPackageResourceRole;
        private AccessPackageResourceScope accessPackageResourceScope;
        private AccessPackageSubject accessPackageSubject;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder originId(String originId) {
            this.originId = originId;
            this.changedFields = changedFields.add("originId");
            return this;
        }

        public Builder originSystem(String originSystem) {
            this.originSystem = originSystem;
            this.changedFields = changedFields.add("originSystem");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder accessPackageAssignments(List<AccessPackageAssignment> accessPackageAssignments) {
            this.accessPackageAssignments = accessPackageAssignments;
            this.changedFields = changedFields.add("accessPackageAssignments");
            return this;
        }

        public Builder accessPackageAssignments(AccessPackageAssignment... accessPackageAssignments) {
            return accessPackageAssignments(Arrays.asList(accessPackageAssignments));
        }

        public Builder accessPackageResourceRole(AccessPackageResourceRole accessPackageResourceRole) {
            this.accessPackageResourceRole = accessPackageResourceRole;
            this.changedFields = changedFields.add("accessPackageResourceRole");
            return this;
        }

        public Builder accessPackageResourceScope(AccessPackageResourceScope accessPackageResourceScope) {
            this.accessPackageResourceScope = accessPackageResourceScope;
            this.changedFields = changedFields.add("accessPackageResourceScope");
            return this;
        }

        public Builder accessPackageSubject(AccessPackageSubject accessPackageSubject) {
            this.accessPackageSubject = accessPackageSubject;
            this.changedFields = changedFields.add("accessPackageSubject");
            return this;
        }

        public AccessPackageAssignmentResourceRole build() {
            AccessPackageAssignmentResourceRole _x = new AccessPackageAssignmentResourceRole();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageAssignmentResourceRole";
            _x.id = id;
            _x.originId = originId;
            _x.originSystem = originSystem;
            _x.status = status;
            _x.accessPackageAssignments = accessPackageAssignments;
            _x.accessPackageResourceRole = accessPackageResourceRole;
            _x.accessPackageResourceScope = accessPackageResourceScope;
            _x.accessPackageSubject = accessPackageSubject;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="originId")
    @JsonIgnore
    public Optional<String> getOriginId() {
        return Optional.ofNullable(originId);
    }

    public AccessPackageAssignmentResourceRole withOriginId(String originId) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("originId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.originId = originId;
        return _x;
    }

    @Property(name="originSystem")
    @JsonIgnore
    public Optional<String> getOriginSystem() {
        return Optional.ofNullable(originSystem);
    }

    public AccessPackageAssignmentResourceRole withOriginSystem(String originSystem) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("originSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.originSystem = originSystem;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessPackageAssignmentResourceRole withStatus(String status) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.status = status;
        return _x;
    }

    public AccessPackageAssignmentResourceRole withUnmappedField(String name, Object value) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageAssignments")
    @JsonIgnore
    public AccessPackageAssignmentCollectionRequest getAccessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"), Optional.ofNullable(accessPackageAssignments));
    }

    @NavigationProperty(name="accessPackageResourceRole")
    @JsonIgnore
    public AccessPackageResourceRoleRequest getAccessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"), Optional.ofNullable(accessPackageResourceRole));
    }

    @NavigationProperty(name="accessPackageResourceScope")
    @JsonIgnore
    public AccessPackageResourceScopeRequest getAccessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"), Optional.ofNullable(accessPackageResourceScope));
    }

    @NavigationProperty(name="accessPackageSubject")
    @JsonIgnore
    public AccessPackageSubjectRequest getAccessPackageSubject() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("accessPackageSubject"), Optional.ofNullable(accessPackageSubject));
    }

    public AccessPackageAssignmentResourceRole withAccessPackageAssignments(List<AccessPackageAssignment> accessPackageAssignments) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.accessPackageAssignments = accessPackageAssignments;
        return _x;
    }

    public AccessPackageAssignmentResourceRole withAccessPackageResourceRole(AccessPackageResourceRole accessPackageResourceRole) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.accessPackageResourceRole = accessPackageResourceRole;
        return _x;
    }

    public AccessPackageAssignmentResourceRole withAccessPackageResourceScope(AccessPackageResourceScope accessPackageResourceScope) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.accessPackageResourceScope = accessPackageResourceScope;
        return _x;
    }

    public AccessPackageAssignmentResourceRole withAccessPackageSubject(AccessPackageSubject accessPackageSubject) {
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = changedFields.add("accessPackageSubject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentResourceRole");
        _x.accessPackageSubject = accessPackageSubject;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentResourceRole patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentResourceRole put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentResourceRole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageAssignmentResourceRole _copy() {
        AccessPackageAssignmentResourceRole _x = new AccessPackageAssignmentResourceRole();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.originId = originId;
        _x.originSystem = originSystem;
        _x.status = status;
        _x.accessPackageAssignments = accessPackageAssignments;
        _x.accessPackageResourceRole = accessPackageResourceRole;
        _x.accessPackageResourceScope = accessPackageResourceScope;
        _x.accessPackageSubject = accessPackageSubject;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAssignmentResourceRole[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("originId=");
        b.append(this.originId);
        b.append(", ");
        b.append("originSystem=");
        b.append(this.originSystem);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("accessPackageAssignments=");
        b.append(this.accessPackageAssignments);
        b.append(", ");
        b.append("accessPackageResourceRole=");
        b.append(this.accessPackageResourceRole);
        b.append(", ");
        b.append("accessPackageResourceScope=");
        b.append(this.accessPackageResourceScope);
        b.append(", ");
        b.append("accessPackageSubject=");
        b.append(this.accessPackageSubject);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
