package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LegalHoldStatus implements Enum {

    @JsonProperty("Pending")
    PENDING("Pending", "0"),

    @JsonProperty("Error")
    ERROR("Error", "1"),

    @JsonProperty("Success")
    SUCCESS("Success", "2"),

    @JsonProperty("UnknownFutureValue")
    UNKNOWN_FUTURE_VALUE("UnknownFutureValue", "3");

    private final String name;
    private final String value;

    private LegalHoldStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
