package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ExportOptions implements Enum {

    @JsonProperty("originalFiles")
    ORIGINAL_FILES("originalFiles", "1"),

    @JsonProperty("text")
    TEXT("text", "2"),

    @JsonProperty("pdfReplacement")
    PDF_REPLACEMENT("pdfReplacement", "4"),

    @JsonProperty("fileInfo")
    FILE_INFO("fileInfo", "8"),

    @JsonProperty("tags")
    TAGS("tags", "16"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "32");

    private final String name;
    private final String value;

    private ExportOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
