package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DataSourceScopes implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("allTenantMailboxes")
    ALL_TENANT_MAILBOXES("allTenantMailboxes", "1"),

    @JsonProperty("allTenantSites")
    ALL_TENANT_SITES("allTenantSites", "2"),

    @JsonProperty("allCaseCustodians")
    ALL_CASE_CUSTODIANS("allCaseCustodians", "4"),

    @JsonProperty("allCaseNoncustodialDataSources")
    ALL_CASE_NONCUSTODIAL_DATA_SOURCES("allCaseNoncustodialDataSources", "8"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "16");

    private final String name;
    private final String value;

    private DataSourceScopes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
