package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DataSourceHoldStatus implements Enum {

    @JsonProperty("notApplied")
    NOT_APPLIED("notApplied", "1"),

    @JsonProperty("applied")
    APPLIED("applied", "2"),

    @JsonProperty("applying")
    APPLYING("applying", "3"),

    @JsonProperty("removing")
    REMOVING("removing", "4"),

    @JsonProperty("partial")
    PARTIAL("partial", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private DataSourceHoldStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
