package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ChildSelectability implements Enum {

    @JsonProperty("One")
    ONE("One", "0"),

    @JsonProperty("Many")
    MANY("Many", "1");

    private final String name;
    private final String value;

    private ChildSelectability(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
