package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Tag;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.TagCollectionRequest;

@JsonIgnoreType
public class TagRequest extends EntityRequest<Tag> {

    public TagRequest(ContextPath contextPath, Optional<Object> value) {
        super(Tag.class, contextPath, value, false);
    }

    public TagRequest childTags(String id) {
        return new TagRequest(contextPath.addSegment("childTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TagCollectionRequest childTags() {
        return new TagCollectionRequest(
                        contextPath.addSegment("childTags"), Optional.empty());
    }

    public TagRequest parent() {
        return new TagRequest(contextPath.addSegment("parent"), Optional.empty());
    }

}
