package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.ReviewSet;
import odata.msgraph.client.beta.ediscovery.entity.SourceCollection;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.ReviewSetQueryCollectionRequest;
import odata.msgraph.client.beta.ediscovery.enums.AdditionalDataOptions;
import odata.msgraph.client.beta.ediscovery.enums.ExportFileStructure;
import odata.msgraph.client.beta.ediscovery.enums.ExportOptions;

@JsonIgnoreType
public class ReviewSetRequest extends EntityRequest<ReviewSet> {

    public ReviewSetRequest(ContextPath contextPath, Optional<Object> value) {
        super(ReviewSet.class, contextPath, value, false);
    }

    public ReviewSetQueryRequest queries(String id) {
        return new ReviewSetQueryRequest(contextPath.addSegment("queries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ReviewSetQueryCollectionRequest queries() {
        return new ReviewSetQueryCollectionRequest(
                        contextPath.addSegment("queries"), Optional.empty());
    }

    @Action(name = "addToReviewSet")
    @JsonIgnore
    public ActionRequestNoReturn addToReviewSet(SourceCollection sourceCollection, AdditionalDataOptions additionalDataOptions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceCollection", "microsoft.graph.ediscovery.sourceCollection", sourceCollection)
            .put("additionalDataOptions", "microsoft.graph.ediscovery.additionalDataOptions", additionalDataOptions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.addToReviewSet"), _parameters);
    }

    @Action(name = "export")
    @JsonIgnore
    public ActionRequestNoReturn export(String outputName, String description, String azureBlobContainer, String azureBlobToken, ExportOptions exportOptions, ExportFileStructure exportStructure) {
        Preconditions.checkNotNull(exportStructure, "exportStructure cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("outputName", "Edm.String", Checks.checkIsAscii(outputName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("azureBlobContainer", "Edm.String", Checks.checkIsAscii(azureBlobContainer))
            .put("azureBlobToken", "Edm.String", Checks.checkIsAscii(azureBlobToken))
            .put("exportOptions", "microsoft.graph.ediscovery.exportOptions", exportOptions)
            .put("exportStructure", "microsoft.graph.ediscovery.exportFileStructure", exportStructure)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.export"), _parameters);
    }

}
