package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.LegalHold;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.SiteSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UnifiedGroupSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UserSourceCollectionRequest;

@JsonIgnoreType
public class LegalHoldRequest extends EntityRequest<LegalHold> {

    public LegalHoldRequest(ContextPath contextPath, Optional<Object> value) {
        super(LegalHold.class, contextPath, value, false);
    }

    public SiteSourceRequest siteSources(String id) {
        return new SiteSourceRequest(contextPath.addSegment("siteSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteSourceCollectionRequest siteSources() {
        return new SiteSourceCollectionRequest(
                        contextPath.addSegment("siteSources"), Optional.empty());
    }

    public UnifiedGroupSourceRequest unifiedGroupSources(String id) {
        return new UnifiedGroupSourceRequest(contextPath.addSegment("unifiedGroupSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedGroupSourceCollectionRequest unifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(
                        contextPath.addSegment("unifiedGroupSources"), Optional.empty());
    }

    public UserSourceRequest userSources(String id) {
        return new UserSourceRequest(contextPath.addSegment("userSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserSourceCollectionRequest userSources() {
        return new UserSourceCollectionRequest(
                        contextPath.addSegment("userSources"), Optional.empty());
    }

}
