package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Ediscoveryroot;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.CaseCollectionRequest;

@JsonIgnoreType
public class EdiscoveryrootRequest extends EntityRequest<Ediscoveryroot> {

    public EdiscoveryrootRequest(ContextPath contextPath, Optional<Object> value) {
        super(Ediscoveryroot.class, contextPath, value, false);
    }

    public CaseRequest cases(String id) {
        return new CaseRequest(contextPath.addSegment("cases").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CaseCollectionRequest cases() {
        return new CaseCollectionRequest(
                        contextPath.addSegment("cases"), Optional.empty());
    }

}
