package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Custodian;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.SiteSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UnifiedGroupSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UserSourceCollectionRequest;

@JsonIgnoreType
public class CustodianRequest extends EntityRequest<Custodian> {

    public CustodianRequest(ContextPath contextPath, Optional<Object> value) {
        super(Custodian.class, contextPath, value, false);
    }

    public SiteSourceRequest siteSources(String id) {
        return new SiteSourceRequest(contextPath.addSegment("siteSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteSourceCollectionRequest siteSources() {
        return new SiteSourceCollectionRequest(
                        contextPath.addSegment("siteSources"), Optional.empty());
    }

    public UnifiedGroupSourceRequest unifiedGroupSources(String id) {
        return new UnifiedGroupSourceRequest(contextPath.addSegment("unifiedGroupSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedGroupSourceCollectionRequest unifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(
                        contextPath.addSegment("unifiedGroupSources"), Optional.empty());
    }

    public UserSourceRequest userSources(String id) {
        return new UserSourceRequest(contextPath.addSegment("userSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserSourceCollectionRequest userSources() {
        return new UserSourceCollectionRequest(
                        contextPath.addSegment("userSources"), Optional.empty());
    }

    @Action(name = "activate")
    @JsonIgnore
    public ActionRequestNoReturn activate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.activate"), _parameters);
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "release")
    @JsonIgnore
    public ActionRequestNoReturn release() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.release"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

    @Action(name = "updateIndex")
    @JsonIgnore
    public ActionRequestNoReturn updateIndex() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.updateIndex"), _parameters);
    }

}
