package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.CaseSettings;

@JsonIgnoreType
public class CaseSettingsRequest extends EntityRequest<CaseSettings> {

    public CaseSettingsRequest(ContextPath contextPath, Optional<Object> value) {
        super(CaseSettings.class, contextPath, value, false);
    }

    @Action(name = "resetToDefault")
    @JsonIgnore
    public ActionRequestNoReturn resetToDefault() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.resetToDefault"), _parameters);
    }

}
