package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Case;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.CaseOperationCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.CustodianCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.LegalHoldCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.NoncustodialDataSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.ReviewSetCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.SourceCollectionCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.TagCollectionRequest;

@JsonIgnoreType
public class CaseRequest extends EntityRequest<Case> {

    public CaseRequest(ContextPath contextPath, Optional<Object> value) {
        super(Case.class, contextPath, value, false);
    }

    public CustodianRequest custodians(String id) {
        return new CustodianRequest(contextPath.addSegment("custodians").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustodianCollectionRequest custodians() {
        return new CustodianCollectionRequest(
                        contextPath.addSegment("custodians"), Optional.empty());
    }

    public LegalHoldRequest legalHolds(String id) {
        return new LegalHoldRequest(contextPath.addSegment("legalHolds").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LegalHoldCollectionRequest legalHolds() {
        return new LegalHoldCollectionRequest(
                        contextPath.addSegment("legalHolds"), Optional.empty());
    }

    public NoncustodialDataSourceRequest noncustodialDataSources(String id) {
        return new NoncustodialDataSourceRequest(contextPath.addSegment("noncustodialDataSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NoncustodialDataSourceCollectionRequest noncustodialDataSources() {
        return new NoncustodialDataSourceCollectionRequest(
                        contextPath.addSegment("noncustodialDataSources"), Optional.empty());
    }

    public CaseOperationRequest operations(String id) {
        return new CaseOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CaseOperationCollectionRequest operations() {
        return new CaseOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public ReviewSetRequest reviewSets(String id) {
        return new ReviewSetRequest(contextPath.addSegment("reviewSets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ReviewSetCollectionRequest reviewSets() {
        return new ReviewSetCollectionRequest(
                        contextPath.addSegment("reviewSets"), Optional.empty());
    }

    public CaseSettingsRequest settings() {
        return new CaseSettingsRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    public SourceCollectionRequest sourceCollections(String id) {
        return new SourceCollectionRequest(contextPath.addSegment("sourceCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SourceCollectionCollectionRequest sourceCollections() {
        return new SourceCollectionCollectionRequest(
                        contextPath.addSegment("sourceCollections"), Optional.empty());
    }

    public TagRequest tags(String id) {
        return new TagRequest(contextPath.addSegment("tags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(
                        contextPath.addSegment("tags"), Optional.empty());
    }

    @Action(name = "close")
    @JsonIgnore
    public ActionRequestNoReturn close() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.close"), _parameters);
    }

    @Action(name = "reopen")
    @JsonIgnore
    public ActionRequestNoReturn reopen() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.reopen"), _parameters);
    }

}
