package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.AddToReviewSetOperation;

@JsonIgnoreType
public class AddToReviewSetOperationRequest extends EntityRequest<AddToReviewSetOperation> {

    public AddToReviewSetOperationRequest(ContextPath contextPath, Optional<Object> value) {
        super(AddToReviewSetOperation.class, contextPath, value, false);
    }

    public ReviewSetRequest reviewSet() {
        return new ReviewSetRequest(contextPath.addSegment("reviewSet"), Optional.empty());
    }

    public SourceCollectionRequest sourceCollection() {
        return new SourceCollectionRequest(contextPath.addSegment("sourceCollection"), Optional.empty());
    }

}
