package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Tag;
import odata.msgraph.client.beta.ediscovery.entity.request.TagRequest;

public class TagCollectionRequest extends CollectionPageEntityRequest<Tag, TagRequest>{

    protected ContextPath contextPath;

    public TagCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Tag.class, cp -> new TagRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TagRequest childTags(String id) {
        return new TagRequest(contextPath.addSegment("childTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TagCollectionRequest childTags() {
        return new TagCollectionRequest(contextPath.addSegment("childTags"), Optional.empty());
    }

    @Function(name = "asHierarchy")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Tag> asHierarchy() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.asHierarchy"), Tag.class, _parameters);
    }

}
