package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.ReviewSet;
import odata.msgraph.client.beta.ediscovery.entity.request.ReviewSetQueryRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.ReviewSetRequest;

public class ReviewSetCollectionRequest extends CollectionPageEntityRequest<ReviewSet, ReviewSetRequest>{

    protected ContextPath contextPath;

    public ReviewSetCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ReviewSet.class, cp -> new ReviewSetRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ReviewSetQueryRequest queries(String id) {
        return new ReviewSetQueryRequest(contextPath.addSegment("queries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ReviewSetQueryCollectionRequest queries() {
        return new ReviewSetQueryCollectionRequest(contextPath.addSegment("queries"), Optional.empty());
    }

}
