package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.LegalHold;
import odata.msgraph.client.beta.ediscovery.entity.request.LegalHoldRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.SiteSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.UnifiedGroupSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.UserSourceRequest;

public class LegalHoldCollectionRequest extends CollectionPageEntityRequest<LegalHold, LegalHoldRequest>{

    protected ContextPath contextPath;

    public LegalHoldCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, LegalHold.class, cp -> new LegalHoldRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SiteSourceRequest siteSources(String id) {
        return new SiteSourceRequest(contextPath.addSegment("siteSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteSourceCollectionRequest siteSources() {
        return new SiteSourceCollectionRequest(contextPath.addSegment("siteSources"), Optional.empty());
    }

    public UnifiedGroupSourceRequest unifiedGroupSources(String id) {
        return new UnifiedGroupSourceRequest(contextPath.addSegment("unifiedGroupSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedGroupSourceCollectionRequest unifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(contextPath.addSegment("unifiedGroupSources"), Optional.empty());
    }

    public UserSourceRequest userSources(String id) {
        return new UserSourceRequest(contextPath.addSegment("userSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserSourceCollectionRequest userSources() {
        return new UserSourceCollectionRequest(contextPath.addSegment("userSources"), Optional.empty());
    }

}
