package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Custodian;
import odata.msgraph.client.beta.ediscovery.entity.request.CustodianRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.SiteSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.UnifiedGroupSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.UserSourceRequest;

public class CustodianCollectionRequest extends CollectionPageEntityRequest<Custodian, CustodianRequest>{

    protected ContextPath contextPath;

    public CustodianCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Custodian.class, cp -> new CustodianRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SiteSourceRequest siteSources(String id) {
        return new SiteSourceRequest(contextPath.addSegment("siteSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteSourceCollectionRequest siteSources() {
        return new SiteSourceCollectionRequest(contextPath.addSegment("siteSources"), Optional.empty());
    }

    public UnifiedGroupSourceRequest unifiedGroupSources(String id) {
        return new UnifiedGroupSourceRequest(contextPath.addSegment("unifiedGroupSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedGroupSourceCollectionRequest unifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(contextPath.addSegment("unifiedGroupSources"), Optional.empty());
    }

    public UserSourceRequest userSources(String id) {
        return new UserSourceRequest(contextPath.addSegment("userSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserSourceCollectionRequest userSources() {
        return new UserSourceCollectionRequest(contextPath.addSegment("userSources"), Optional.empty());
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold(List<String> ids) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold(List<String> ids) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

}
