package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.DataSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.NoncustodialDataSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.AddToReviewSetOperationRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.EstimateStatisticsOperationRequest;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceScopes;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "contentQuery", 
    "createdBy", 
    "createdDateTime", 
    "dataSourceScopes", 
    "description", 
    "displayName", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "additionalSources"})
@JsonInclude(Include.NON_NULL)
public class SourceCollection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.sourceCollection";
    }

    @JsonProperty("contentQuery")
    protected String contentQuery;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("dataSourceScopes")
    protected DataSourceScopes dataSourceScopes;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("additionalSources")
    protected List<DataSource> additionalSources;

    protected SourceCollection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSourceCollection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String contentQuery;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private DataSourceScopes dataSourceScopes;
        private String description;
        private String displayName;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<DataSource> additionalSources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contentQuery(String contentQuery) {
            this.contentQuery = contentQuery;
            this.changedFields = changedFields.add("contentQuery");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dataSourceScopes(DataSourceScopes dataSourceScopes) {
            this.dataSourceScopes = dataSourceScopes;
            this.changedFields = changedFields.add("dataSourceScopes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder additionalSources(List<DataSource> additionalSources) {
            this.additionalSources = additionalSources;
            this.changedFields = changedFields.add("additionalSources");
            return this;
        }

        public Builder additionalSources(DataSource... additionalSources) {
            return additionalSources(Arrays.asList(additionalSources));
        }

        public SourceCollection build() {
            SourceCollection _x = new SourceCollection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.sourceCollection";
            _x.id = id;
            _x.contentQuery = contentQuery;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.dataSourceScopes = dataSourceScopes;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.additionalSources = additionalSources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contentQuery")
    @JsonIgnore
    public Optional<String> getContentQuery() {
        return Optional.ofNullable(contentQuery);
    }

    public SourceCollection withContentQuery(String contentQuery) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("contentQuery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.contentQuery = contentQuery;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public SourceCollection withCreatedBy(IdentitySet createdBy) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SourceCollection withCreatedDateTime(OffsetDateTime createdDateTime) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="dataSourceScopes")
    @JsonIgnore
    public Optional<DataSourceScopes> getDataSourceScopes() {
        return Optional.ofNullable(dataSourceScopes);
    }

    public SourceCollection withDataSourceScopes(DataSourceScopes dataSourceScopes) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("dataSourceScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.dataSourceScopes = dataSourceScopes;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SourceCollection withDescription(String description) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SourceCollection withDisplayName(String displayName) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public SourceCollection withLastModifiedBy(IdentitySet lastModifiedBy) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SourceCollection withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public SourceCollection withUnmappedField(String name, Object value) {
        SourceCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="additionalSources")
    @JsonIgnore
    public DataSourceCollectionRequest getAdditionalSources() {
        return new DataSourceCollectionRequest(
                        contextPath.addSegment("additionalSources"), Optional.ofNullable(additionalSources));
    }

    @NavigationProperty(name="addToReviewSetOperation")
    @JsonIgnore
    public AddToReviewSetOperationRequest getAddToReviewSetOperation() {
        return new AddToReviewSetOperationRequest(contextPath.addSegment("addToReviewSetOperation"), RequestHelper.getValue(unmappedFields, "addToReviewSetOperation"));
    }

    @NavigationProperty(name="custodianSources")
    @JsonIgnore
    public DataSourceCollectionRequest getCustodianSources() {
        return new DataSourceCollectionRequest(
                        contextPath.addSegment("custodianSources"), RequestHelper.getValue(unmappedFields, "custodianSources"));
    }

    @NavigationProperty(name="lastEstimateStatisticsOperation")
    @JsonIgnore
    public EstimateStatisticsOperationRequest getLastEstimateStatisticsOperation() {
        return new EstimateStatisticsOperationRequest(contextPath.addSegment("lastEstimateStatisticsOperation"), RequestHelper.getValue(unmappedFields, "lastEstimateStatisticsOperation"));
    }

    @NavigationProperty(name="noncustodialSources")
    @JsonIgnore
    public NoncustodialDataSourceCollectionRequest getNoncustodialSources() {
        return new NoncustodialDataSourceCollectionRequest(
                        contextPath.addSegment("noncustodialSources"), RequestHelper.getValue(unmappedFields, "noncustodialSources"));
    }

    public SourceCollection withAdditionalSources(List<DataSource> additionalSources) {
        SourceCollection _x = _copy();
        _x.changedFields = changedFields.add("additionalSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.sourceCollection");
        _x.additionalSources = additionalSources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SourceCollection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SourceCollection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SourceCollection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SourceCollection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SourceCollection _copy() {
        SourceCollection _x = new SourceCollection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contentQuery = contentQuery;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.dataSourceScopes = dataSourceScopes;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.additionalSources = additionalSources;
        return _x;
    }

    @Action(name = "estimateStatistics")
    @JsonIgnore
    public ActionRequestNoReturn estimateStatistics() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.estimateStatistics"), _parameters);
    }

    @Action(name = "purgeData")
    @JsonIgnore
    public ActionRequestNoReturn purgeData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.purgeData"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SourceCollection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contentQuery=");
        b.append(this.contentQuery);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dataSourceScopes=");
        b.append(this.dataSourceScopes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("additionalSources=");
        b.append(this.additionalSources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
