package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.ReviewSetQueryCollectionRequest;
import odata.msgraph.client.beta.ediscovery.enums.AdditionalDataOptions;
import odata.msgraph.client.beta.ediscovery.enums.ExportFileStructure;
import odata.msgraph.client.beta.ediscovery.enums.ExportOptions;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "displayName", 
    "queries"})
@JsonInclude(Include.NON_NULL)
public class ReviewSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.reviewSet";
    }

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("queries")
    protected List<ReviewSetQuery> queries;

    protected ReviewSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderReviewSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private List<ReviewSetQuery> queries;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder queries(List<ReviewSetQuery> queries) {
            this.queries = queries;
            this.changedFields = changedFields.add("queries");
            return this;
        }

        public Builder queries(ReviewSetQuery... queries) {
            return queries(Arrays.asList(queries));
        }

        public ReviewSet build() {
            ReviewSet _x = new ReviewSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.reviewSet";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.queries = queries;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public ReviewSet withCreatedBy(IdentitySet createdBy) {
        ReviewSet _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.reviewSet");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ReviewSet withCreatedDateTime(OffsetDateTime createdDateTime) {
        ReviewSet _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.reviewSet");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ReviewSet withDisplayName(String displayName) {
        ReviewSet _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.reviewSet");
        _x.displayName = displayName;
        return _x;
    }

    public ReviewSet withUnmappedField(String name, Object value) {
        ReviewSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="queries")
    @JsonIgnore
    public ReviewSetQueryCollectionRequest getQueries() {
        return new ReviewSetQueryCollectionRequest(
                        contextPath.addSegment("queries"), Optional.ofNullable(queries));
    }

    public ReviewSet withQueries(List<ReviewSetQuery> queries) {
        ReviewSet _x = _copy();
        _x.changedFields = changedFields.add("queries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.reviewSet");
        _x.queries = queries;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReviewSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReviewSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReviewSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReviewSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReviewSet _copy() {
        ReviewSet _x = new ReviewSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.queries = queries;
        return _x;
    }

    @Action(name = "addToReviewSet")
    @JsonIgnore
    public ActionRequestNoReturn addToReviewSet(SourceCollection sourceCollection, AdditionalDataOptions additionalDataOptions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceCollection", "microsoft.graph.ediscovery.sourceCollection", sourceCollection)
            .put("additionalDataOptions", "microsoft.graph.ediscovery.additionalDataOptions", additionalDataOptions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.addToReviewSet"), _parameters);
    }

    @Action(name = "export")
    @JsonIgnore
    public ActionRequestNoReturn export(String outputName, String description, String azureBlobContainer, String azureBlobToken, ExportOptions exportOptions, ExportFileStructure exportStructure) {
        Preconditions.checkNotNull(exportStructure, "exportStructure cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("outputName", "Edm.String", Checks.checkIsAscii(outputName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("azureBlobContainer", "Edm.String", Checks.checkIsAscii(azureBlobContainer))
            .put("azureBlobToken", "Edm.String", Checks.checkIsAscii(azureBlobToken))
            .put("exportOptions", "microsoft.graph.ediscovery.exportOptions", exportOptions)
            .put("exportStructure", "microsoft.graph.ediscovery.exportFileStructure", exportStructure)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.export"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReviewSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("queries=");
        b.append(this.queries);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
