package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.SiteSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UnifiedGroupSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UserSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.enums.LegalHoldStatus;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "contentQuery", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "errors", 
    "isEnabled", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "status", 
    "siteSources", 
    "unifiedGroupSources", 
    "userSources"})
@JsonInclude(Include.NON_NULL)
public class LegalHold extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.legalHold";
    }

    @JsonProperty("contentQuery")
    protected String contentQuery;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errors")
    protected List<String> errors;

    @JsonProperty("errors@nextLink")
    protected String errorsNextLink;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("status")
    protected LegalHoldStatus status;

    @JsonProperty("siteSources")
    protected List<SiteSource> siteSources;

    @JsonProperty("unifiedGroupSources")
    protected List<UnifiedGroupSource> unifiedGroupSources;

    @JsonProperty("userSources")
    protected List<UserSource> userSources;

    protected LegalHold() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLegalHold() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String contentQuery;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private List<String> errors;
        private String errorsNextLink;
        private Boolean isEnabled;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private LegalHoldStatus status;
        private List<SiteSource> siteSources;
        private List<UnifiedGroupSource> unifiedGroupSources;
        private List<UserSource> userSources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contentQuery(String contentQuery) {
            this.contentQuery = contentQuery;
            this.changedFields = changedFields.add("contentQuery");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder errors(List<String> errors) {
            this.errors = errors;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder errors(String... errors) {
            return errors(Arrays.asList(errors));
        }

        public Builder errorsNextLink(String errorsNextLink) {
            this.errorsNextLink = errorsNextLink;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder status(LegalHoldStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder siteSources(List<SiteSource> siteSources) {
            this.siteSources = siteSources;
            this.changedFields = changedFields.add("siteSources");
            return this;
        }

        public Builder siteSources(SiteSource... siteSources) {
            return siteSources(Arrays.asList(siteSources));
        }

        public Builder unifiedGroupSources(List<UnifiedGroupSource> unifiedGroupSources) {
            this.unifiedGroupSources = unifiedGroupSources;
            this.changedFields = changedFields.add("unifiedGroupSources");
            return this;
        }

        public Builder unifiedGroupSources(UnifiedGroupSource... unifiedGroupSources) {
            return unifiedGroupSources(Arrays.asList(unifiedGroupSources));
        }

        public Builder userSources(List<UserSource> userSources) {
            this.userSources = userSources;
            this.changedFields = changedFields.add("userSources");
            return this;
        }

        public Builder userSources(UserSource... userSources) {
            return userSources(Arrays.asList(userSources));
        }

        public LegalHold build() {
            LegalHold _x = new LegalHold();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.legalHold";
            _x.id = id;
            _x.contentQuery = contentQuery;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.errors = errors;
            _x.errorsNextLink = errorsNextLink;
            _x.isEnabled = isEnabled;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.status = status;
            _x.siteSources = siteSources;
            _x.unifiedGroupSources = unifiedGroupSources;
            _x.userSources = userSources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contentQuery")
    @JsonIgnore
    public Optional<String> getContentQuery() {
        return Optional.ofNullable(contentQuery);
    }

    public LegalHold withContentQuery(String contentQuery) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("contentQuery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.contentQuery = contentQuery;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public LegalHold withCreatedBy(IdentitySet createdBy) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public LegalHold withCreatedDateTime(OffsetDateTime createdDateTime) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public LegalHold withDescription(String description) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public LegalHold withDisplayName(String displayName) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<String> getErrors() {
        return new CollectionPage<String>(contextPath, String.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public LegalHold withErrors(List<String> errors) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("errors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.errors = errors;
        return _x;
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<String> getErrors(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public LegalHold withIsEnabled(Boolean isEnabled) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public LegalHold withLastModifiedBy(IdentitySet lastModifiedBy) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public LegalHold withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<LegalHoldStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public LegalHold withStatus(LegalHoldStatus status) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.status = status;
        return _x;
    }

    public LegalHold withUnmappedField(String name, Object value) {
        LegalHold _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="siteSources")
    @JsonIgnore
    public SiteSourceCollectionRequest getSiteSources() {
        return new SiteSourceCollectionRequest(
                        contextPath.addSegment("siteSources"), Optional.ofNullable(siteSources));
    }

    @NavigationProperty(name="unifiedGroupSources")
    @JsonIgnore
    public UnifiedGroupSourceCollectionRequest getUnifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(
                        contextPath.addSegment("unifiedGroupSources"), Optional.ofNullable(unifiedGroupSources));
    }

    @NavigationProperty(name="userSources")
    @JsonIgnore
    public UserSourceCollectionRequest getUserSources() {
        return new UserSourceCollectionRequest(
                        contextPath.addSegment("userSources"), Optional.ofNullable(userSources));
    }

    public LegalHold withSiteSources(List<SiteSource> siteSources) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("siteSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.siteSources = siteSources;
        return _x;
    }

    public LegalHold withUnifiedGroupSources(List<UnifiedGroupSource> unifiedGroupSources) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("unifiedGroupSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.unifiedGroupSources = unifiedGroupSources;
        return _x;
    }

    public LegalHold withUserSources(List<UserSource> userSources) {
        LegalHold _x = _copy();
        _x.changedFields = changedFields.add("userSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.legalHold");
        _x.userSources = userSources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LegalHold patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        LegalHold _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LegalHold put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        LegalHold _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private LegalHold _copy() {
        LegalHold _x = new LegalHold();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contentQuery = contentQuery;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.errors = errors;
        _x.isEnabled = isEnabled;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.status = status;
        _x.siteSources = siteSources;
        _x.unifiedGroupSources = unifiedGroupSources;
        _x.userSources = userSources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LegalHold[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contentQuery=");
        b.append(this.contentQuery);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errors=");
        b.append(this.errors);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("siteSources=");
        b.append(this.siteSources);
        b.append(", ");
        b.append("unifiedGroupSources=");
        b.append(this.unifiedGroupSources);
        b.append(", ");
        b.append("userSources=");
        b.append(this.userSources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
