package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.ediscovery.entity.request.SourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.enums.CaseAction;
import odata.msgraph.client.beta.ediscovery.enums.CaseOperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "indexedItemCount", 
    "indexedItemsSize", 
    "mailboxCount", 
    "siteCount", 
    "unindexedItemCount", 
    "unindexedItemsSize"})
@JsonInclude(Include.NON_NULL)
public class EstimateStatisticsOperation extends CaseOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.estimateStatisticsOperation";
    }

    @JsonProperty("indexedItemCount")
    protected Long indexedItemCount;

    @JsonProperty("indexedItemsSize")
    protected Long indexedItemsSize;

    @JsonProperty("mailboxCount")
    protected Integer mailboxCount;

    @JsonProperty("siteCount")
    protected Integer siteCount;

    @JsonProperty("unindexedItemCount")
    protected Long unindexedItemCount;

    @JsonProperty("unindexedItemsSize")
    protected Long unindexedItemsSize;

    protected EstimateStatisticsOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEstimateStatisticsOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CaseAction action;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private Integer percentProgress;
        private ResultInfo resultInfo;
        private CaseOperationStatus status;
        private Long indexedItemCount;
        private Long indexedItemsSize;
        private Integer mailboxCount;
        private Integer siteCount;
        private Long unindexedItemCount;
        private Long unindexedItemsSize;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder action(CaseAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            this.changedFields = changedFields.add("percentProgress");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder status(CaseOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder indexedItemCount(Long indexedItemCount) {
            this.indexedItemCount = indexedItemCount;
            this.changedFields = changedFields.add("indexedItemCount");
            return this;
        }

        public Builder indexedItemsSize(Long indexedItemsSize) {
            this.indexedItemsSize = indexedItemsSize;
            this.changedFields = changedFields.add("indexedItemsSize");
            return this;
        }

        public Builder mailboxCount(Integer mailboxCount) {
            this.mailboxCount = mailboxCount;
            this.changedFields = changedFields.add("mailboxCount");
            return this;
        }

        public Builder siteCount(Integer siteCount) {
            this.siteCount = siteCount;
            this.changedFields = changedFields.add("siteCount");
            return this;
        }

        public Builder unindexedItemCount(Long unindexedItemCount) {
            this.unindexedItemCount = unindexedItemCount;
            this.changedFields = changedFields.add("unindexedItemCount");
            return this;
        }

        public Builder unindexedItemsSize(Long unindexedItemsSize) {
            this.unindexedItemsSize = unindexedItemsSize;
            this.changedFields = changedFields.add("unindexedItemsSize");
            return this;
        }

        public EstimateStatisticsOperation build() {
            EstimateStatisticsOperation _x = new EstimateStatisticsOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.estimateStatisticsOperation";
            _x.id = id;
            _x.action = action;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.percentProgress = percentProgress;
            _x.resultInfo = resultInfo;
            _x.status = status;
            _x.indexedItemCount = indexedItemCount;
            _x.indexedItemsSize = indexedItemsSize;
            _x.mailboxCount = mailboxCount;
            _x.siteCount = siteCount;
            _x.unindexedItemCount = unindexedItemCount;
            _x.unindexedItemsSize = unindexedItemsSize;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="indexedItemCount")
    @JsonIgnore
    public Optional<Long> getIndexedItemCount() {
        return Optional.ofNullable(indexedItemCount);
    }

    public EstimateStatisticsOperation withIndexedItemCount(Long indexedItemCount) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("indexedItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.indexedItemCount = indexedItemCount;
        return _x;
    }

    @Property(name="indexedItemsSize")
    @JsonIgnore
    public Optional<Long> getIndexedItemsSize() {
        return Optional.ofNullable(indexedItemsSize);
    }

    public EstimateStatisticsOperation withIndexedItemsSize(Long indexedItemsSize) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("indexedItemsSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.indexedItemsSize = indexedItemsSize;
        return _x;
    }

    @Property(name="mailboxCount")
    @JsonIgnore
    public Optional<Integer> getMailboxCount() {
        return Optional.ofNullable(mailboxCount);
    }

    public EstimateStatisticsOperation withMailboxCount(Integer mailboxCount) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("mailboxCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.mailboxCount = mailboxCount;
        return _x;
    }

    @Property(name="siteCount")
    @JsonIgnore
    public Optional<Integer> getSiteCount() {
        return Optional.ofNullable(siteCount);
    }

    public EstimateStatisticsOperation withSiteCount(Integer siteCount) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("siteCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.siteCount = siteCount;
        return _x;
    }

    @Property(name="unindexedItemCount")
    @JsonIgnore
    public Optional<Long> getUnindexedItemCount() {
        return Optional.ofNullable(unindexedItemCount);
    }

    public EstimateStatisticsOperation withUnindexedItemCount(Long unindexedItemCount) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("unindexedItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.unindexedItemCount = unindexedItemCount;
        return _x;
    }

    @Property(name="unindexedItemsSize")
    @JsonIgnore
    public Optional<Long> getUnindexedItemsSize() {
        return Optional.ofNullable(unindexedItemsSize);
    }

    public EstimateStatisticsOperation withUnindexedItemsSize(Long unindexedItemsSize) {
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = changedFields.add("unindexedItemsSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.estimateStatisticsOperation");
        _x.unindexedItemsSize = unindexedItemsSize;
        return _x;
    }

    public EstimateStatisticsOperation withUnmappedField(String name, Object value) {
        EstimateStatisticsOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sourceCollection")
    @JsonIgnore
    public SourceCollectionRequest getSourceCollection() {
        return new SourceCollectionRequest(contextPath.addSegment("sourceCollection"), RequestHelper.getValue(unmappedFields, "sourceCollection"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EstimateStatisticsOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EstimateStatisticsOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EstimateStatisticsOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EstimateStatisticsOperation _copy() {
        EstimateStatisticsOperation _x = new EstimateStatisticsOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.percentProgress = percentProgress;
        _x.resultInfo = resultInfo;
        _x.status = status;
        _x.indexedItemCount = indexedItemCount;
        _x.indexedItemsSize = indexedItemsSize;
        _x.mailboxCount = mailboxCount;
        _x.siteCount = siteCount;
        _x.unindexedItemCount = unindexedItemCount;
        _x.unindexedItemsSize = unindexedItemsSize;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EstimateStatisticsOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("percentProgress=");
        b.append(this.percentProgress);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("indexedItemCount=");
        b.append(this.indexedItemCount);
        b.append(", ");
        b.append("indexedItemsSize=");
        b.append(this.indexedItemsSize);
        b.append(", ");
        b.append("mailboxCount=");
        b.append(this.mailboxCount);
        b.append(", ");
        b.append("siteCount=");
        b.append(this.siteCount);
        b.append(", ");
        b.append("unindexedItemCount=");
        b.append(this.unindexedItemCount);
        b.append(", ");
        b.append("unindexedItemsSize=");
        b.append(this.unindexedItemsSize);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
