package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.ediscovery.entity.request.ReviewSetRequest;
import odata.msgraph.client.beta.ediscovery.enums.CaseAction;
import odata.msgraph.client.beta.ediscovery.enums.CaseOperationStatus;
import odata.msgraph.client.beta.ediscovery.enums.ExportFileStructure;
import odata.msgraph.client.beta.ediscovery.enums.ExportOptions;

@JsonPropertyOrder({
    "@odata.type", 
    "azureBlobContainer", 
    "azureBlobToken", 
    "description", 
    "exportOptions", 
    "exportStructure", 
    "outputFolderId", 
    "outputName"})
@JsonInclude(Include.NON_NULL)
public class CaseExportOperation extends CaseOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.caseExportOperation";
    }

    @JsonProperty("azureBlobContainer")
    protected String azureBlobContainer;

    @JsonProperty("azureBlobToken")
    protected String azureBlobToken;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("exportOptions")
    protected ExportOptions exportOptions;

    @JsonProperty("exportStructure")
    protected ExportFileStructure exportStructure;

    @JsonProperty("outputFolderId")
    protected String outputFolderId;

    @JsonProperty("outputName")
    protected String outputName;

    protected CaseExportOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCaseExportOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CaseAction action;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private Integer percentProgress;
        private ResultInfo resultInfo;
        private CaseOperationStatus status;
        private String azureBlobContainer;
        private String azureBlobToken;
        private String description;
        private ExportOptions exportOptions;
        private ExportFileStructure exportStructure;
        private String outputFolderId;
        private String outputName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder action(CaseAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            this.changedFields = changedFields.add("percentProgress");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder status(CaseOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder azureBlobContainer(String azureBlobContainer) {
            this.azureBlobContainer = azureBlobContainer;
            this.changedFields = changedFields.add("azureBlobContainer");
            return this;
        }

        public Builder azureBlobToken(String azureBlobToken) {
            this.azureBlobToken = azureBlobToken;
            this.changedFields = changedFields.add("azureBlobToken");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder exportOptions(ExportOptions exportOptions) {
            this.exportOptions = exportOptions;
            this.changedFields = changedFields.add("exportOptions");
            return this;
        }

        public Builder exportStructure(ExportFileStructure exportStructure) {
            this.exportStructure = exportStructure;
            this.changedFields = changedFields.add("exportStructure");
            return this;
        }

        public Builder outputFolderId(String outputFolderId) {
            this.outputFolderId = outputFolderId;
            this.changedFields = changedFields.add("outputFolderId");
            return this;
        }

        public Builder outputName(String outputName) {
            this.outputName = outputName;
            this.changedFields = changedFields.add("outputName");
            return this;
        }

        public CaseExportOperation build() {
            CaseExportOperation _x = new CaseExportOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.caseExportOperation";
            _x.id = id;
            _x.action = action;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.percentProgress = percentProgress;
            _x.resultInfo = resultInfo;
            _x.status = status;
            _x.azureBlobContainer = azureBlobContainer;
            _x.azureBlobToken = azureBlobToken;
            _x.description = description;
            _x.exportOptions = exportOptions;
            _x.exportStructure = exportStructure;
            _x.outputFolderId = outputFolderId;
            _x.outputName = outputName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="azureBlobContainer")
    @JsonIgnore
    public Optional<String> getAzureBlobContainer() {
        return Optional.ofNullable(azureBlobContainer);
    }

    public CaseExportOperation withAzureBlobContainer(String azureBlobContainer) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("azureBlobContainer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.azureBlobContainer = azureBlobContainer;
        return _x;
    }

    @Property(name="azureBlobToken")
    @JsonIgnore
    public Optional<String> getAzureBlobToken() {
        return Optional.ofNullable(azureBlobToken);
    }

    public CaseExportOperation withAzureBlobToken(String azureBlobToken) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("azureBlobToken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.azureBlobToken = azureBlobToken;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CaseExportOperation withDescription(String description) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.description = description;
        return _x;
    }

    @Property(name="exportOptions")
    @JsonIgnore
    public Optional<ExportOptions> getExportOptions() {
        return Optional.ofNullable(exportOptions);
    }

    public CaseExportOperation withExportOptions(ExportOptions exportOptions) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("exportOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.exportOptions = exportOptions;
        return _x;
    }

    @Property(name="exportStructure")
    @JsonIgnore
    public Optional<ExportFileStructure> getExportStructure() {
        return Optional.ofNullable(exportStructure);
    }

    public CaseExportOperation withExportStructure(ExportFileStructure exportStructure) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("exportStructure");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.exportStructure = exportStructure;
        return _x;
    }

    @Property(name="outputFolderId")
    @JsonIgnore
    public Optional<String> getOutputFolderId() {
        return Optional.ofNullable(outputFolderId);
    }

    public CaseExportOperation withOutputFolderId(String outputFolderId) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("outputFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.outputFolderId = outputFolderId;
        return _x;
    }

    @Property(name="outputName")
    @JsonIgnore
    public Optional<String> getOutputName() {
        return Optional.ofNullable(outputName);
    }

    public CaseExportOperation withOutputName(String outputName) {
        CaseExportOperation _x = _copy();
        _x.changedFields = changedFields.add("outputName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseExportOperation");
        _x.outputName = outputName;
        return _x;
    }

    public CaseExportOperation withUnmappedField(String name, Object value) {
        CaseExportOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="reviewSet")
    @JsonIgnore
    public ReviewSetRequest getReviewSet() {
        return new ReviewSetRequest(contextPath.addSegment("reviewSet"), RequestHelper.getValue(unmappedFields, "reviewSet"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseExportOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CaseExportOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseExportOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CaseExportOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CaseExportOperation _copy() {
        CaseExportOperation _x = new CaseExportOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.percentProgress = percentProgress;
        _x.resultInfo = resultInfo;
        _x.status = status;
        _x.azureBlobContainer = azureBlobContainer;
        _x.azureBlobToken = azureBlobToken;
        _x.description = description;
        _x.exportOptions = exportOptions;
        _x.exportStructure = exportStructure;
        _x.outputFolderId = outputFolderId;
        _x.outputName = outputName;
        return _x;
    }

    @Function(name = "getDownloadUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.getDownloadUrl"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CaseExportOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("percentProgress=");
        b.append(this.percentProgress);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("azureBlobContainer=");
        b.append(this.azureBlobContainer);
        b.append(", ");
        b.append("azureBlobToken=");
        b.append(this.azureBlobToken);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("exportOptions=");
        b.append(this.exportOptions);
        b.append(", ");
        b.append("exportStructure=");
        b.append(this.exportStructure);
        b.append(", ");
        b.append("outputFolderId=");
        b.append(this.outputFolderId);
        b.append(", ");
        b.append("outputName=");
        b.append(this.outputName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
