package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.CaseOperationCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.CustodianCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.LegalHoldCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.NoncustodialDataSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.ReviewSetCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.SourceCollectionCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.TagCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.CaseSettingsRequest;
import odata.msgraph.client.beta.ediscovery.enums.CaseStatus;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "closedBy", 
    "closedDateTime", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "externalId", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "status", 
    "custodians", 
    "legalHolds", 
    "noncustodialDataSources", 
    "operations", 
    "reviewSets", 
    "settings", 
    "sourceCollections", 
    "tags"})
@JsonInclude(Include.NON_NULL)
public class Case extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.case";
    }

    @JsonProperty("closedBy")
    protected IdentitySet closedBy;

    @JsonProperty("closedDateTime")
    protected OffsetDateTime closedDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("status")
    protected CaseStatus status;

    @JsonProperty("custodians")
    protected List<Custodian> custodians;

    @JsonProperty("legalHolds")
    protected List<LegalHold> legalHolds;

    @JsonProperty("noncustodialDataSources")
    protected List<NoncustodialDataSource> noncustodialDataSources;

    @JsonProperty("operations")
    protected List<CaseOperation> operations;

    @JsonProperty("reviewSets")
    protected List<ReviewSet> reviewSets;

    @JsonProperty("settings")
    protected CaseSettings settings;

    @JsonProperty("sourceCollections")
    protected List<SourceCollection> sourceCollections;

    @JsonProperty("tags")
    protected List<Tag> tags;

    protected Case() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCase() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet closedBy;
        private OffsetDateTime closedDateTime;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String externalId;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private CaseStatus status;
        private List<Custodian> custodians;
        private List<LegalHold> legalHolds;
        private List<NoncustodialDataSource> noncustodialDataSources;
        private List<CaseOperation> operations;
        private List<ReviewSet> reviewSets;
        private CaseSettings settings;
        private List<SourceCollection> sourceCollections;
        private List<Tag> tags;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder closedBy(IdentitySet closedBy) {
            this.closedBy = closedBy;
            this.changedFields = changedFields.add("closedBy");
            return this;
        }

        public Builder closedDateTime(OffsetDateTime closedDateTime) {
            this.closedDateTime = closedDateTime;
            this.changedFields = changedFields.add("closedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder status(CaseStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder custodians(List<Custodian> custodians) {
            this.custodians = custodians;
            this.changedFields = changedFields.add("custodians");
            return this;
        }

        public Builder custodians(Custodian... custodians) {
            return custodians(Arrays.asList(custodians));
        }

        public Builder legalHolds(List<LegalHold> legalHolds) {
            this.legalHolds = legalHolds;
            this.changedFields = changedFields.add("legalHolds");
            return this;
        }

        public Builder legalHolds(LegalHold... legalHolds) {
            return legalHolds(Arrays.asList(legalHolds));
        }

        public Builder noncustodialDataSources(List<NoncustodialDataSource> noncustodialDataSources) {
            this.noncustodialDataSources = noncustodialDataSources;
            this.changedFields = changedFields.add("noncustodialDataSources");
            return this;
        }

        public Builder noncustodialDataSources(NoncustodialDataSource... noncustodialDataSources) {
            return noncustodialDataSources(Arrays.asList(noncustodialDataSources));
        }

        public Builder operations(List<CaseOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(CaseOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder reviewSets(List<ReviewSet> reviewSets) {
            this.reviewSets = reviewSets;
            this.changedFields = changedFields.add("reviewSets");
            return this;
        }

        public Builder reviewSets(ReviewSet... reviewSets) {
            return reviewSets(Arrays.asList(reviewSets));
        }

        public Builder settings(CaseSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder sourceCollections(List<SourceCollection> sourceCollections) {
            this.sourceCollections = sourceCollections;
            this.changedFields = changedFields.add("sourceCollections");
            return this;
        }

        public Builder sourceCollections(SourceCollection... sourceCollections) {
            return sourceCollections(Arrays.asList(sourceCollections));
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(Tag... tags) {
            return tags(Arrays.asList(tags));
        }

        public Case build() {
            Case _x = new Case();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.case";
            _x.id = id;
            _x.closedBy = closedBy;
            _x.closedDateTime = closedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.externalId = externalId;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.status = status;
            _x.custodians = custodians;
            _x.legalHolds = legalHolds;
            _x.noncustodialDataSources = noncustodialDataSources;
            _x.operations = operations;
            _x.reviewSets = reviewSets;
            _x.settings = settings;
            _x.sourceCollections = sourceCollections;
            _x.tags = tags;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="closedBy")
    @JsonIgnore
    public Optional<IdentitySet> getClosedBy() {
        return Optional.ofNullable(closedBy);
    }

    public Case withClosedBy(IdentitySet closedBy) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("closedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.closedBy = closedBy;
        return _x;
    }

    @Property(name="closedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getClosedDateTime() {
        return Optional.ofNullable(closedDateTime);
    }

    public Case withClosedDateTime(OffsetDateTime closedDateTime) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("closedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.closedDateTime = closedDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Case withCreatedDateTime(OffsetDateTime createdDateTime) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Case withDescription(String description) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Case withDisplayName(String displayName) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public Case withExternalId(String externalId) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public Case withLastModifiedBy(IdentitySet lastModifiedBy) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Case withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CaseStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Case withStatus(CaseStatus status) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.status = status;
        return _x;
    }

    public Case withUnmappedField(String name, Object value) {
        Case _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="custodians")
    @JsonIgnore
    public CustodianCollectionRequest getCustodians() {
        return new CustodianCollectionRequest(
                        contextPath.addSegment("custodians"), Optional.ofNullable(custodians));
    }

    @NavigationProperty(name="legalHolds")
    @JsonIgnore
    public LegalHoldCollectionRequest getLegalHolds() {
        return new LegalHoldCollectionRequest(
                        contextPath.addSegment("legalHolds"), Optional.ofNullable(legalHolds));
    }

    @NavigationProperty(name="noncustodialDataSources")
    @JsonIgnore
    public NoncustodialDataSourceCollectionRequest getNoncustodialDataSources() {
        return new NoncustodialDataSourceCollectionRequest(
                        contextPath.addSegment("noncustodialDataSources"), Optional.ofNullable(noncustodialDataSources));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public CaseOperationCollectionRequest getOperations() {
        return new CaseOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="reviewSets")
    @JsonIgnore
    public ReviewSetCollectionRequest getReviewSets() {
        return new ReviewSetCollectionRequest(
                        contextPath.addSegment("reviewSets"), Optional.ofNullable(reviewSets));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public CaseSettingsRequest getSettings() {
        return new CaseSettingsRequest(contextPath.addSegment("settings"), Optional.ofNullable(settings));
    }

    @NavigationProperty(name="sourceCollections")
    @JsonIgnore
    public SourceCollectionCollectionRequest getSourceCollections() {
        return new SourceCollectionCollectionRequest(
                        contextPath.addSegment("sourceCollections"), Optional.ofNullable(sourceCollections));
    }

    @NavigationProperty(name="tags")
    @JsonIgnore
    public TagCollectionRequest getTags() {
        return new TagCollectionRequest(
                        contextPath.addSegment("tags"), Optional.ofNullable(tags));
    }

    public Case withCustodians(List<Custodian> custodians) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("custodians");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.custodians = custodians;
        return _x;
    }

    public Case withLegalHolds(List<LegalHold> legalHolds) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("legalHolds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.legalHolds = legalHolds;
        return _x;
    }

    public Case withNoncustodialDataSources(List<NoncustodialDataSource> noncustodialDataSources) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("noncustodialDataSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.noncustodialDataSources = noncustodialDataSources;
        return _x;
    }

    public Case withOperations(List<CaseOperation> operations) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.operations = operations;
        return _x;
    }

    public Case withReviewSets(List<ReviewSet> reviewSets) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("reviewSets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.reviewSets = reviewSets;
        return _x;
    }

    public Case withSettings(CaseSettings settings) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.settings = settings;
        return _x;
    }

    public Case withSourceCollections(List<SourceCollection> sourceCollections) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("sourceCollections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.sourceCollections = sourceCollections;
        return _x;
    }

    public Case withTags(List<Tag> tags) {
        Case _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.case");
        _x.tags = tags;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Case patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Case _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Case put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Case _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Case _copy() {
        Case _x = new Case();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.closedBy = closedBy;
        _x.closedDateTime = closedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.externalId = externalId;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.status = status;
        _x.custodians = custodians;
        _x.legalHolds = legalHolds;
        _x.noncustodialDataSources = noncustodialDataSources;
        _x.operations = operations;
        _x.reviewSets = reviewSets;
        _x.settings = settings;
        _x.sourceCollections = sourceCollections;
        _x.tags = tags;
        return _x;
    }

    @Action(name = "close")
    @JsonIgnore
    public ActionRequestNoReturn close() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.close"), _parameters);
    }

    @Action(name = "reopen")
    @JsonIgnore
    public ActionRequestNoReturn reopen() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.reopen"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Case[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("closedBy=");
        b.append(this.closedBy);
        b.append(", ");
        b.append("closedDateTime=");
        b.append(this.closedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("custodians=");
        b.append(this.custodians);
        b.append(", ");
        b.append("legalHolds=");
        b.append(this.legalHolds);
        b.append(", ");
        b.append("noncustodialDataSources=");
        b.append(this.noncustodialDataSources);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("reviewSets=");
        b.append(this.reviewSets);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("sourceCollections=");
        b.append(this.sourceCollections);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
