package odata.msgraph.client.beta.ediscovery.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dynamicallyAdjustTopicCount", 
    "ignoreNumbers", 
    "isEnabled", 
    "topicCount"})
@JsonInclude(Include.NON_NULL)
public class TopicModelingSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dynamicallyAdjustTopicCount")
    protected Boolean dynamicallyAdjustTopicCount;

    @JsonProperty("ignoreNumbers")
    protected Boolean ignoreNumbers;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("topicCount")
    protected Integer topicCount;

    protected TopicModelingSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.topicModelingSettings";
    }

    @Property(name="dynamicallyAdjustTopicCount")
    @JsonIgnore
    public Optional<Boolean> getDynamicallyAdjustTopicCount() {
        return Optional.ofNullable(dynamicallyAdjustTopicCount);
    }

    public TopicModelingSettings withDynamicallyAdjustTopicCount(Boolean dynamicallyAdjustTopicCount) {
        TopicModelingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.topicModelingSettings");
        _x.dynamicallyAdjustTopicCount = dynamicallyAdjustTopicCount;
        return _x;
    }

    @Property(name="ignoreNumbers")
    @JsonIgnore
    public Optional<Boolean> getIgnoreNumbers() {
        return Optional.ofNullable(ignoreNumbers);
    }

    public TopicModelingSettings withIgnoreNumbers(Boolean ignoreNumbers) {
        TopicModelingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.topicModelingSettings");
        _x.ignoreNumbers = ignoreNumbers;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public TopicModelingSettings withIsEnabled(Boolean isEnabled) {
        TopicModelingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.topicModelingSettings");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="topicCount")
    @JsonIgnore
    public Optional<Integer> getTopicCount() {
        return Optional.ofNullable(topicCount);
    }

    public TopicModelingSettings withTopicCount(Integer topicCount) {
        TopicModelingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.topicModelingSettings");
        _x.topicCount = topicCount;
        return _x;
    }

    public TopicModelingSettings withUnmappedField(String name, Object value) {
        TopicModelingSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean dynamicallyAdjustTopicCount;
        private Boolean ignoreNumbers;
        private Boolean isEnabled;
        private Integer topicCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder dynamicallyAdjustTopicCount(Boolean dynamicallyAdjustTopicCount) {
            this.dynamicallyAdjustTopicCount = dynamicallyAdjustTopicCount;
            this.changedFields = changedFields.add("dynamicallyAdjustTopicCount");
            return this;
        }

        public Builder ignoreNumbers(Boolean ignoreNumbers) {
            this.ignoreNumbers = ignoreNumbers;
            this.changedFields = changedFields.add("ignoreNumbers");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder topicCount(Integer topicCount) {
            this.topicCount = topicCount;
            this.changedFields = changedFields.add("topicCount");
            return this;
        }

        public TopicModelingSettings build() {
            TopicModelingSettings _x = new TopicModelingSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.topicModelingSettings";
            _x.dynamicallyAdjustTopicCount = dynamicallyAdjustTopicCount;
            _x.ignoreNumbers = ignoreNumbers;
            _x.isEnabled = isEnabled;
            _x.topicCount = topicCount;
            return _x;
        }
    }

    private TopicModelingSettings _copy() {
        TopicModelingSettings _x = new TopicModelingSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dynamicallyAdjustTopicCount = dynamicallyAdjustTopicCount;
        _x.ignoreNumbers = ignoreNumbers;
        _x.isEnabled = isEnabled;
        _x.topicCount = topicCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TopicModelingSettings[");
        b.append("dynamicallyAdjustTopicCount=");
        b.append(this.dynamicallyAdjustTopicCount);
        b.append(", ");
        b.append("ignoreNumbers=");
        b.append(this.ignoreNumbers);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("topicCount=");
        b.append(this.topicCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
