package odata.msgraph.client.beta.container;

import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;

import java.lang.Override;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.request.ExternalConnectionEntityRequest;
import microsoft.graph.externalconnectors.entity.request.ExternalEntityRequest;

import odata.msgraph.client.beta.entity.request.AccessReviewDecisionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewRequest;
import odata.msgraph.client.beta.entity.request.ActivityStatisticsRequest;
import odata.msgraph.client.beta.entity.request.AdminRequest;
import odata.msgraph.client.beta.entity.request.AdministrativeUnitRequest;
import odata.msgraph.client.beta.entity.request.AgreementAcceptanceRequest;
import odata.msgraph.client.beta.entity.request.AgreementRequest;
import odata.msgraph.client.beta.entity.request.AllowedDataLocationRequest;
import odata.msgraph.client.beta.entity.request.AppCatalogsRequest;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.ApplicationTemplateRequest;
import odata.msgraph.client.beta.entity.request.ApprovalWorkflowProviderRequest;
import odata.msgraph.client.beta.entity.request.AttributeMappingFunctionSchemaRequest;
import odata.msgraph.client.beta.entity.request.AuditLogRootRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationMethodConfigurationRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationMethodsPolicyRequest;
import odata.msgraph.client.beta.entity.request.BitlockerRequest;
import odata.msgraph.client.beta.entity.request.BookingBusinessRequest;
import odata.msgraph.client.beta.entity.request.BookingCurrencyRequest;
import odata.msgraph.client.beta.entity.request.BusinessFlowTemplateRequest;
import odata.msgraph.client.beta.entity.request.CertificateBasedAuthConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.CloudCommunicationsRequest;
import odata.msgraph.client.beta.entity.request.CommandRequest;
import odata.msgraph.client.beta.entity.request.CommsApplicationRequest;
import odata.msgraph.client.beta.entity.request.ComplianceRequest;
import odata.msgraph.client.beta.entity.request.ConditionalAccessRootRequest;
import odata.msgraph.client.beta.entity.request.ContractRequest;
import odata.msgraph.client.beta.entity.request.DataClassificationServiceRequest;
import odata.msgraph.client.beta.entity.request.DataPolicyOperationRequest;
import odata.msgraph.client.beta.entity.request.DeviceAppManagementRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementRequest;
import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleTemplateRequest;
import odata.msgraph.client.beta.entity.request.DirectorySettingRequest;
import odata.msgraph.client.beta.entity.request.DirectorySettingTemplateRequest;
import odata.msgraph.client.beta.entity.request.DomainDnsRecordRequest;
import odata.msgraph.client.beta.entity.request.DomainRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.EducationRootRequest;
import odata.msgraph.client.beta.entity.request.FilterOperatorSchemaRequest;
import odata.msgraph.client.beta.entity.request.FinancialsRequest;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;
import odata.msgraph.client.beta.entity.request.GovernanceSubjectRequest;
import odata.msgraph.client.beta.entity.request.GroupLifecyclePolicyRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.IdentityContainerRequest;
import odata.msgraph.client.beta.entity.request.IdentityGovernanceRequest;
import odata.msgraph.client.beta.entity.request.IdentityProtectionRootRequest;
import odata.msgraph.client.beta.entity.request.IdentityProviderRequest;
import odata.msgraph.client.beta.entity.request.InformationProtectionRequest;
import odata.msgraph.client.beta.entity.request.InvitationRequest;
import odata.msgraph.client.beta.entity.request.MessageEventRequest;
import odata.msgraph.client.beta.entity.request.MessageRecipientRequest;
import odata.msgraph.client.beta.entity.request.MessageTraceRequest;
import odata.msgraph.client.beta.entity.request.MobilityManagementPolicyRequest;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.OfficeConfigurationRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesPublishingProfileRequest;
import odata.msgraph.client.beta.entity.request.OrgContactRequest;
import odata.msgraph.client.beta.entity.request.OrganizationRequest;
import odata.msgraph.client.beta.entity.request.OrganizationalBrandingRequest;
import odata.msgraph.client.beta.entity.request.PayloadResponseRequest;
import odata.msgraph.client.beta.entity.request.PlaceRequest;
import odata.msgraph.client.beta.entity.request.PlannerRequest;
import odata.msgraph.client.beta.entity.request.PolicyRootRequest;
import odata.msgraph.client.beta.entity.request.PrintRequest;
import odata.msgraph.client.beta.entity.request.PrivacyRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedAccessRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedApprovalRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedOperationEventRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedSignupStatusRequest;
import odata.msgraph.client.beta.entity.request.ProgramControlRequest;
import odata.msgraph.client.beta.entity.request.ProgramControlTypeRequest;
import odata.msgraph.client.beta.entity.request.ProgramRequest;
import odata.msgraph.client.beta.entity.request.ReportRootRequest;
import odata.msgraph.client.beta.entity.request.ResourceSpecificPermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.RiskDetectionRequest;
import odata.msgraph.client.beta.entity.request.RiskyUserRequest;
import odata.msgraph.client.beta.entity.request.RoleManagementRequest;
import odata.msgraph.client.beta.entity.request.SchemaExtensionRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.entity.request.SearchEntityRequest;
import odata.msgraph.client.beta.entity.request.SecurityRequest;
import odata.msgraph.client.beta.entity.request.ServicePrincipalRequest;
import odata.msgraph.client.beta.entity.request.SharedDriveItemRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.entity.request.SubscribedSkuRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.TeamsTemplateRequest;
import odata.msgraph.client.beta.entity.request.TeamworkRequest;
import odata.msgraph.client.beta.entity.request.TenantRelationshipRequest;
import odata.msgraph.client.beta.entity.request.TrustFrameworkRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.entity.set.AccessReviewDecisions;
import odata.msgraph.client.beta.entity.set.AccessReviews;
import odata.msgraph.client.beta.entity.set.Activitystatistics;
import odata.msgraph.client.beta.entity.set.AdministrativeUnits;
import odata.msgraph.client.beta.entity.set.AgreementAcceptances;
import odata.msgraph.client.beta.entity.set.Agreements;
import odata.msgraph.client.beta.entity.set.AllowedDataLocations;
import odata.msgraph.client.beta.entity.set.AppRoleAssignments;
import odata.msgraph.client.beta.entity.set.ApplicationTemplates;
import odata.msgraph.client.beta.entity.set.Applications;
import odata.msgraph.client.beta.entity.set.ApprovalWorkflowProviders;
import odata.msgraph.client.beta.entity.set.AuthenticationMethodConfigurations;
import odata.msgraph.client.beta.entity.set.BookingBusinesses;
import odata.msgraph.client.beta.entity.set.BookingCurrencies;
import odata.msgraph.client.beta.entity.set.BusinessFlowTemplates;
import odata.msgraph.client.beta.entity.set.CertificateBasedAuthConfiguration;
import odata.msgraph.client.beta.entity.set.Chats;
import odata.msgraph.client.beta.entity.set.Commands;
import odata.msgraph.client.beta.entity.set.Connections;
import odata.msgraph.client.beta.entity.set.Contacts;
import odata.msgraph.client.beta.entity.set.Contracts;
import odata.msgraph.client.beta.entity.set.DataPolicyOperations;
import odata.msgraph.client.beta.entity.set.Devices;
import odata.msgraph.client.beta.entity.set.DirectoryObjects;
import odata.msgraph.client.beta.entity.set.DirectoryRoleTemplates;
import odata.msgraph.client.beta.entity.set.DirectoryRoles;
import odata.msgraph.client.beta.entity.set.DirectorySettingTemplates;
import odata.msgraph.client.beta.entity.set.DomainDnsRecords;
import odata.msgraph.client.beta.entity.set.Domains;
import odata.msgraph.client.beta.entity.set.Drives;
import odata.msgraph.client.beta.entity.set.FilterOperators;
import odata.msgraph.client.beta.entity.set.Functions;
import odata.msgraph.client.beta.entity.set.GovernanceResources;
import odata.msgraph.client.beta.entity.set.GovernanceRoleAssignmentRequests;
import odata.msgraph.client.beta.entity.set.GovernanceRoleAssignments;
import odata.msgraph.client.beta.entity.set.GovernanceRoleDefinitions;
import odata.msgraph.client.beta.entity.set.GovernanceRoleSettings;
import odata.msgraph.client.beta.entity.set.GovernanceSubjects;
import odata.msgraph.client.beta.entity.set.GroupLifecyclePolicies;
import odata.msgraph.client.beta.entity.set.Groups;
import odata.msgraph.client.beta.entity.set.IdentityProviders;
import odata.msgraph.client.beta.entity.set.Invitations;
import odata.msgraph.client.beta.entity.set.MessageEvents;
import odata.msgraph.client.beta.entity.set.MessageRecipients;
import odata.msgraph.client.beta.entity.set.MessageTraces;
import odata.msgraph.client.beta.entity.set.MobilityManagementPolicies;
import odata.msgraph.client.beta.entity.set.Oauth2PermissionGrants;
import odata.msgraph.client.beta.entity.set.OnPremisesPublishingProfiles;
import odata.msgraph.client.beta.entity.set.Organization;
import odata.msgraph.client.beta.entity.set.PayloadResponse;
import odata.msgraph.client.beta.entity.set.PermissionGrants;
import odata.msgraph.client.beta.entity.set.Places;
import odata.msgraph.client.beta.entity.set.PrivilegedAccess;
import odata.msgraph.client.beta.entity.set.PrivilegedApproval;
import odata.msgraph.client.beta.entity.set.PrivilegedOperationEvents;
import odata.msgraph.client.beta.entity.set.PrivilegedRoleAssignmentRequests;
import odata.msgraph.client.beta.entity.set.PrivilegedRoleAssignments;
import odata.msgraph.client.beta.entity.set.PrivilegedRoles;
import odata.msgraph.client.beta.entity.set.PrivilegedSignupStatus;
import odata.msgraph.client.beta.entity.set.ProgramControlTypes;
import odata.msgraph.client.beta.entity.set.ProgramControls;
import odata.msgraph.client.beta.entity.set.Programs;
import odata.msgraph.client.beta.entity.set.RiskDetections;
import odata.msgraph.client.beta.entity.set.RiskyUsers;
import odata.msgraph.client.beta.entity.set.SchemaExtensions;
import odata.msgraph.client.beta.entity.set.ScopedRoleMemberships;
import odata.msgraph.client.beta.entity.set.ServicePrincipals;
import odata.msgraph.client.beta.entity.set.Settings;
import odata.msgraph.client.beta.entity.set.Shares;
import odata.msgraph.client.beta.entity.set.Sites;
import odata.msgraph.client.beta.entity.set.SubscribedSkus;
import odata.msgraph.client.beta.entity.set.Subscriptions;
import odata.msgraph.client.beta.entity.set.Teams;
import odata.msgraph.client.beta.entity.set.TeamsTemplates;
import odata.msgraph.client.beta.entity.set.Users;
import odata.msgraph.client.beta.termStore.entity.request.StoreRequest;

public final class GraphService implements HasContext {

    private final ContextPath contextPath;

    public GraphService(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<GraphService> {

        @Override
        public GraphService _create(Context context) {
            return new GraphService(context);
        }
    }

    public static BuilderBase<ContainerBuilder<GraphService>, GraphService> test() {
        return new ContainerBuilderImpl();
    }

    public InvitationRequest invitations(String id) {
        return new InvitationRequest(contextPath.addSegment("invitations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Invitations invitations() {
        return new Invitations(
                        contextPath.addSegment("invitations"));
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Users users() {
        return new Users(
                        contextPath.addSegment("users"));
    }

    public ActivityStatisticsRequest activitystatistics(String id) {
        return new ActivityStatisticsRequest(contextPath.addSegment("activitystatistics").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Activitystatistics activitystatistics() {
        return new Activitystatistics(
                        contextPath.addSegment("activitystatistics"));
    }

    public ApplicationTemplateRequest applicationTemplates(String id) {
        return new ApplicationTemplateRequest(contextPath.addSegment("applicationTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApplicationTemplates applicationTemplates() {
        return new ApplicationTemplates(
                        contextPath.addSegment("applicationTemplates"));
    }

    public ServicePrincipalRequest servicePrincipals(String id) {
        return new ServicePrincipalRequest(contextPath.addSegment("servicePrincipals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipals servicePrincipals() {
        return new ServicePrincipals(
                        contextPath.addSegment("servicePrincipals"));
    }

    public AuthenticationMethodConfigurationRequest authenticationMethodConfigurations(String id) {
        return new AuthenticationMethodConfigurationRequest(contextPath.addSegment("authenticationMethodConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationMethodConfigurations authenticationMethodConfigurations() {
        return new AuthenticationMethodConfigurations(
                        contextPath.addSegment("authenticationMethodConfigurations"));
    }

    public BookingBusinessRequest bookingBusinesses(String id) {
        return new BookingBusinessRequest(contextPath.addSegment("bookingBusinesses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingBusinesses bookingBusinesses() {
        return new BookingBusinesses(
                        contextPath.addSegment("bookingBusinesses"));
    }

    public BookingCurrencyRequest bookingCurrencies(String id) {
        return new BookingCurrencyRequest(contextPath.addSegment("bookingCurrencies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingCurrencies bookingCurrencies() {
        return new BookingCurrencies(
                        contextPath.addSegment("bookingCurrencies"));
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Devices devices() {
        return new Devices(
                        contextPath.addSegment("devices"));
    }

    public IdentityProviderRequest identityProviders(String id) {
        return new IdentityProviderRequest(contextPath.addSegment("identityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviders identityProviders() {
        return new IdentityProviders(
                        contextPath.addSegment("identityProviders"));
    }

    public AdministrativeUnitRequest administrativeUnits(String id) {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnits").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AdministrativeUnits administrativeUnits() {
        return new AdministrativeUnits(
                        contextPath.addSegment("administrativeUnits"));
    }

    public AllowedDataLocationRequest allowedDataLocations(String id) {
        return new AllowedDataLocationRequest(contextPath.addSegment("allowedDataLocations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AllowedDataLocations allowedDataLocations() {
        return new AllowedDataLocations(
                        contextPath.addSegment("allowedDataLocations"));
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Applications applications() {
        return new Applications(
                        contextPath.addSegment("applications"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignments appRoleAssignments() {
        return new AppRoleAssignments(
                        contextPath.addSegment("appRoleAssignments"));
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CertificateBasedAuthConfiguration certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfiguration(
                        contextPath.addSegment("certificateBasedAuthConfiguration"));
    }

    public OrgContactRequest contacts(String id) {
        return new OrgContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Contacts contacts() {
        return new Contacts(
                        contextPath.addSegment("contacts"));
    }

    public ContractRequest contracts(String id) {
        return new ContractRequest(contextPath.addSegment("contracts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Contracts contracts() {
        return new Contracts(
                        contextPath.addSegment("contracts"));
    }

    public DirectoryObjectRequest directoryObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjects directoryObjects() {
        return new DirectoryObjects(
                        contextPath.addSegment("directoryObjects"));
    }

    public DirectoryRoleRequest directoryRoles(String id) {
        return new DirectoryRoleRequest(contextPath.addSegment("directoryRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryRoles directoryRoles() {
        return new DirectoryRoles(
                        contextPath.addSegment("directoryRoles"));
    }

    public DirectoryRoleTemplateRequest directoryRoleTemplates(String id) {
        return new DirectoryRoleTemplateRequest(contextPath.addSegment("directoryRoleTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryRoleTemplates directoryRoleTemplates() {
        return new DirectoryRoleTemplates(
                        contextPath.addSegment("directoryRoleTemplates"));
    }

    public DirectorySettingTemplateRequest directorySettingTemplates(String id) {
        return new DirectorySettingTemplateRequest(contextPath.addSegment("directorySettingTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectorySettingTemplates directorySettingTemplates() {
        return new DirectorySettingTemplates(
                        contextPath.addSegment("directorySettingTemplates"));
    }

    public DomainDnsRecordRequest domainDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("domainDnsRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainDnsRecords domainDnsRecords() {
        return new DomainDnsRecords(
                        contextPath.addSegment("domainDnsRecords"));
    }

    public DomainRequest domains(String id) {
        return new DomainRequest(contextPath.addSegment("domains").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Domains domains() {
        return new Domains(
                        contextPath.addSegment("domains"));
    }

    public GroupRequest groups(String id) {
        return new GroupRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Groups groups() {
        return new Groups(
                        contextPath.addSegment("groups"));
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Oauth2PermissionGrants oauth2PermissionGrants() {
        return new Oauth2PermissionGrants(
                        contextPath.addSegment("oauth2PermissionGrants"));
    }

    public OrganizationRequest organization(String id) {
        return new OrganizationRequest(contextPath.addSegment("organization").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Organization organization() {
        return new Organization(
                        contextPath.addSegment("organization"));
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrants permissionGrants() {
        return new PermissionGrants(
                        contextPath.addSegment("permissionGrants"));
    }

    public ScopedRoleMembershipRequest scopedRoleMemberships(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberships").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMemberships scopedRoleMemberships() {
        return new ScopedRoleMemberships(
                        contextPath.addSegment("scopedRoleMemberships"));
    }

    public DirectorySettingRequest settings(String id) {
        return new DirectorySettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Settings settings() {
        return new Settings(
                        contextPath.addSegment("settings"));
    }

    public SubscribedSkuRequest subscribedSkus(String id) {
        return new SubscribedSkuRequest(contextPath.addSegment("subscribedSkus").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SubscribedSkus subscribedSkus() {
        return new SubscribedSkus(
                        contextPath.addSegment("subscribedSkus"));
    }

    public PlaceRequest places(String id) {
        return new PlaceRequest(contextPath.addSegment("places").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Places places() {
        return new Places(
                        contextPath.addSegment("places"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Drives drives() {
        return new Drives(
                        contextPath.addSegment("drives"));
    }

    public SharedDriveItemRequest shares(String id) {
        return new SharedDriveItemRequest(contextPath.addSegment("shares").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Shares shares() {
        return new Shares(
                        contextPath.addSegment("shares"));
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Sites sites() {
        return new Sites(
                        contextPath.addSegment("sites"));
    }

    public MessageEventRequest messageEvents(String id) {
        return new MessageEventRequest(contextPath.addSegment("messageEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageEvents messageEvents() {
        return new MessageEvents(
                        contextPath.addSegment("messageEvents"));
    }

    public MessageRecipientRequest messageRecipients(String id) {
        return new MessageRecipientRequest(contextPath.addSegment("messageRecipients").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageRecipients messageRecipients() {
        return new MessageRecipients(
                        contextPath.addSegment("messageRecipients"));
    }

    public MessageTraceRequest messageTraces(String id) {
        return new MessageTraceRequest(contextPath.addSegment("messageTraces").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageTraces messageTraces() {
        return new MessageTraces(
                        contextPath.addSegment("messageTraces"));
    }

    public SchemaExtensionRequest schemaExtensions(String id) {
        return new SchemaExtensionRequest(contextPath.addSegment("schemaExtensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SchemaExtensions schemaExtensions() {
        return new SchemaExtensions(
                        contextPath.addSegment("schemaExtensions"));
    }

    public OnPremisesPublishingProfileRequest onPremisesPublishingProfiles(String id) {
        return new OnPremisesPublishingProfileRequest(contextPath.addSegment("onPremisesPublishingProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesPublishingProfiles onPremisesPublishingProfiles() {
        return new OnPremisesPublishingProfiles(
                        contextPath.addSegment("onPremisesPublishingProfiles"));
    }

    public GroupLifecyclePolicyRequest groupLifecyclePolicies(String id) {
        return new GroupLifecyclePolicyRequest(contextPath.addSegment("groupLifecyclePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupLifecyclePolicies groupLifecyclePolicies() {
        return new GroupLifecyclePolicies(
                        contextPath.addSegment("groupLifecyclePolicies"));
    }

    public FilterOperatorSchemaRequest filterOperators(String id) {
        return new FilterOperatorSchemaRequest(contextPath.addSegment("filterOperators").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FilterOperators filterOperators() {
        return new FilterOperators(
                        contextPath.addSegment("filterOperators"));
    }

    public AttributeMappingFunctionSchemaRequest functions(String id) {
        return new AttributeMappingFunctionSchemaRequest(contextPath.addSegment("functions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Functions functions() {
        return new Functions(
                        contextPath.addSegment("functions"));
    }

    public AccessReviewDecisionRequest accessReviewDecisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("accessReviewDecisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewDecisions accessReviewDecisions() {
        return new AccessReviewDecisions(
                        contextPath.addSegment("accessReviewDecisions"));
    }

    public AccessReviewRequest accessReviews(String id) {
        return new AccessReviewRequest(contextPath.addSegment("accessReviews").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviews accessReviews() {
        return new AccessReviews(
                        contextPath.addSegment("accessReviews"));
    }

    public ApprovalWorkflowProviderRequest approvalWorkflowProviders(String id) {
        return new ApprovalWorkflowProviderRequest(contextPath.addSegment("approvalWorkflowProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalWorkflowProviders approvalWorkflowProviders() {
        return new ApprovalWorkflowProviders(
                        contextPath.addSegment("approvalWorkflowProviders"));
    }

    public BusinessFlowTemplateRequest businessFlowTemplates(String id) {
        return new BusinessFlowTemplateRequest(contextPath.addSegment("businessFlowTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BusinessFlowTemplates businessFlowTemplates() {
        return new BusinessFlowTemplates(
                        contextPath.addSegment("businessFlowTemplates"));
    }

    public ProgramControlRequest programControls(String id) {
        return new ProgramControlRequest(contextPath.addSegment("programControls").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProgramControls programControls() {
        return new ProgramControls(
                        contextPath.addSegment("programControls"));
    }

    public ProgramControlTypeRequest programControlTypes(String id) {
        return new ProgramControlTypeRequest(contextPath.addSegment("programControlTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProgramControlTypes programControlTypes() {
        return new ProgramControlTypes(
                        contextPath.addSegment("programControlTypes"));
    }

    public ProgramRequest programs(String id) {
        return new ProgramRequest(contextPath.addSegment("programs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Programs programs() {
        return new Programs(
                        contextPath.addSegment("programs"));
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptances agreementAcceptances() {
        return new AgreementAcceptances(
                        contextPath.addSegment("agreementAcceptances"));
    }

    public AgreementRequest agreements(String id) {
        return new AgreementRequest(contextPath.addSegment("agreements").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Agreements agreements() {
        return new Agreements(
                        contextPath.addSegment("agreements"));
    }

    public RiskDetectionRequest riskDetections(String id) {
        return new RiskDetectionRequest(contextPath.addSegment("riskDetections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskDetections riskDetections() {
        return new RiskDetections(
                        contextPath.addSegment("riskDetections"));
    }

    public RiskyUserRequest riskyUsers(String id) {
        return new RiskyUserRequest(contextPath.addSegment("riskyUsers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyUsers riskyUsers() {
        return new RiskyUsers(
                        contextPath.addSegment("riskyUsers"));
    }

    public MobilityManagementPolicyRequest mobilityManagementPolicies(String id) {
        return new MobilityManagementPolicyRequest(contextPath.addSegment("mobilityManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobilityManagementPolicies mobilityManagementPolicies() {
        return new MobilityManagementPolicies(
                        contextPath.addSegment("mobilityManagementPolicies"));
    }

    public GovernanceResourceRequest governanceResources(String id) {
        return new GovernanceResourceRequest(contextPath.addSegment("governanceResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceResources governanceResources() {
        return new GovernanceResources(
                        contextPath.addSegment("governanceResources"));
    }

    public GovernanceRoleAssignmentRequestRequest governanceRoleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("governanceRoleAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignmentRequests governanceRoleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequests(
                        contextPath.addSegment("governanceRoleAssignmentRequests"));
    }

    public GovernanceRoleAssignmentRequest governanceRoleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("governanceRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignments governanceRoleAssignments() {
        return new GovernanceRoleAssignments(
                        contextPath.addSegment("governanceRoleAssignments"));
    }

    public GovernanceRoleDefinitionRequest governanceRoleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("governanceRoleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleDefinitions governanceRoleDefinitions() {
        return new GovernanceRoleDefinitions(
                        contextPath.addSegment("governanceRoleDefinitions"));
    }

    public GovernanceRoleSettingRequest governanceRoleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("governanceRoleSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleSettings governanceRoleSettings() {
        return new GovernanceRoleSettings(
                        contextPath.addSegment("governanceRoleSettings"));
    }

    public GovernanceSubjectRequest governanceSubjects(String id) {
        return new GovernanceSubjectRequest(contextPath.addSegment("governanceSubjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceSubjects governanceSubjects() {
        return new GovernanceSubjects(
                        contextPath.addSegment("governanceSubjects"));
    }

    public PrivilegedAccessRequest privilegedAccess(String id) {
        return new PrivilegedAccessRequest(contextPath.addSegment("privilegedAccess").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedAccess privilegedAccess() {
        return new PrivilegedAccess(
                        contextPath.addSegment("privilegedAccess"));
    }

    public PrivilegedApprovalRequest privilegedApproval(String id) {
        return new PrivilegedApprovalRequest(contextPath.addSegment("privilegedApproval").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedApproval privilegedApproval() {
        return new PrivilegedApproval(
                        contextPath.addSegment("privilegedApproval"));
    }

    public PrivilegedOperationEventRequest privilegedOperationEvents(String id) {
        return new PrivilegedOperationEventRequest(contextPath.addSegment("privilegedOperationEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedOperationEvents privilegedOperationEvents() {
        return new PrivilegedOperationEvents(
                        contextPath.addSegment("privilegedOperationEvents"));
    }

    public PrivilegedRoleAssignmentRequestRequest privilegedRoleAssignmentRequests(String id) {
        return new PrivilegedRoleAssignmentRequestRequest(contextPath.addSegment("privilegedRoleAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedRoleAssignmentRequests privilegedRoleAssignmentRequests() {
        return new PrivilegedRoleAssignmentRequests(
                        contextPath.addSegment("privilegedRoleAssignmentRequests"));
    }

    public PrivilegedRoleAssignmentRequest privilegedRoleAssignments(String id) {
        return new PrivilegedRoleAssignmentRequest(contextPath.addSegment("privilegedRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedRoleAssignments privilegedRoleAssignments() {
        return new PrivilegedRoleAssignments(
                        contextPath.addSegment("privilegedRoleAssignments"));
    }

    public PrivilegedRoleRequest privilegedRoles(String id) {
        return new PrivilegedRoleRequest(contextPath.addSegment("privilegedRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedRoles privilegedRoles() {
        return new PrivilegedRoles(
                        contextPath.addSegment("privilegedRoles"));
    }

    public PrivilegedSignupStatusRequest privilegedSignupStatus(String id) {
        return new PrivilegedSignupStatusRequest(contextPath.addSegment("privilegedSignupStatus").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedSignupStatus privilegedSignupStatus() {
        return new PrivilegedSignupStatus(
                        contextPath.addSegment("privilegedSignupStatus"));
    }

    public CommandRequest commands(String id) {
        return new CommandRequest(contextPath.addSegment("commands").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Commands commands() {
        return new Commands(
                        contextPath.addSegment("commands"));
    }

    public PayloadResponseRequest payloadResponse(String id) {
        return new PayloadResponseRequest(contextPath.addSegment("payloadResponse").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PayloadResponse payloadResponse() {
        return new PayloadResponse(
                        contextPath.addSegment("payloadResponse"));
    }

    public DataPolicyOperationRequest dataPolicyOperations(String id) {
        return new DataPolicyOperationRequest(contextPath.addSegment("dataPolicyOperations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataPolicyOperations dataPolicyOperations() {
        return new DataPolicyOperations(
                        contextPath.addSegment("dataPolicyOperations"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Subscriptions subscriptions() {
        return new Subscriptions(
                        contextPath.addSegment("subscriptions"));
    }

    public ExternalConnectionEntityRequest connections(String id) {
        return new ExternalConnectionEntityRequest(contextPath.addSegment("connections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Connections connections() {
        return new Connections(
                        contextPath.addSegment("connections"));
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Chats chats() {
        return new Chats(
                        contextPath.addSegment("chats"));
    }

    public TeamRequest teams(String id) {
        return new TeamRequest(contextPath.addSegment("teams").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Teams teams() {
        return new Teams(
                        contextPath.addSegment("teams"));
    }

    public TeamsTemplateRequest teamsTemplates(String id) {
        return new TeamsTemplateRequest(contextPath.addSegment("teamsTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsTemplates teamsTemplates() {
        return new TeamsTemplates(
                        contextPath.addSegment("teamsTemplates"));
    }

    public IdentityGovernanceRequest identityGovernance() {
        return new IdentityGovernanceRequest(contextPath.addSegment("identityGovernance"), Optional.empty());
    }

    public AuditLogRootRequest auditLogs() {
        return new AuditLogRootRequest(contextPath.addSegment("auditLogs"), Optional.empty());
    }

    public ReportRootRequest reports() {
        return new ReportRootRequest(contextPath.addSegment("reports"), Optional.empty());
    }

    public AuthenticationMethodsPolicyRequest authenticationMethodsPolicy() {
        return new AuthenticationMethodsPolicyRequest(contextPath.addSegment("authenticationMethodsPolicy"), Optional.empty());
    }

    public BitlockerRequest bitlocker() {
        return new BitlockerRequest(contextPath.addSegment("bitlocker"), Optional.empty());
    }

    public DeviceManagementRequest deviceManagement() {
        return new DeviceManagementRequest(contextPath.addSegment("deviceManagement"), Optional.empty());
    }

    public RoleManagementRequest roleManagement() {
        return new RoleManagementRequest(contextPath.addSegment("roleManagement"), Optional.empty());
    }

    public PrivacyRequest privacy() {
        return new PrivacyRequest(contextPath.addSegment("privacy"), Optional.empty());
    }

    public ComplianceRequest compliance() {
        return new ComplianceRequest(contextPath.addSegment("compliance"), Optional.empty());
    }

    public IdentityContainerRequest identity() {
        return new IdentityContainerRequest(contextPath.addSegment("identity"), Optional.empty());
    }

    public TrustFrameworkRequest trustFramework() {
        return new TrustFrameworkRequest(contextPath.addSegment("trustFramework"), Optional.empty());
    }

    public DataClassificationServiceRequest dataClassification() {
        return new DataClassificationServiceRequest(contextPath.addSegment("dataClassification"), Optional.empty());
    }

    public InformationProtectionRequest informationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"), Optional.empty());
    }

    public OrganizationalBrandingRequest branding() {
        return new OrganizationalBrandingRequest(contextPath.addSegment("branding"), Optional.empty());
    }

    public DirectoryRequest directory() {
        return new DirectoryRequest(contextPath.addSegment("directory"), Optional.empty());
    }

    public UserRequest me() {
        return new UserRequest(contextPath.addSegment("me"), Optional.empty());
    }

    public PolicyRootRequest policies() {
        return new PolicyRootRequest(contextPath.addSegment("policies"), Optional.empty());
    }

    public TenantRelationshipRequest tenantRelationships() {
        return new TenantRelationshipRequest(contextPath.addSegment("tenantRelationships"), Optional.empty());
    }

    public EducationRootRequest education() {
        return new EducationRootRequest(contextPath.addSegment("education"), Optional.empty());
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.empty());
    }

    public StoreRequest termStore() {
        return new StoreRequest(contextPath.addSegment("termStore"), Optional.empty());
    }

    public CloudCommunicationsRequest communications() {
        return new CloudCommunicationsRequest(contextPath.addSegment("communications"), Optional.empty());
    }

    public ConditionalAccessRootRequest conditionalAccess() {
        return new ConditionalAccessRootRequest(contextPath.addSegment("conditionalAccess"), Optional.empty());
    }

    public IdentityProtectionRootRequest identityProtection() {
        return new IdentityProtectionRootRequest(contextPath.addSegment("identityProtection"), Optional.empty());
    }

    public DeviceAppManagementRequest deviceAppManagement() {
        return new DeviceAppManagementRequest(contextPath.addSegment("deviceAppManagement"), Optional.empty());
    }

    public OfficeConfigurationRequest officeConfiguration() {
        return new OfficeConfigurationRequest(contextPath.addSegment("officeConfiguration"), Optional.empty());
    }

    public SearchEntityRequest search() {
        return new SearchEntityRequest(contextPath.addSegment("search"), Optional.empty());
    }

    public FinancialsRequest financials() {
        return new FinancialsRequest(contextPath.addSegment("financials"), Optional.empty());
    }

    public PlannerRequest planner() {
        return new PlannerRequest(contextPath.addSegment("planner"), Optional.empty());
    }

    public PrintRequest print() {
        return new PrintRequest(contextPath.addSegment("print"), Optional.empty());
    }

    public SecurityRequest security() {
        return new SecurityRequest(contextPath.addSegment("security"), Optional.empty());
    }

    public CommsApplicationRequest app() {
        return new CommsApplicationRequest(contextPath.addSegment("app"), Optional.empty());
    }

    public ExternalEntityRequest external() {
        return new ExternalEntityRequest(contextPath.addSegment("external"), Optional.empty());
    }

    public AppCatalogsRequest appCatalogs() {
        return new AppCatalogsRequest(contextPath.addSegment("appCatalogs"), Optional.empty());
    }

    public TeamworkRequest teamwork() {
        return new TeamworkRequest(contextPath.addSegment("teamwork"), Optional.empty());
    }

    public AdminRequest admin() {
        return new AdminRequest(contextPath.addSegment("admin"), Optional.empty());
    }

}
