package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "priority", 
    "userProperty", 
    "x509CertificateField"})
@JsonInclude(Include.NON_NULL)
public class X509CertificateUserBinding implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("userProperty")
    protected String userProperty;

    @JsonProperty("x509CertificateField")
    protected String x509CertificateField;

    protected X509CertificateUserBinding() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.x509CertificateUserBinding";
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public X509CertificateUserBinding withPriority(Integer priority) {
        X509CertificateUserBinding _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateUserBinding");
        _x.priority = priority;
        return _x;
    }

    @Property(name="userProperty")
    @JsonIgnore
    public Optional<String> getUserProperty() {
        return Optional.ofNullable(userProperty);
    }

    public X509CertificateUserBinding withUserProperty(String userProperty) {
        X509CertificateUserBinding _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateUserBinding");
        _x.userProperty = userProperty;
        return _x;
    }

    @Property(name="x509CertificateField")
    @JsonIgnore
    public Optional<String> getX509CertificateField() {
        return Optional.ofNullable(x509CertificateField);
    }

    public X509CertificateUserBinding withX509CertificateField(String x509CertificateField) {
        X509CertificateUserBinding _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateUserBinding");
        _x.x509CertificateField = x509CertificateField;
        return _x;
    }

    public X509CertificateUserBinding withUnmappedField(String name, Object value) {
        X509CertificateUserBinding _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer priority;
        private String userProperty;
        private String x509CertificateField;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder userProperty(String userProperty) {
            this.userProperty = userProperty;
            this.changedFields = changedFields.add("userProperty");
            return this;
        }

        public Builder x509CertificateField(String x509CertificateField) {
            this.x509CertificateField = x509CertificateField;
            this.changedFields = changedFields.add("x509CertificateField");
            return this;
        }

        public X509CertificateUserBinding build() {
            X509CertificateUserBinding _x = new X509CertificateUserBinding();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.x509CertificateUserBinding";
            _x.priority = priority;
            _x.userProperty = userProperty;
            _x.x509CertificateField = x509CertificateField;
            return _x;
        }
    }

    private X509CertificateUserBinding _copy() {
        X509CertificateUserBinding _x = new X509CertificateUserBinding();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.priority = priority;
        _x.userProperty = userProperty;
        _x.x509CertificateField = x509CertificateField;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("X509CertificateUserBinding[");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("userProperty=");
        b.append(this.userProperty);
        b.append(", ");
        b.append("x509CertificateField=");
        b.append(this.x509CertificateField);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
