package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.X509CertificateAuthenticationMode;

@JsonPropertyOrder({
    "@odata.type", 
    "rules", 
    "x509CertificateAuthenticationDefaultMode"})
@JsonInclude(Include.NON_NULL)
public class X509CertificateAuthenticationModeConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("rules")
    protected List<X509CertificateRule> rules;

    @JsonProperty("rules@nextLink")
    protected String rulesNextLink;

    @JsonProperty("x509CertificateAuthenticationDefaultMode")
    protected X509CertificateAuthenticationMode x509CertificateAuthenticationDefaultMode;

    protected X509CertificateAuthenticationModeConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.x509CertificateAuthenticationModeConfiguration";
    }

    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<X509CertificateRule> getRules() {
        return new CollectionPage<X509CertificateRule>(contextPath, X509CertificateRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<X509CertificateRule> getRules(HttpRequestOptions options) {
        return new CollectionPage<X509CertificateRule>(contextPath, X509CertificateRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), options);
    }

    @Property(name="x509CertificateAuthenticationDefaultMode")
    @JsonIgnore
    public Optional<X509CertificateAuthenticationMode> getX509CertificateAuthenticationDefaultMode() {
        return Optional.ofNullable(x509CertificateAuthenticationDefaultMode);
    }

    public X509CertificateAuthenticationModeConfiguration withX509CertificateAuthenticationDefaultMode(X509CertificateAuthenticationMode x509CertificateAuthenticationDefaultMode) {
        X509CertificateAuthenticationModeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateAuthenticationModeConfiguration");
        _x.x509CertificateAuthenticationDefaultMode = x509CertificateAuthenticationDefaultMode;
        return _x;
    }

    public X509CertificateAuthenticationModeConfiguration withUnmappedField(String name, Object value) {
        X509CertificateAuthenticationModeConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<X509CertificateRule> rules;
        private String rulesNextLink;
        private X509CertificateAuthenticationMode x509CertificateAuthenticationDefaultMode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder rules(List<X509CertificateRule> rules) {
            this.rules = rules;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        public Builder rules(X509CertificateRule... rules) {
            return rules(Arrays.asList(rules));
        }

        public Builder rulesNextLink(String rulesNextLink) {
            this.rulesNextLink = rulesNextLink;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        public Builder x509CertificateAuthenticationDefaultMode(X509CertificateAuthenticationMode x509CertificateAuthenticationDefaultMode) {
            this.x509CertificateAuthenticationDefaultMode = x509CertificateAuthenticationDefaultMode;
            this.changedFields = changedFields.add("x509CertificateAuthenticationDefaultMode");
            return this;
        }

        public X509CertificateAuthenticationModeConfiguration build() {
            X509CertificateAuthenticationModeConfiguration _x = new X509CertificateAuthenticationModeConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.x509CertificateAuthenticationModeConfiguration";
            _x.rules = rules;
            _x.rulesNextLink = rulesNextLink;
            _x.x509CertificateAuthenticationDefaultMode = x509CertificateAuthenticationDefaultMode;
            return _x;
        }
    }

    private X509CertificateAuthenticationModeConfiguration _copy() {
        X509CertificateAuthenticationModeConfiguration _x = new X509CertificateAuthenticationModeConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.rules = rules;
        _x.x509CertificateAuthenticationDefaultMode = x509CertificateAuthenticationDefaultMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("X509CertificateAuthenticationModeConfiguration[");
        b.append("rules=");
        b.append(this.rules);
        b.append(", ");
        b.append("x509CertificateAuthenticationDefaultMode=");
        b.append(this.x509CertificateAuthenticationDefaultMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
