package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;

@JsonPropertyOrder({
    "@odata.type", 
    "daysOfWeek", 
    "endTime", 
    "startTime", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class WorkingHours implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("daysOfWeek")
    protected List<DayOfWeek> daysOfWeek;

    @JsonProperty("daysOfWeek@nextLink")
    protected String daysOfWeekNextLink;

    @JsonProperty("endTime")
    protected LocalTime endTime;

    @JsonProperty("startTime")
    protected LocalTime startTime;

    @JsonProperty("timeZone")
    protected TimeZoneBase timeZone;

    protected WorkingHours() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workingHours";
    }

    @Property(name="daysOfWeek")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getDaysOfWeek() {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, this.daysOfWeek, Optional.ofNullable(daysOfWeekNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="daysOfWeek")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getDaysOfWeek(HttpRequestOptions options) {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, this.daysOfWeek, Optional.ofNullable(daysOfWeekNextLink), Collections.emptyList(), options);
    }

    @Property(name="endTime")
    @JsonIgnore
    public Optional<LocalTime> getEndTime() {
        return Optional.ofNullable(endTime);
    }

    public WorkingHours withEndTime(LocalTime endTime) {
        WorkingHours _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workingHours");
        _x.endTime = endTime;
        return _x;
    }

    @Property(name="startTime")
    @JsonIgnore
    public Optional<LocalTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    public WorkingHours withStartTime(LocalTime startTime) {
        WorkingHours _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workingHours");
        _x.startTime = startTime;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<TimeZoneBase> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public WorkingHours withTimeZone(TimeZoneBase timeZone) {
        WorkingHours _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workingHours");
        _x.timeZone = timeZone;
        return _x;
    }

    public WorkingHours withUnmappedField(String name, Object value) {
        WorkingHours _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DayOfWeek> daysOfWeek;
        private String daysOfWeekNextLink;
        private LocalTime endTime;
        private LocalTime startTime;
        private TimeZoneBase timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder daysOfWeek(List<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
            this.changedFields = changedFields.add("daysOfWeek");
            return this;
        }

        public Builder daysOfWeek(DayOfWeek... daysOfWeek) {
            return daysOfWeek(Arrays.asList(daysOfWeek));
        }

        public Builder daysOfWeekNextLink(String daysOfWeekNextLink) {
            this.daysOfWeekNextLink = daysOfWeekNextLink;
            this.changedFields = changedFields.add("daysOfWeek");
            return this;
        }

        public Builder endTime(LocalTime endTime) {
            this.endTime = endTime;
            this.changedFields = changedFields.add("endTime");
            return this;
        }

        public Builder startTime(LocalTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        public Builder timeZone(TimeZoneBase timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public WorkingHours build() {
            WorkingHours _x = new WorkingHours();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workingHours";
            _x.daysOfWeek = daysOfWeek;
            _x.daysOfWeekNextLink = daysOfWeekNextLink;
            _x.endTime = endTime;
            _x.startTime = startTime;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private WorkingHours _copy() {
        WorkingHours _x = new WorkingHours();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.daysOfWeek = daysOfWeek;
        _x.endTime = endTime;
        _x.startTime = startTime;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkingHours[");
        b.append("daysOfWeek=");
        b.append(this.daysOfWeek);
        b.append(", ");
        b.append("endTime=");
        b.append(this.endTime);
        b.append(", ");
        b.append("startTime=");
        b.append(this.startTime);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
