package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“A complex type to store the windows update rollout settings including offer
 * start date time, offer end date time, and days between each set of offers.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "offerEndDateTimeInUTC", 
    "offerIntervalInDays", 
    "offerStartDateTimeInUTC"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateRolloutSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("offerEndDateTimeInUTC")
    protected OffsetDateTime offerEndDateTimeInUTC;

    @JsonProperty("offerIntervalInDays")
    protected Integer offerIntervalInDays;

    @JsonProperty("offerStartDateTimeInUTC")
    protected OffsetDateTime offerStartDateTimeInUTC;

    protected WindowsUpdateRolloutSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateRolloutSettings";
    }

    /**
     * <i>“The feature update's ending  of release date and time to be set, update, and
     * displayed for a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
     * 
     * @return property offerEndDateTimeInUTC
     */
    @Property(name="offerEndDateTimeInUTC")
    @JsonIgnore
    public Optional<OffsetDateTime> getOfferEndDateTimeInUTC() {
        return Optional.ofNullable(offerEndDateTimeInUTC);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * offerEndDateTimeInUTC} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The feature update's ending  of release date and time to be set, update, and
     * displayed for a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
     * 
     * @param offerEndDateTimeInUTC
     *            new value of {@code offerEndDateTimeInUTC} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code offerEndDateTimeInUTC} field changed
     */
    public WindowsUpdateRolloutSettings withOfferEndDateTimeInUTC(OffsetDateTime offerEndDateTimeInUTC) {
        WindowsUpdateRolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateRolloutSettings");
        _x.offerEndDateTimeInUTC = offerEndDateTimeInUTC;
        return _x;
    }

    /**
     * <i>“The number of day(s) between each set of offers to be set, updated, and
     * displayed for a feature update profile, for example: if OfferStartDateTimeInUTC
     * is 2020-06-09T10:00:00Z, and OfferIntervalInDays is 1, then the next two sets of
     * offers will be made consecutively on 2020-06-10T10:00:00Z (next day at the same
     * specified time) and 2020-06-11T10:00:00Z (next next day at the same specified
     * time) with 1 day in between each set of offers.”</i>
     * 
     * @return property offerIntervalInDays
     */
    @Property(name="offerIntervalInDays")
    @JsonIgnore
    public Optional<Integer> getOfferIntervalInDays() {
        return Optional.ofNullable(offerIntervalInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * offerIntervalInDays} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of day(s) between each set of offers to be set, updated, and
     * displayed for a feature update profile, for example: if OfferStartDateTimeInUTC
     * is 2020-06-09T10:00:00Z, and OfferIntervalInDays is 1, then the next two sets of
     * offers will be made consecutively on 2020-06-10T10:00:00Z (next day at the same
     * specified time) and 2020-06-11T10:00:00Z (next next day at the same specified
     * time) with 1 day in between each set of offers.”</i>
     * 
     * @param offerIntervalInDays
     *            new value of {@code offerIntervalInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code offerIntervalInDays} field changed
     */
    public WindowsUpdateRolloutSettings withOfferIntervalInDays(Integer offerIntervalInDays) {
        WindowsUpdateRolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateRolloutSettings");
        _x.offerIntervalInDays = offerIntervalInDays;
        return _x;
    }

    /**
     * <i>“The feature update's starting date and time to be set, update, and displayed for
     * a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
     * 
     * @return property offerStartDateTimeInUTC
     */
    @Property(name="offerStartDateTimeInUTC")
    @JsonIgnore
    public Optional<OffsetDateTime> getOfferStartDateTimeInUTC() {
        return Optional.ofNullable(offerStartDateTimeInUTC);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * offerStartDateTimeInUTC} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The feature update's starting date and time to be set, update, and displayed for
     * a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
     * 
     * @param offerStartDateTimeInUTC
     *            new value of {@code offerStartDateTimeInUTC} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code offerStartDateTimeInUTC} field changed
     */
    public WindowsUpdateRolloutSettings withOfferStartDateTimeInUTC(OffsetDateTime offerStartDateTimeInUTC) {
        WindowsUpdateRolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateRolloutSettings");
        _x.offerStartDateTimeInUTC = offerStartDateTimeInUTC;
        return _x;
    }

    public WindowsUpdateRolloutSettings withUnmappedField(String name, Object value) {
        WindowsUpdateRolloutSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime offerEndDateTimeInUTC;
        private Integer offerIntervalInDays;
        private OffsetDateTime offerStartDateTimeInUTC;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The feature update's ending  of release date and time to be set, update, and
         * displayed for a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
         * 
         * @param offerEndDateTimeInUTC
         *            value of {@code offerEndDateTimeInUTC} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder offerEndDateTimeInUTC(OffsetDateTime offerEndDateTimeInUTC) {
            this.offerEndDateTimeInUTC = offerEndDateTimeInUTC;
            this.changedFields = changedFields.add("offerEndDateTimeInUTC");
            return this;
        }

        /**
         * <i>“The number of day(s) between each set of offers to be set, updated, and
         * displayed for a feature update profile, for example: if OfferStartDateTimeInUTC
         * is 2020-06-09T10:00:00Z, and OfferIntervalInDays is 1, then the next two sets of
         * offers will be made consecutively on 2020-06-10T10:00:00Z (next day at the same
         * specified time) and 2020-06-11T10:00:00Z (next next day at the same specified
         * time) with 1 day in between each set of offers.”</i>
         * 
         * @param offerIntervalInDays
         *            value of {@code offerIntervalInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder offerIntervalInDays(Integer offerIntervalInDays) {
            this.offerIntervalInDays = offerIntervalInDays;
            this.changedFields = changedFields.add("offerIntervalInDays");
            return this;
        }

        /**
         * <i>“The feature update's starting date and time to be set, update, and displayed for
         * a feature Update profile for example: 2020-06-09T10:00:00Z.”</i>
         * 
         * @param offerStartDateTimeInUTC
         *            value of {@code offerStartDateTimeInUTC} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder offerStartDateTimeInUTC(OffsetDateTime offerStartDateTimeInUTC) {
            this.offerStartDateTimeInUTC = offerStartDateTimeInUTC;
            this.changedFields = changedFields.add("offerStartDateTimeInUTC");
            return this;
        }

        public WindowsUpdateRolloutSettings build() {
            WindowsUpdateRolloutSettings _x = new WindowsUpdateRolloutSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdateRolloutSettings";
            _x.offerEndDateTimeInUTC = offerEndDateTimeInUTC;
            _x.offerIntervalInDays = offerIntervalInDays;
            _x.offerStartDateTimeInUTC = offerStartDateTimeInUTC;
            return _x;
        }
    }

    private WindowsUpdateRolloutSettings _copy() {
        WindowsUpdateRolloutSettings _x = new WindowsUpdateRolloutSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.offerEndDateTimeInUTC = offerEndDateTimeInUTC;
        _x.offerIntervalInDays = offerIntervalInDays;
        _x.offerStartDateTimeInUTC = offerStartDateTimeInUTC;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateRolloutSettings[");
        b.append("offerEndDateTimeInUTC=");
        b.append(this.offerEndDateTimeInUTC);
        b.append(", ");
        b.append("offerIntervalInDays=");
        b.append(this.offerIntervalInDays);
        b.append(", ");
        b.append("offerStartDateTimeInUTC=");
        b.append(this.offerStartDateTimeInUTC);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
