package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "activeHoursEnd", 
    "activeHoursStart"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateActiveHoursInstall extends WindowsUpdateInstallScheduleType implements ODataType {

    @JsonProperty("activeHoursEnd")
    protected LocalTime activeHoursEnd;

    @JsonProperty("activeHoursStart")
    protected LocalTime activeHoursStart;

    protected WindowsUpdateActiveHoursInstall() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateActiveHoursInstall";
    }

    /**
     * <i>“Active Hours End”</i>
     * 
     * @return property activeHoursEnd
     */
    @Property(name="activeHoursEnd")
    @JsonIgnore
    public Optional<LocalTime> getActiveHoursEnd() {
        return Optional.ofNullable(activeHoursEnd);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeHoursEnd}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Active Hours End”</i>
     * 
     * @param activeHoursEnd
     *            new value of {@code activeHoursEnd} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeHoursEnd} field changed
     */
    public WindowsUpdateActiveHoursInstall withActiveHoursEnd(LocalTime activeHoursEnd) {
        WindowsUpdateActiveHoursInstall _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateActiveHoursInstall");
        _x.activeHoursEnd = activeHoursEnd;
        return _x;
    }

    /**
     * <i>“Active Hours Start”</i>
     * 
     * @return property activeHoursStart
     */
    @Property(name="activeHoursStart")
    @JsonIgnore
    public Optional<LocalTime> getActiveHoursStart() {
        return Optional.ofNullable(activeHoursStart);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeHoursStart}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Active Hours Start”</i>
     * 
     * @param activeHoursStart
     *            new value of {@code activeHoursStart} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeHoursStart} field changed
     */
    public WindowsUpdateActiveHoursInstall withActiveHoursStart(LocalTime activeHoursStart) {
        WindowsUpdateActiveHoursInstall _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateActiveHoursInstall");
        _x.activeHoursStart = activeHoursStart;
        return _x;
    }

    public WindowsUpdateActiveHoursInstall withUnmappedField(String name, Object value) {
        WindowsUpdateActiveHoursInstall _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUpdateActiveHoursInstall() {
        return new Builder();
    }

    public static final class Builder {
        private LocalTime activeHoursEnd;
        private LocalTime activeHoursStart;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Active Hours End”</i>
         * 
         * @param activeHoursEnd
         *            value of {@code activeHoursEnd} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeHoursEnd(LocalTime activeHoursEnd) {
            this.activeHoursEnd = activeHoursEnd;
            this.changedFields = changedFields.add("activeHoursEnd");
            return this;
        }

        /**
         * <i>“Active Hours Start”</i>
         * 
         * @param activeHoursStart
         *            value of {@code activeHoursStart} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeHoursStart(LocalTime activeHoursStart) {
            this.activeHoursStart = activeHoursStart;
            this.changedFields = changedFields.add("activeHoursStart");
            return this;
        }

        public WindowsUpdateActiveHoursInstall build() {
            WindowsUpdateActiveHoursInstall _x = new WindowsUpdateActiveHoursInstall();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdateActiveHoursInstall";
            _x.activeHoursEnd = activeHoursEnd;
            _x.activeHoursStart = activeHoursStart;
            return _x;
        }
    }

    private WindowsUpdateActiveHoursInstall _copy() {
        WindowsUpdateActiveHoursInstall _x = new WindowsUpdateActiveHoursInstall();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.activeHoursEnd = activeHoursEnd;
        _x.activeHoursStart = activeHoursStart;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateActiveHoursInstall[");
        b.append("activeHoursEnd=");
        b.append(this.activeHoursEnd);
        b.append(", ");
        b.append("activeHoursStart=");
        b.append(this.activeHoursStart);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
