package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareThreatState;


/**
 * <i>“Windows Malware State Summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceCount", 
    "distinctMalwareCount", 
    "lastUpdateDateTime", 
    "malwareDetectionCount", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareStateCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("distinctMalwareCount")
    protected Integer distinctMalwareCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    @JsonProperty("malwareDetectionCount")
    protected Integer malwareDetectionCount;

    @JsonProperty("state")
    protected WindowsMalwareThreatState state;

    protected WindowsMalwareStateCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareStateCount";
    }

    /**
     * <i>“Count of devices with malware detections for this malware State”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of devices with malware detections for this malware State”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsMalwareStateCount withDeviceCount(Integer deviceCount) {
        WindowsMalwareStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareStateCount");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property distinctMalwareCount
     */
    @Property(name="distinctMalwareCount")
    @JsonIgnore
    public Optional<Integer> getDistinctMalwareCount() {
        return Optional.ofNullable(distinctMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * distinctMalwareCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param distinctMalwareCount
     *            new value of {@code distinctMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code distinctMalwareCount} field changed
     */
    public WindowsMalwareStateCount withDistinctMalwareCount(Integer distinctMalwareCount) {
        WindowsMalwareStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareStateCount");
        _x.distinctMalwareCount = distinctMalwareCount;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public WindowsMalwareStateCount withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        WindowsMalwareStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareStateCount");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“Count of total malware detections for this malware State. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property malwareDetectionCount
     */
    @Property(name="malwareDetectionCount")
    @JsonIgnore
    public Optional<Integer> getMalwareDetectionCount() {
        return Optional.ofNullable(malwareDetectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * malwareDetectionCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Count of total malware detections for this malware State. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param malwareDetectionCount
     *            new value of {@code malwareDetectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code malwareDetectionCount} field changed
     */
    public WindowsMalwareStateCount withMalwareDetectionCount(Integer malwareDetectionCount) {
        WindowsMalwareStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareStateCount");
        _x.malwareDetectionCount = malwareDetectionCount;
        return _x;
    }

    /**
     * <i>“Malware Threat State”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<WindowsMalwareThreatState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Malware Threat State”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public WindowsMalwareStateCount withState(WindowsMalwareThreatState state) {
        WindowsMalwareStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareStateCount");
        _x.state = state;
        return _x;
    }

    public WindowsMalwareStateCount withUnmappedField(String name, Object value) {
        WindowsMalwareStateCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer deviceCount;
        private Integer distinctMalwareCount;
        private OffsetDateTime lastUpdateDateTime;
        private Integer malwareDetectionCount;
        private WindowsMalwareThreatState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Count of devices with malware detections for this malware State”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param distinctMalwareCount
         *            value of {@code distinctMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder distinctMalwareCount(Integer distinctMalwareCount) {
            this.distinctMalwareCount = distinctMalwareCount;
            this.changedFields = changedFields.add("distinctMalwareCount");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update for the device count in UTC”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“Count of total malware detections for this malware State. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param malwareDetectionCount
         *            value of {@code malwareDetectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareDetectionCount(Integer malwareDetectionCount) {
            this.malwareDetectionCount = malwareDetectionCount;
            this.changedFields = changedFields.add("malwareDetectionCount");
            return this;
        }

        /**
         * <i>“Malware Threat State”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(WindowsMalwareThreatState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public WindowsMalwareStateCount build() {
            WindowsMalwareStateCount _x = new WindowsMalwareStateCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareStateCount";
            _x.deviceCount = deviceCount;
            _x.distinctMalwareCount = distinctMalwareCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.malwareDetectionCount = malwareDetectionCount;
            _x.state = state;
            return _x;
        }
    }

    private WindowsMalwareStateCount _copy() {
        WindowsMalwareStateCount _x = new WindowsMalwareStateCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceCount = deviceCount;
        _x.distinctMalwareCount = distinctMalwareCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.malwareDetectionCount = malwareDetectionCount;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareStateCount[");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("distinctMalwareCount=");
        b.append(this.distinctMalwareCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("malwareDetectionCount=");
        b.append(this.malwareDetectionCount);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
