package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Windows device malware overview.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "malwareCategorySummary", 
    "malwareDetectedDeviceCount", 
    "malwareExecutionStateSummary", 
    "malwareNameSummary", 
    "malwareSeveritySummary", 
    "malwareStateSummary", 
    "osVersionsSummary", 
    "totalDistinctMalwareCount", 
    "totalMalwareCount"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareOverview implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("malwareCategorySummary")
    protected List<WindowsMalwareCategoryCount> malwareCategorySummary;

    @JsonProperty("malwareCategorySummary@nextLink")
    protected String malwareCategorySummaryNextLink;

    @JsonProperty("malwareDetectedDeviceCount")
    protected Integer malwareDetectedDeviceCount;

    @JsonProperty("malwareExecutionStateSummary")
    protected List<WindowsMalwareExecutionStateCount> malwareExecutionStateSummary;

    @JsonProperty("malwareExecutionStateSummary@nextLink")
    protected String malwareExecutionStateSummaryNextLink;

    @JsonProperty("malwareNameSummary")
    protected List<WindowsMalwareNameCount> malwareNameSummary;

    @JsonProperty("malwareNameSummary@nextLink")
    protected String malwareNameSummaryNextLink;

    @JsonProperty("malwareSeveritySummary")
    protected List<WindowsMalwareSeverityCount> malwareSeveritySummary;

    @JsonProperty("malwareSeveritySummary@nextLink")
    protected String malwareSeveritySummaryNextLink;

    @JsonProperty("malwareStateSummary")
    protected List<WindowsMalwareStateCount> malwareStateSummary;

    @JsonProperty("malwareStateSummary@nextLink")
    protected String malwareStateSummaryNextLink;

    @JsonProperty("osVersionsSummary")
    protected List<OsVersionCount> osVersionsSummary;

    @JsonProperty("osVersionsSummary@nextLink")
    protected String osVersionsSummaryNextLink;

    @JsonProperty("totalDistinctMalwareCount")
    protected Integer totalDistinctMalwareCount;

    @JsonProperty("totalMalwareCount")
    protected Integer totalMalwareCount;

    protected WindowsMalwareOverview() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareOverview";
    }

    /**
     * <i>“Count of devices per malware category”</i>
     * 
     * @return property malwareCategorySummary
     */
    @Property(name="malwareCategorySummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareCategoryCount> getMalwareCategorySummary() {
        return new CollectionPage<WindowsMalwareCategoryCount>(contextPath, WindowsMalwareCategoryCount.class, this.malwareCategorySummary, Optional.ofNullable(malwareCategorySummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of devices per malware category”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property malwareCategorySummary
     */
    @Property(name="malwareCategorySummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareCategoryCount> getMalwareCategorySummary(HttpRequestOptions options) {
        return new CollectionPage<WindowsMalwareCategoryCount>(contextPath, WindowsMalwareCategoryCount.class, this.malwareCategorySummary, Optional.ofNullable(malwareCategorySummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of devices with malware detected in the last 30 days”</i>
     * 
     * @return property malwareDetectedDeviceCount
     */
    @Property(name="malwareDetectedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getMalwareDetectedDeviceCount() {
        return Optional.ofNullable(malwareDetectedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * malwareDetectedDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of devices with malware detected in the last 30 days”</i>
     * 
     * @param malwareDetectedDeviceCount
     *            new value of {@code malwareDetectedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code malwareDetectedDeviceCount} field changed
     */
    public WindowsMalwareOverview withMalwareDetectedDeviceCount(Integer malwareDetectedDeviceCount) {
        WindowsMalwareOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareOverview");
        _x.malwareDetectedDeviceCount = malwareDetectedDeviceCount;
        return _x;
    }

    /**
     * <i>“Count of devices per malware execution state”</i>
     * 
     * @return property malwareExecutionStateSummary
     */
    @Property(name="malwareExecutionStateSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareExecutionStateCount> getMalwareExecutionStateSummary() {
        return new CollectionPage<WindowsMalwareExecutionStateCount>(contextPath, WindowsMalwareExecutionStateCount.class, this.malwareExecutionStateSummary, Optional.ofNullable(malwareExecutionStateSummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of devices per malware execution state”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property malwareExecutionStateSummary
     */
    @Property(name="malwareExecutionStateSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareExecutionStateCount> getMalwareExecutionStateSummary(HttpRequestOptions options) {
        return new CollectionPage<WindowsMalwareExecutionStateCount>(contextPath, WindowsMalwareExecutionStateCount.class, this.malwareExecutionStateSummary, Optional.ofNullable(malwareExecutionStateSummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of devices per malware”</i>
     * 
     * @return property malwareNameSummary
     */
    @Property(name="malwareNameSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareNameCount> getMalwareNameSummary() {
        return new CollectionPage<WindowsMalwareNameCount>(contextPath, WindowsMalwareNameCount.class, this.malwareNameSummary, Optional.ofNullable(malwareNameSummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of devices per malware”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property malwareNameSummary
     */
    @Property(name="malwareNameSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareNameCount> getMalwareNameSummary(HttpRequestOptions options) {
        return new CollectionPage<WindowsMalwareNameCount>(contextPath, WindowsMalwareNameCount.class, this.malwareNameSummary, Optional.ofNullable(malwareNameSummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of active malware per malware severity”</i>
     * 
     * @return property malwareSeveritySummary
     */
    @Property(name="malwareSeveritySummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareSeverityCount> getMalwareSeveritySummary() {
        return new CollectionPage<WindowsMalwareSeverityCount>(contextPath, WindowsMalwareSeverityCount.class, this.malwareSeveritySummary, Optional.ofNullable(malwareSeveritySummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of active malware per malware severity”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property malwareSeveritySummary
     */
    @Property(name="malwareSeveritySummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareSeverityCount> getMalwareSeveritySummary(HttpRequestOptions options) {
        return new CollectionPage<WindowsMalwareSeverityCount>(contextPath, WindowsMalwareSeverityCount.class, this.malwareSeveritySummary, Optional.ofNullable(malwareSeveritySummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of devices per malware state”</i>
     * 
     * @return property malwareStateSummary
     */
    @Property(name="malwareStateSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareStateCount> getMalwareStateSummary() {
        return new CollectionPage<WindowsMalwareStateCount>(contextPath, WindowsMalwareStateCount.class, this.malwareStateSummary, Optional.ofNullable(malwareStateSummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of devices per malware state”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property malwareStateSummary
     */
    @Property(name="malwareStateSummary")
    @JsonIgnore
    public CollectionPage<WindowsMalwareStateCount> getMalwareStateSummary(HttpRequestOptions options) {
        return new CollectionPage<WindowsMalwareStateCount>(contextPath, WindowsMalwareStateCount.class, this.malwareStateSummary, Optional.ofNullable(malwareStateSummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of devices with malware per windows OS version”</i>
     * 
     * @return property osVersionsSummary
     */
    @Property(name="osVersionsSummary")
    @JsonIgnore
    public CollectionPage<OsVersionCount> getOsVersionsSummary() {
        return new CollectionPage<OsVersionCount>(contextPath, OsVersionCount.class, this.osVersionsSummary, Optional.ofNullable(osVersionsSummaryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Count of devices with malware per windows OS version”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property osVersionsSummary
     */
    @Property(name="osVersionsSummary")
    @JsonIgnore
    public CollectionPage<OsVersionCount> getOsVersionsSummary(HttpRequestOptions options) {
        return new CollectionPage<OsVersionCount>(contextPath, OsVersionCount.class, this.osVersionsSummary, Optional.ofNullable(osVersionsSummaryNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of all distinct malwares detected across all devices. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property totalDistinctMalwareCount
     */
    @Property(name="totalDistinctMalwareCount")
    @JsonIgnore
    public Optional<Integer> getTotalDistinctMalwareCount() {
        return Optional.ofNullable(totalDistinctMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalDistinctMalwareCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of all distinct malwares detected across all devices. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param totalDistinctMalwareCount
     *            new value of {@code totalDistinctMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalDistinctMalwareCount} field changed
     */
    public WindowsMalwareOverview withTotalDistinctMalwareCount(Integer totalDistinctMalwareCount) {
        WindowsMalwareOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareOverview");
        _x.totalDistinctMalwareCount = totalDistinctMalwareCount;
        return _x;
    }

    /**
     * <i>“Count of all malware detections across all devices. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property totalMalwareCount
     */
    @Property(name="totalMalwareCount")
    @JsonIgnore
    public Optional<Integer> getTotalMalwareCount() {
        return Optional.ofNullable(totalMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalMalwareCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of all malware detections across all devices. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param totalMalwareCount
     *            new value of {@code totalMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalMalwareCount} field changed
     */
    public WindowsMalwareOverview withTotalMalwareCount(Integer totalMalwareCount) {
        WindowsMalwareOverview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareOverview");
        _x.totalMalwareCount = totalMalwareCount;
        return _x;
    }

    public WindowsMalwareOverview withUnmappedField(String name, Object value) {
        WindowsMalwareOverview _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<WindowsMalwareCategoryCount> malwareCategorySummary;
        private String malwareCategorySummaryNextLink;
        private Integer malwareDetectedDeviceCount;
        private List<WindowsMalwareExecutionStateCount> malwareExecutionStateSummary;
        private String malwareExecutionStateSummaryNextLink;
        private List<WindowsMalwareNameCount> malwareNameSummary;
        private String malwareNameSummaryNextLink;
        private List<WindowsMalwareSeverityCount> malwareSeveritySummary;
        private String malwareSeveritySummaryNextLink;
        private List<WindowsMalwareStateCount> malwareStateSummary;
        private String malwareStateSummaryNextLink;
        private List<OsVersionCount> osVersionsSummary;
        private String osVersionsSummaryNextLink;
        private Integer totalDistinctMalwareCount;
        private Integer totalMalwareCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Count of devices per malware category”</i>
         * 
         * @param malwareCategorySummary
         *            value of {@code malwareCategorySummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareCategorySummary(List<WindowsMalwareCategoryCount> malwareCategorySummary) {
            this.malwareCategorySummary = malwareCategorySummary;
            this.changedFields = changedFields.add("malwareCategorySummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware category”</i>
         * 
         * @param malwareCategorySummary
         *            value of {@code malwareCategorySummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareCategorySummary(WindowsMalwareCategoryCount... malwareCategorySummary) {
            return malwareCategorySummary(Arrays.asList(malwareCategorySummary));
        }

        /**
         * <i>“Count of devices per malware category”</i>
         * 
         * @param malwareCategorySummaryNextLink
         *            value of {@code malwareCategorySummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareCategorySummaryNextLink(String malwareCategorySummaryNextLink) {
            this.malwareCategorySummaryNextLink = malwareCategorySummaryNextLink;
            this.changedFields = changedFields.add("malwareCategorySummary");
            return this;
        }

        /**
         * <i>“Count of devices with malware detected in the last 30 days”</i>
         * 
         * @param malwareDetectedDeviceCount
         *            value of {@code malwareDetectedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareDetectedDeviceCount(Integer malwareDetectedDeviceCount) {
            this.malwareDetectedDeviceCount = malwareDetectedDeviceCount;
            this.changedFields = changedFields.add("malwareDetectedDeviceCount");
            return this;
        }

        /**
         * <i>“Count of devices per malware execution state”</i>
         * 
         * @param malwareExecutionStateSummary
         *            value of {@code malwareExecutionStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareExecutionStateSummary(List<WindowsMalwareExecutionStateCount> malwareExecutionStateSummary) {
            this.malwareExecutionStateSummary = malwareExecutionStateSummary;
            this.changedFields = changedFields.add("malwareExecutionStateSummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware execution state”</i>
         * 
         * @param malwareExecutionStateSummary
         *            value of {@code malwareExecutionStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareExecutionStateSummary(WindowsMalwareExecutionStateCount... malwareExecutionStateSummary) {
            return malwareExecutionStateSummary(Arrays.asList(malwareExecutionStateSummary));
        }

        /**
         * <i>“Count of devices per malware execution state”</i>
         * 
         * @param malwareExecutionStateSummaryNextLink
         *            value of {@code malwareExecutionStateSummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareExecutionStateSummaryNextLink(String malwareExecutionStateSummaryNextLink) {
            this.malwareExecutionStateSummaryNextLink = malwareExecutionStateSummaryNextLink;
            this.changedFields = changedFields.add("malwareExecutionStateSummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware”</i>
         * 
         * @param malwareNameSummary
         *            value of {@code malwareNameSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareNameSummary(List<WindowsMalwareNameCount> malwareNameSummary) {
            this.malwareNameSummary = malwareNameSummary;
            this.changedFields = changedFields.add("malwareNameSummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware”</i>
         * 
         * @param malwareNameSummary
         *            value of {@code malwareNameSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareNameSummary(WindowsMalwareNameCount... malwareNameSummary) {
            return malwareNameSummary(Arrays.asList(malwareNameSummary));
        }

        /**
         * <i>“Count of devices per malware”</i>
         * 
         * @param malwareNameSummaryNextLink
         *            value of {@code malwareNameSummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareNameSummaryNextLink(String malwareNameSummaryNextLink) {
            this.malwareNameSummaryNextLink = malwareNameSummaryNextLink;
            this.changedFields = changedFields.add("malwareNameSummary");
            return this;
        }

        /**
         * <i>“Count of active malware per malware severity”</i>
         * 
         * @param malwareSeveritySummary
         *            value of {@code malwareSeveritySummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareSeveritySummary(List<WindowsMalwareSeverityCount> malwareSeveritySummary) {
            this.malwareSeveritySummary = malwareSeveritySummary;
            this.changedFields = changedFields.add("malwareSeveritySummary");
            return this;
        }

        /**
         * <i>“Count of active malware per malware severity”</i>
         * 
         * @param malwareSeveritySummary
         *            value of {@code malwareSeveritySummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareSeveritySummary(WindowsMalwareSeverityCount... malwareSeveritySummary) {
            return malwareSeveritySummary(Arrays.asList(malwareSeveritySummary));
        }

        /**
         * <i>“Count of active malware per malware severity”</i>
         * 
         * @param malwareSeveritySummaryNextLink
         *            value of {@code malwareSeveritySummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareSeveritySummaryNextLink(String malwareSeveritySummaryNextLink) {
            this.malwareSeveritySummaryNextLink = malwareSeveritySummaryNextLink;
            this.changedFields = changedFields.add("malwareSeveritySummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware state”</i>
         * 
         * @param malwareStateSummary
         *            value of {@code malwareStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareStateSummary(List<WindowsMalwareStateCount> malwareStateSummary) {
            this.malwareStateSummary = malwareStateSummary;
            this.changedFields = changedFields.add("malwareStateSummary");
            return this;
        }

        /**
         * <i>“Count of devices per malware state”</i>
         * 
         * @param malwareStateSummary
         *            value of {@code malwareStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareStateSummary(WindowsMalwareStateCount... malwareStateSummary) {
            return malwareStateSummary(Arrays.asList(malwareStateSummary));
        }

        /**
         * <i>“Count of devices per malware state”</i>
         * 
         * @param malwareStateSummaryNextLink
         *            value of {@code malwareStateSummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareStateSummaryNextLink(String malwareStateSummaryNextLink) {
            this.malwareStateSummaryNextLink = malwareStateSummaryNextLink;
            this.changedFields = changedFields.add("malwareStateSummary");
            return this;
        }

        /**
         * <i>“Count of devices with malware per windows OS version”</i>
         * 
         * @param osVersionsSummary
         *            value of {@code osVersionsSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersionsSummary(List<OsVersionCount> osVersionsSummary) {
            this.osVersionsSummary = osVersionsSummary;
            this.changedFields = changedFields.add("osVersionsSummary");
            return this;
        }

        /**
         * <i>“Count of devices with malware per windows OS version”</i>
         * 
         * @param osVersionsSummary
         *            value of {@code osVersionsSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersionsSummary(OsVersionCount... osVersionsSummary) {
            return osVersionsSummary(Arrays.asList(osVersionsSummary));
        }

        /**
         * <i>“Count of devices with malware per windows OS version”</i>
         * 
         * @param osVersionsSummaryNextLink
         *            value of {@code osVersionsSummary@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersionsSummaryNextLink(String osVersionsSummaryNextLink) {
            this.osVersionsSummaryNextLink = osVersionsSummaryNextLink;
            this.changedFields = changedFields.add("osVersionsSummary");
            return this;
        }

        /**
         * <i>“Count of all distinct malwares detected across all devices. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param totalDistinctMalwareCount
         *            value of {@code totalDistinctMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalDistinctMalwareCount(Integer totalDistinctMalwareCount) {
            this.totalDistinctMalwareCount = totalDistinctMalwareCount;
            this.changedFields = changedFields.add("totalDistinctMalwareCount");
            return this;
        }

        /**
         * <i>“Count of all malware detections across all devices. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param totalMalwareCount
         *            value of {@code totalMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalMalwareCount(Integer totalMalwareCount) {
            this.totalMalwareCount = totalMalwareCount;
            this.changedFields = changedFields.add("totalMalwareCount");
            return this;
        }

        public WindowsMalwareOverview build() {
            WindowsMalwareOverview _x = new WindowsMalwareOverview();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareOverview";
            _x.malwareCategorySummary = malwareCategorySummary;
            _x.malwareCategorySummaryNextLink = malwareCategorySummaryNextLink;
            _x.malwareDetectedDeviceCount = malwareDetectedDeviceCount;
            _x.malwareExecutionStateSummary = malwareExecutionStateSummary;
            _x.malwareExecutionStateSummaryNextLink = malwareExecutionStateSummaryNextLink;
            _x.malwareNameSummary = malwareNameSummary;
            _x.malwareNameSummaryNextLink = malwareNameSummaryNextLink;
            _x.malwareSeveritySummary = malwareSeveritySummary;
            _x.malwareSeveritySummaryNextLink = malwareSeveritySummaryNextLink;
            _x.malwareStateSummary = malwareStateSummary;
            _x.malwareStateSummaryNextLink = malwareStateSummaryNextLink;
            _x.osVersionsSummary = osVersionsSummary;
            _x.osVersionsSummaryNextLink = osVersionsSummaryNextLink;
            _x.totalDistinctMalwareCount = totalDistinctMalwareCount;
            _x.totalMalwareCount = totalMalwareCount;
            return _x;
        }
    }

    private WindowsMalwareOverview _copy() {
        WindowsMalwareOverview _x = new WindowsMalwareOverview();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.malwareCategorySummary = malwareCategorySummary;
        _x.malwareDetectedDeviceCount = malwareDetectedDeviceCount;
        _x.malwareExecutionStateSummary = malwareExecutionStateSummary;
        _x.malwareNameSummary = malwareNameSummary;
        _x.malwareSeveritySummary = malwareSeveritySummary;
        _x.malwareStateSummary = malwareStateSummary;
        _x.osVersionsSummary = osVersionsSummary;
        _x.totalDistinctMalwareCount = totalDistinctMalwareCount;
        _x.totalMalwareCount = totalMalwareCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareOverview[");
        b.append("malwareCategorySummary=");
        b.append(this.malwareCategorySummary);
        b.append(", ");
        b.append("malwareDetectedDeviceCount=");
        b.append(this.malwareDetectedDeviceCount);
        b.append(", ");
        b.append("malwareExecutionStateSummary=");
        b.append(this.malwareExecutionStateSummary);
        b.append(", ");
        b.append("malwareNameSummary=");
        b.append(this.malwareNameSummary);
        b.append(", ");
        b.append("malwareSeveritySummary=");
        b.append(this.malwareSeveritySummary);
        b.append(", ");
        b.append("malwareStateSummary=");
        b.append(this.malwareStateSummary);
        b.append(", ");
        b.append("osVersionsSummary=");
        b.append(this.osVersionsSummary);
        b.append(", ");
        b.append("totalDistinctMalwareCount=");
        b.append(this.totalDistinctMalwareCount);
        b.append(", ");
        b.append("totalMalwareCount=");
        b.append(this.totalMalwareCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
