package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Malware name device count”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceCount", 
    "lastUpdateDateTime", 
    "malwareIdentifier", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareNameCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    @JsonProperty("malwareIdentifier")
    protected String malwareIdentifier;

    @JsonProperty("name")
    protected String name;

    protected WindowsMalwareNameCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareNameCount";
    }

    /**
     * <i>“Count of devices with malware dectected for this malware”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of devices with malware dectected for this malware”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsMalwareNameCount withDeviceCount(Integer deviceCount) {
        WindowsMalwareNameCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareNameCount");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public WindowsMalwareNameCount withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        WindowsMalwareNameCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareNameCount");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The unique identifier. This is malware identifier”</i>
     * 
     * @return property malwareIdentifier
     */
    @Property(name="malwareIdentifier")
    @JsonIgnore
    public Optional<String> getMalwareIdentifier() {
        return Optional.ofNullable(malwareIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code malwareIdentifier
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The unique identifier. This is malware identifier”</i>
     * 
     * @param malwareIdentifier
     *            new value of {@code malwareIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code malwareIdentifier} field changed
     */
    public WindowsMalwareNameCount withMalwareIdentifier(String malwareIdentifier) {
        WindowsMalwareNameCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareNameCount");
        _x.malwareIdentifier = malwareIdentifier;
        return _x;
    }

    /**
     * <i>“Malware name”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Malware name”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public WindowsMalwareNameCount withName(String name) {
        WindowsMalwareNameCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareNameCount");
        _x.name = name;
        return _x;
    }

    public WindowsMalwareNameCount withUnmappedField(String name, Object value) {
        WindowsMalwareNameCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer deviceCount;
        private OffsetDateTime lastUpdateDateTime;
        private String malwareIdentifier;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Count of devices with malware dectected for this malware”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update for the device count in UTC”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“The unique identifier. This is malware identifier”</i>
         * 
         * @param malwareIdentifier
         *            value of {@code malwareIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareIdentifier(String malwareIdentifier) {
            this.malwareIdentifier = malwareIdentifier;
            this.changedFields = changedFields.add("malwareIdentifier");
            return this;
        }

        /**
         * <i>“Malware name”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public WindowsMalwareNameCount build() {
            WindowsMalwareNameCount _x = new WindowsMalwareNameCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareNameCount";
            _x.deviceCount = deviceCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.malwareIdentifier = malwareIdentifier;
            _x.name = name;
            return _x;
        }
    }

    private WindowsMalwareNameCount _copy() {
        WindowsMalwareNameCount _x = new WindowsMalwareNameCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceCount = deviceCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.malwareIdentifier = malwareIdentifier;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareNameCount[");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("malwareIdentifier=");
        b.append(this.malwareIdentifier);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
