package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareCategory;


/**
 * <i>“Malware category device count”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeMalwareDetectionCount", 
    "category", 
    "deviceCount", 
    "distinctActiveMalwareCount", 
    "lastUpdateDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareCategoryCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("activeMalwareDetectionCount")
    protected Integer activeMalwareDetectionCount;

    @JsonProperty("category")
    protected WindowsMalwareCategory category;

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("distinctActiveMalwareCount")
    protected Integer distinctActiveMalwareCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    protected WindowsMalwareCategoryCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareCategoryCount";
    }

    /**
     * <i>“Count of active malware detections for this malware category. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property activeMalwareDetectionCount
     */
    @Property(name="activeMalwareDetectionCount")
    @JsonIgnore
    public Optional<Integer> getActiveMalwareDetectionCount() {
        return Optional.ofNullable(activeMalwareDetectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeMalwareDetectionCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of active malware detections for this malware category. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param activeMalwareDetectionCount
     *            new value of {@code activeMalwareDetectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeMalwareDetectionCount} field changed
     */
    public WindowsMalwareCategoryCount withActiveMalwareDetectionCount(Integer activeMalwareDetectionCount) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareCategoryCount");
        _x.activeMalwareDetectionCount = activeMalwareDetectionCount;
        return _x;
    }

    /**
     * <i>“Malware category”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<WindowsMalwareCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Malware category”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public WindowsMalwareCategoryCount withCategory(WindowsMalwareCategory category) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareCategoryCount");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“Count of devices with malware detections for this malware category”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of devices with malware detections for this malware category”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsMalwareCategoryCount withDeviceCount(Integer deviceCount) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareCategoryCount");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“Count of distinct active malwares for this malware category. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property distinctActiveMalwareCount
     */
    @Property(name="distinctActiveMalwareCount")
    @JsonIgnore
    public Optional<Integer> getDistinctActiveMalwareCount() {
        return Optional.ofNullable(distinctActiveMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * distinctActiveMalwareCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of distinct active malwares for this malware category. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param distinctActiveMalwareCount
     *            new value of {@code distinctActiveMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code distinctActiveMalwareCount} field changed
     */
    public WindowsMalwareCategoryCount withDistinctActiveMalwareCount(Integer distinctActiveMalwareCount) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareCategoryCount");
        _x.distinctActiveMalwareCount = distinctActiveMalwareCount;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public WindowsMalwareCategoryCount withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareCategoryCount");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    public WindowsMalwareCategoryCount withUnmappedField(String name, Object value) {
        WindowsMalwareCategoryCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer activeMalwareDetectionCount;
        private WindowsMalwareCategory category;
        private Integer deviceCount;
        private Integer distinctActiveMalwareCount;
        private OffsetDateTime lastUpdateDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Count of active malware detections for this malware category. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param activeMalwareDetectionCount
         *            value of {@code activeMalwareDetectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeMalwareDetectionCount(Integer activeMalwareDetectionCount) {
            this.activeMalwareDetectionCount = activeMalwareDetectionCount;
            this.changedFields = changedFields.add("activeMalwareDetectionCount");
            return this;
        }

        /**
         * <i>“Malware category”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(WindowsMalwareCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“Count of devices with malware detections for this malware category”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“Count of distinct active malwares for this malware category. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param distinctActiveMalwareCount
         *            value of {@code distinctActiveMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder distinctActiveMalwareCount(Integer distinctActiveMalwareCount) {
            this.distinctActiveMalwareCount = distinctActiveMalwareCount;
            this.changedFields = changedFields.add("distinctActiveMalwareCount");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update for the device count in UTC”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        public WindowsMalwareCategoryCount build() {
            WindowsMalwareCategoryCount _x = new WindowsMalwareCategoryCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareCategoryCount";
            _x.activeMalwareDetectionCount = activeMalwareDetectionCount;
            _x.category = category;
            _x.deviceCount = deviceCount;
            _x.distinctActiveMalwareCount = distinctActiveMalwareCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            return _x;
        }
    }

    private WindowsMalwareCategoryCount _copy() {
        WindowsMalwareCategoryCount _x = new WindowsMalwareCategoryCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.activeMalwareDetectionCount = activeMalwareDetectionCount;
        _x.category = category;
        _x.deviceCount = deviceCount;
        _x.distinctActiveMalwareCount = distinctActiveMalwareCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareCategoryCount[");
        b.append("activeMalwareDetectionCount=");
        b.append(this.activeMalwareDetectionCount);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("distinctActiveMalwareCount=");
        b.append(this.distinctActiveMalwareCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
