package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The class used to identify the single app configuration for the kiosk win32
 * configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "win32App"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskSingleWin32App extends WindowsKioskAppConfiguration implements ODataType {

    @JsonProperty("win32App")
    protected WindowsKioskWin32App win32App;

    protected WindowsKioskSingleWin32App() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskSingleWin32App";
    }

    /**
     * <i>“This is the win32 app that will be available to launch use while in Kiosk Mode”</i>
     * 
     * @return property win32App
     */
    @Property(name="win32App")
    @JsonIgnore
    public Optional<WindowsKioskWin32App> getWin32App() {
        return Optional.ofNullable(win32App);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code win32App} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This is the win32 app that will be available to launch use while in Kiosk Mode”</i>
     * 
     * @param win32App
     *            new value of {@code win32App} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code win32App} field changed
     */
    public WindowsKioskSingleWin32App withWin32App(WindowsKioskWin32App win32App) {
        WindowsKioskSingleWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskSingleWin32App");
        _x.win32App = win32App;
        return _x;
    }

    public WindowsKioskSingleWin32App withUnmappedField(String name, Object value) {
        WindowsKioskSingleWin32App _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskSingleWin32App() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsKioskWin32App win32App;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“This is the win32 app that will be available to launch use while in Kiosk Mode”</i>
         * 
         * @param win32App
         *            value of {@code win32App} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder win32App(WindowsKioskWin32App win32App) {
            this.win32App = win32App;
            this.changedFields = changedFields.add("win32App");
            return this;
        }

        public WindowsKioskSingleWin32App build() {
            WindowsKioskSingleWin32App _x = new WindowsKioskSingleWin32App();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsKioskSingleWin32App";
            _x.win32App = win32App;
            return _x;
        }
    }

    private WindowsKioskSingleWin32App _copy() {
        WindowsKioskSingleWin32App _x = new WindowsKioskSingleWin32App();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.win32App = win32App;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskSingleWin32App[");
        b.append("win32App=");
        b.append(this.win32App);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
