package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Desktop App for Windows information protection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "binaryName", 
    "binaryVersionHigh", 
    "binaryVersionLow"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionDesktopApp extends WindowsInformationProtectionApp implements ODataType {

    @JsonProperty("binaryName")
    protected String binaryName;

    @JsonProperty("binaryVersionHigh")
    protected String binaryVersionHigh;

    @JsonProperty("binaryVersionLow")
    protected String binaryVersionLow;

    protected WindowsInformationProtectionDesktopApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionDesktopApp";
    }

    /**
     * <i>“The binary name.”</i>
     * 
     * @return property binaryName
     */
    @Property(name="binaryName")
    @JsonIgnore
    public Optional<String> getBinaryName() {
        return Optional.ofNullable(binaryName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The binary name.”</i>
     * 
     * @param binaryName
     *            new value of {@code binaryName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryName} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryName(String binaryName) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryName = binaryName;
        return _x;
    }

    /**
     * <i>“The high binary version.”</i>
     * 
     * @return property binaryVersionHigh
     */
    @Property(name="binaryVersionHigh")
    @JsonIgnore
    public Optional<String> getBinaryVersionHigh() {
        return Optional.ofNullable(binaryVersionHigh);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryVersionHigh
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The high binary version.”</i>
     * 
     * @param binaryVersionHigh
     *            new value of {@code binaryVersionHigh} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryVersionHigh} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryVersionHigh(String binaryVersionHigh) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryVersionHigh = binaryVersionHigh;
        return _x;
    }

    /**
     * <i>“The lower binary version.”</i>
     * 
     * @return property binaryVersionLow
     */
    @Property(name="binaryVersionLow")
    @JsonIgnore
    public Optional<String> getBinaryVersionLow() {
        return Optional.ofNullable(binaryVersionLow);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryVersionLow}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The lower binary version.”</i>
     * 
     * @param binaryVersionLow
     *            new value of {@code binaryVersionLow} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryVersionLow} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryVersionLow(String binaryVersionLow) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryVersionLow = binaryVersionLow;
        return _x;
    }

    public WindowsInformationProtectionDesktopApp withUnmappedField(String name, Object value) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionDesktopApp() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean denied;
        private String description;
        private String displayName;
        private String productName;
        private String publisherName;
        private String binaryName;
        private String binaryVersionHigh;
        private String binaryVersionLow;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder denied(Boolean denied) {
            this.denied = denied;
            this.changedFields = changedFields.add("denied");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        /**
         * <i>“The binary name.”</i>
         * 
         * @param binaryName
         *            value of {@code binaryName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryName(String binaryName) {
            this.binaryName = binaryName;
            this.changedFields = changedFields.add("binaryName");
            return this;
        }

        /**
         * <i>“The high binary version.”</i>
         * 
         * @param binaryVersionHigh
         *            value of {@code binaryVersionHigh} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryVersionHigh(String binaryVersionHigh) {
            this.binaryVersionHigh = binaryVersionHigh;
            this.changedFields = changedFields.add("binaryVersionHigh");
            return this;
        }

        /**
         * <i>“The lower binary version.”</i>
         * 
         * @param binaryVersionLow
         *            value of {@code binaryVersionLow} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryVersionLow(String binaryVersionLow) {
            this.binaryVersionLow = binaryVersionLow;
            this.changedFields = changedFields.add("binaryVersionLow");
            return this;
        }

        public WindowsInformationProtectionDesktopApp build() {
            WindowsInformationProtectionDesktopApp _x = new WindowsInformationProtectionDesktopApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsInformationProtectionDesktopApp";
            _x.denied = denied;
            _x.description = description;
            _x.displayName = displayName;
            _x.productName = productName;
            _x.publisherName = publisherName;
            _x.binaryName = binaryName;
            _x.binaryVersionHigh = binaryVersionHigh;
            _x.binaryVersionLow = binaryVersionLow;
            return _x;
        }
    }

    private WindowsInformationProtectionDesktopApp _copy() {
        WindowsInformationProtectionDesktopApp _x = new WindowsInformationProtectionDesktopApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.denied = denied;
        _x.description = description;
        _x.displayName = displayName;
        _x.productName = productName;
        _x.publisherName = publisherName;
        _x.binaryName = binaryName;
        _x.binaryVersionHigh = binaryVersionHigh;
        _x.binaryVersionLow = binaryVersionLow;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionDesktopApp[");
        b.append("denied=");
        b.append(this.denied);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("binaryName=");
        b.append(this.binaryName);
        b.append(", ");
        b.append("binaryVersionHigh=");
        b.append(this.binaryVersionHigh);
        b.append(", ");
        b.append("binaryVersionLow=");
        b.append(this.binaryVersionLow);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
