package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“App for Windows information protection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "denied", 
    "description", 
    "displayName", 
    "productName", 
    "publisherName"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("denied")
    protected Boolean denied;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("productName")
    protected String productName;

    @JsonProperty("publisherName")
    protected String publisherName;

    protected WindowsInformationProtectionApp() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionApp";
    }

    /**
     * <i>“If true, app is denied protection or exemption.”</i>
     * 
     * @return property denied
     */
    @Property(name="denied")
    @JsonIgnore
    public Optional<Boolean> getDenied() {
        return Optional.ofNullable(denied);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code denied} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If true, app is denied protection or exemption.”</i>
     * 
     * @param denied
     *            new value of {@code denied} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code denied} field changed
     */
    public WindowsInformationProtectionApp withDenied(Boolean denied) {
        WindowsInformationProtectionApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionApp");
        _x.denied = denied;
        return _x;
    }

    /**
     * <i>“The app's description.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app's description.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsInformationProtectionApp withDescription(String description) {
        WindowsInformationProtectionApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionApp");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“App display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“App display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsInformationProtectionApp withDisplayName(String displayName) {
        WindowsInformationProtectionApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionApp");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The product name.”</i>
     * 
     * @return property productName
     */
    @Property(name="productName")
    @JsonIgnore
    public Optional<String> getProductName() {
        return Optional.ofNullable(productName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The product name.”</i>
     * 
     * @param productName
     *            new value of {@code productName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productName} field changed
     */
    public WindowsInformationProtectionApp withProductName(String productName) {
        WindowsInformationProtectionApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionApp");
        _x.productName = productName;
        return _x;
    }

    /**
     * <i>“The publisher name”</i>
     * 
     * @return property publisherName
     */
    @Property(name="publisherName")
    @JsonIgnore
    public Optional<String> getPublisherName() {
        return Optional.ofNullable(publisherName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisherName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher name”</i>
     * 
     * @param publisherName
     *            new value of {@code publisherName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisherName} field changed
     */
    public WindowsInformationProtectionApp withPublisherName(String publisherName) {
        WindowsInformationProtectionApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionApp");
        _x.publisherName = publisherName;
        return _x;
    }

    public WindowsInformationProtectionApp withUnmappedField(String name, Object value) {
        WindowsInformationProtectionApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private WindowsInformationProtectionApp _copy() {
        WindowsInformationProtectionApp _x = new WindowsInformationProtectionApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.denied = denied;
        _x.description = description;
        _x.displayName = displayName;
        _x.productName = productName;
        _x.publisherName = publisherName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionApp[");
        b.append("denied=");
        b.append(this.denied);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
