package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.StateManagementSetting;
import odata.msgraph.client.beta.enums.WindowsFirewallRuleInterfaceTypes;
import odata.msgraph.client.beta.enums.WindowsFirewallRuleNetworkProfileTypes;
import odata.msgraph.client.beta.enums.WindowsFirewallRuleTrafficDirectionType;


/**
 * <i>“A rule controlling traffic through the Windows Firewall.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "description", 
    "displayName", 
    "edgeTraversal", 
    "filePath", 
    "interfaceTypes", 
    "localAddressRanges", 
    "localPortRanges", 
    "localUserAuthorizations", 
    "packageFamilyName", 
    "profileTypes", 
    "protocol", 
    "remoteAddressRanges", 
    "remotePortRanges", 
    "serviceName", 
    "trafficDirection"})
@JsonInclude(Include.NON_NULL)
public class WindowsFirewallRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("action")
    protected StateManagementSetting action;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("edgeTraversal")
    protected StateManagementSetting edgeTraversal;

    @JsonProperty("filePath")
    protected String filePath;

    @JsonProperty("interfaceTypes")
    protected WindowsFirewallRuleInterfaceTypes interfaceTypes;

    @JsonProperty("localAddressRanges")
    protected List<String> localAddressRanges;

    @JsonProperty("localAddressRanges@nextLink")
    protected String localAddressRangesNextLink;

    @JsonProperty("localPortRanges")
    protected List<String> localPortRanges;

    @JsonProperty("localPortRanges@nextLink")
    protected String localPortRangesNextLink;

    @JsonProperty("localUserAuthorizations")
    protected String localUserAuthorizations;

    @JsonProperty("packageFamilyName")
    protected String packageFamilyName;

    @JsonProperty("profileTypes")
    protected WindowsFirewallRuleNetworkProfileTypes profileTypes;

    @JsonProperty("protocol")
    protected Integer protocol;

    @JsonProperty("remoteAddressRanges")
    protected List<String> remoteAddressRanges;

    @JsonProperty("remoteAddressRanges@nextLink")
    protected String remoteAddressRangesNextLink;

    @JsonProperty("remotePortRanges")
    protected List<String> remotePortRanges;

    @JsonProperty("remotePortRanges@nextLink")
    protected String remotePortRangesNextLink;

    @JsonProperty("serviceName")
    protected String serviceName;

    @JsonProperty("trafficDirection")
    protected WindowsFirewallRuleTrafficDirectionType trafficDirection;

    protected WindowsFirewallRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsFirewallRule";
    }

    /**
     * <i>“The action the rule enforces. If not specified, the default is Allowed.”</i>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<StateManagementSetting> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The action the rule enforces. If not specified, the default is Allowed.”</i>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public WindowsFirewallRule withAction(StateManagementSetting action) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.action = action;
        return _x;
    }

    /**
     * <i>“The description of the rule.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the rule.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsFirewallRule withDescription(String description) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The display name of the rule. Does not need to be unique.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the rule. Does not need to be unique.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsFirewallRule withDisplayName(String displayName) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Indicates whether edge traversal is enabled or disabled for this rule. The
     * EdgeTraversal setting indicates that specific inbound traffic is allowed to
     * tunnel through NATs and other edge devices using the Teredo tunneling technology
     * . In order for this setting to work correctly, the application or service with
     * the inbound firewall rule needs to support IPv6. The primary application of this
     * setting allows listeners on the host to be globally addressable through a Teredo
     * IPv6 address. New rules have the EdgeTraversal property disabled by default.”</i>
     * 
     * @return property edgeTraversal
     */
    @Property(name="edgeTraversal")
    @JsonIgnore
    public Optional<StateManagementSetting> getEdgeTraversal() {
        return Optional.ofNullable(edgeTraversal);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeTraversal}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether edge traversal is enabled or disabled for this rule. The
     * EdgeTraversal setting indicates that specific inbound traffic is allowed to
     * tunnel through NATs and other edge devices using the Teredo tunneling technology
     * . In order for this setting to work correctly, the application or service with
     * the inbound firewall rule needs to support IPv6. The primary application of this
     * setting allows listeners on the host to be globally addressable through a Teredo
     * IPv6 address. New rules have the EdgeTraversal property disabled by default.”</i>
     * 
     * @param edgeTraversal
     *            new value of {@code edgeTraversal} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeTraversal} field changed
     */
    public WindowsFirewallRule withEdgeTraversal(StateManagementSetting edgeTraversal) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.edgeTraversal = edgeTraversal;
        return _x;
    }

    /**
     * <i>“The full file path of an app that's affected by the firewall rule.”</i>
     * 
     * @return property filePath
     */
    @Property(name="filePath")
    @JsonIgnore
    public Optional<String> getFilePath() {
        return Optional.ofNullable(filePath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code filePath} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The full file path of an app that's affected by the firewall rule.”</i>
     * 
     * @param filePath
     *            new value of {@code filePath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filePath} field changed
     */
    public WindowsFirewallRule withFilePath(String filePath) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.filePath = filePath;
        return _x;
    }

    /**
     * <i>“The interface types of the rule.”</i>
     * 
     * @return property interfaceTypes
     */
    @Property(name="interfaceTypes")
    @JsonIgnore
    public Optional<WindowsFirewallRuleInterfaceTypes> getInterfaceTypes() {
        return Optional.ofNullable(interfaceTypes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code interfaceTypes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The interface types of the rule.”</i>
     * 
     * @param interfaceTypes
     *            new value of {@code interfaceTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code interfaceTypes} field changed
     */
    public WindowsFirewallRule withInterfaceTypes(WindowsFirewallRuleInterfaceTypes interfaceTypes) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.interfaceTypes = interfaceTypes;
        return _x;
    }

    /**
     * <i>“List of local addresses covered by the rule. Default is any address. Valid
     * tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*" indicates any local address. If present, this must be
     * the only token included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet can be specified using either the
     * subnet mask or network prefix notation. If neither a subnet mask nor a network
     * prefix is specified, the subnet mask defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A
     * valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4 address range in the format of "start
     * address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in
     * the format of "start address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
     * 
     * @return property localAddressRanges
     */
    @Property(name="localAddressRanges")
    @JsonIgnore
    public CollectionPage<String> getLocalAddressRanges() {
        return new CollectionPage<String>(contextPath, String.class, this.localAddressRanges, Optional.ofNullable(localAddressRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of local addresses covered by the rule. Default is any address. Valid
     * tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*" indicates any local address. If present, this must be
     * the only token included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet can be specified using either the
     * subnet mask or network prefix notation. If neither a subnet mask nor a network
     * prefix is specified, the subnet mask defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A
     * valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4 address range in the format of "start
     * address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in
     * the format of "start address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property localAddressRanges
     */
    @Property(name="localAddressRanges")
    @JsonIgnore
    public CollectionPage<String> getLocalAddressRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.localAddressRanges, Optional.ofNullable(localAddressRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of local port ranges. For example, "100-120", "200", "300-320". If not
     * specified, the default is All.”</i>
     * 
     * @return property localPortRanges
     */
    @Property(name="localPortRanges")
    @JsonIgnore
    public CollectionPage<String> getLocalPortRanges() {
        return new CollectionPage<String>(contextPath, String.class, this.localPortRanges, Optional.ofNullable(localPortRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of local port ranges. For example, "100-120", "200", "300-320". If not
     * specified, the default is All.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property localPortRanges
     */
    @Property(name="localPortRanges")
    @JsonIgnore
    public CollectionPage<String> getLocalPortRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.localPortRanges, Optional.ofNullable(localPortRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Specifies the list of authorized local users for the app container. This is a
     * string in Security Descriptor Definition Language (SDDL) format.”</i>
     * 
     * @return property localUserAuthorizations
     */
    @Property(name="localUserAuthorizations")
    @JsonIgnore
    public Optional<String> getLocalUserAuthorizations() {
        return Optional.ofNullable(localUserAuthorizations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localUserAuthorizations} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the list of authorized local users for the app container. This is a
     * string in Security Descriptor Definition Language (SDDL) format.”</i>
     * 
     * @param localUserAuthorizations
     *            new value of {@code localUserAuthorizations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localUserAuthorizations} field changed
     */
    public WindowsFirewallRule withLocalUserAuthorizations(String localUserAuthorizations) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.localUserAuthorizations = localUserAuthorizations;
        return _x;
    }

    /**
     * <i>“The package family name of a Microsoft Store application that's affected by the
     * firewall rule.”</i>
     * 
     * @return property packageFamilyName
     */
    @Property(name="packageFamilyName")
    @JsonIgnore
    public Optional<String> getPackageFamilyName() {
        return Optional.ofNullable(packageFamilyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code packageFamilyName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The package family name of a Microsoft Store application that's affected by the
     * firewall rule.”</i>
     * 
     * @param packageFamilyName
     *            new value of {@code packageFamilyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageFamilyName} field changed
     */
    public WindowsFirewallRule withPackageFamilyName(String packageFamilyName) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.packageFamilyName = packageFamilyName;
        return _x;
    }

    /**
     * <i>“Specifies the profiles to which the rule belongs. If not specified, the default
     * is All.”</i>
     * 
     * @return property profileTypes
     */
    @Property(name="profileTypes")
    @JsonIgnore
    public Optional<WindowsFirewallRuleNetworkProfileTypes> getProfileTypes() {
        return Optional.ofNullable(profileTypes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileTypes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the profiles to which the rule belongs. If not specified, the default
     * is All.”</i>
     * 
     * @param profileTypes
     *            new value of {@code profileTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileTypes} field changed
     */
    public WindowsFirewallRule withProfileTypes(WindowsFirewallRuleNetworkProfileTypes profileTypes) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.profileTypes = profileTypes;
        return _x;
    }

    /**
     * <i>“0-255 number representing the IP protocol (TCP = 6, UDP = 17). If not specified,
     * the default is All. Valid values 0 to 255”</i>
     * 
     * @return property protocol
     */
    @Property(name="protocol")
    @JsonIgnore
    public Optional<Integer> getProtocol() {
        return Optional.ofNullable(protocol);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code protocol} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“0-255 number representing the IP protocol (TCP = 6, UDP = 17). If not specified,
     * the default is All. Valid values 0 to 255”</i>
     * 
     * @param protocol
     *            new value of {@code protocol} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code protocol} field changed
     */
    public WindowsFirewallRule withProtocol(Integer protocol) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.protocol = protocol;
        return _x;
    }

    /**
     * <i>“List of tokens specifying the remote addresses covered by the rule. Tokens are
     * case insensitive. Default is any address. Valid tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*"
     * indicates any remote address. If present, this must be the only token included.&amp;lt;
     * /li&amp;gt;&amp;lt;li&amp;gt;"Defaultgateway"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DHCP"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DNS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"WINS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
     * Intranet" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"RmtIntranet" (supported
     * on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Internet" (supported on Windows versions
     * 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Ply2Renders" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
     * LocalSubnet" indicates any local address on the local subnet.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet
     * can be specified using either the subnet mask or network prefix notation. If
     * neither a subnet mask nor a network prefix is specified, the subnet mask
     * defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4
     * address range in the format of "start address - end address" with no spaces
     * included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in the format of "start address - end
     * address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
     * 
     * @return property remoteAddressRanges
     */
    @Property(name="remoteAddressRanges")
    @JsonIgnore
    public CollectionPage<String> getRemoteAddressRanges() {
        return new CollectionPage<String>(contextPath, String.class, this.remoteAddressRanges, Optional.ofNullable(remoteAddressRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of tokens specifying the remote addresses covered by the rule. Tokens are
     * case insensitive. Default is any address. Valid tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*"
     * indicates any remote address. If present, this must be the only token included.&amp;lt;
     * /li&amp;gt;&amp;lt;li&amp;gt;"Defaultgateway"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DHCP"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DNS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"WINS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
     * Intranet" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"RmtIntranet" (supported
     * on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Internet" (supported on Windows versions
     * 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Ply2Renders" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
     * LocalSubnet" indicates any local address on the local subnet.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet
     * can be specified using either the subnet mask or network prefix notation. If
     * neither a subnet mask nor a network prefix is specified, the subnet mask
     * defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4
     * address range in the format of "start address - end address" with no spaces
     * included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in the format of "start address - end
     * address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property remoteAddressRanges
     */
    @Property(name="remoteAddressRanges")
    @JsonIgnore
    public CollectionPage<String> getRemoteAddressRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.remoteAddressRanges, Optional.ofNullable(remoteAddressRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of remote port ranges. For example, "100-120", "200", "300-320". If not
     * specified, the default is All.”</i>
     * 
     * @return property remotePortRanges
     */
    @Property(name="remotePortRanges")
    @JsonIgnore
    public CollectionPage<String> getRemotePortRanges() {
        return new CollectionPage<String>(contextPath, String.class, this.remotePortRanges, Optional.ofNullable(remotePortRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of remote port ranges. For example, "100-120", "200", "300-320". If not
     * specified, the default is All.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property remotePortRanges
     */
    @Property(name="remotePortRanges")
    @JsonIgnore
    public CollectionPage<String> getRemotePortRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.remotePortRanges, Optional.ofNullable(remotePortRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The name used in cases when a service, not an application, is sending or
     * receiving traffic.”</i>
     * 
     * @return property serviceName
     */
    @Property(name="serviceName")
    @JsonIgnore
    public Optional<String> getServiceName() {
        return Optional.ofNullable(serviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serviceName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name used in cases when a service, not an application, is sending or
     * receiving traffic.”</i>
     * 
     * @param serviceName
     *            new value of {@code serviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serviceName} field changed
     */
    public WindowsFirewallRule withServiceName(String serviceName) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.serviceName = serviceName;
        return _x;
    }

    /**
     * <i>“The traffic direction that the rule is enabled for. If not specified, the
     * default is Out.”</i>
     * 
     * @return property trafficDirection
     */
    @Property(name="trafficDirection")
    @JsonIgnore
    public Optional<WindowsFirewallRuleTrafficDirectionType> getTrafficDirection() {
        return Optional.ofNullable(trafficDirection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code trafficDirection}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The traffic direction that the rule is enabled for. If not specified, the
     * default is Out.”</i>
     * 
     * @param trafficDirection
     *            new value of {@code trafficDirection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trafficDirection} field changed
     */
    public WindowsFirewallRule withTrafficDirection(WindowsFirewallRuleTrafficDirectionType trafficDirection) {
        WindowsFirewallRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallRule");
        _x.trafficDirection = trafficDirection;
        return _x;
    }

    public WindowsFirewallRule withUnmappedField(String name, Object value) {
        WindowsFirewallRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StateManagementSetting action;
        private String description;
        private String displayName;
        private StateManagementSetting edgeTraversal;
        private String filePath;
        private WindowsFirewallRuleInterfaceTypes interfaceTypes;
        private List<String> localAddressRanges;
        private String localAddressRangesNextLink;
        private List<String> localPortRanges;
        private String localPortRangesNextLink;
        private String localUserAuthorizations;
        private String packageFamilyName;
        private WindowsFirewallRuleNetworkProfileTypes profileTypes;
        private Integer protocol;
        private List<String> remoteAddressRanges;
        private String remoteAddressRangesNextLink;
        private List<String> remotePortRanges;
        private String remotePortRangesNextLink;
        private String serviceName;
        private WindowsFirewallRuleTrafficDirectionType trafficDirection;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The action the rule enforces. If not specified, the default is Allowed.”</i>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(StateManagementSetting action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        /**
         * <i>“The description of the rule.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The display name of the rule. Does not need to be unique.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Indicates whether edge traversal is enabled or disabled for this rule. The
         * EdgeTraversal setting indicates that specific inbound traffic is allowed to
         * tunnel through NATs and other edge devices using the Teredo tunneling technology
         * . In order for this setting to work correctly, the application or service with
         * the inbound firewall rule needs to support IPv6. The primary application of this
         * setting allows listeners on the host to be globally addressable through a Teredo
         * IPv6 address. New rules have the EdgeTraversal property disabled by default.”</i>
         * 
         * @param edgeTraversal
         *            value of {@code edgeTraversal} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeTraversal(StateManagementSetting edgeTraversal) {
            this.edgeTraversal = edgeTraversal;
            this.changedFields = changedFields.add("edgeTraversal");
            return this;
        }

        /**
         * <i>“The full file path of an app that's affected by the firewall rule.”</i>
         * 
         * @param filePath
         *            value of {@code filePath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filePath(String filePath) {
            this.filePath = filePath;
            this.changedFields = changedFields.add("filePath");
            return this;
        }

        /**
         * <i>“The interface types of the rule.”</i>
         * 
         * @param interfaceTypes
         *            value of {@code interfaceTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder interfaceTypes(WindowsFirewallRuleInterfaceTypes interfaceTypes) {
            this.interfaceTypes = interfaceTypes;
            this.changedFields = changedFields.add("interfaceTypes");
            return this;
        }

        /**
         * <i>“List of local addresses covered by the rule. Default is any address. Valid
         * tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*" indicates any local address. If present, this must be
         * the only token included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet can be specified using either the
         * subnet mask or network prefix notation. If neither a subnet mask nor a network
         * prefix is specified, the subnet mask defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A
         * valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4 address range in the format of "start
         * address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in
         * the format of "start address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param localAddressRanges
         *            value of {@code localAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRanges(List<String> localAddressRanges) {
            this.localAddressRanges = localAddressRanges;
            this.changedFields = changedFields.add("localAddressRanges");
            return this;
        }

        /**
         * <i>“List of local addresses covered by the rule. Default is any address. Valid
         * tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*" indicates any local address. If present, this must be
         * the only token included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet can be specified using either the
         * subnet mask or network prefix notation. If neither a subnet mask nor a network
         * prefix is specified, the subnet mask defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A
         * valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4 address range in the format of "start
         * address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in
         * the format of "start address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param localAddressRanges
         *            value of {@code localAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRanges(String... localAddressRanges) {
            return localAddressRanges(Arrays.asList(localAddressRanges));
        }

        /**
         * <i>“List of local addresses covered by the rule. Default is any address. Valid
         * tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*" indicates any local address. If present, this must be
         * the only token included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet can be specified using either the
         * subnet mask or network prefix notation. If neither a subnet mask nor a network
         * prefix is specified, the subnet mask defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A
         * valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4 address range in the format of "start
         * address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in
         * the format of "start address - end address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param localAddressRangesNextLink
         *            value of {@code localAddressRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRangesNextLink(String localAddressRangesNextLink) {
            this.localAddressRangesNextLink = localAddressRangesNextLink;
            this.changedFields = changedFields.add("localAddressRanges");
            return this;
        }

        /**
         * <i>“List of local port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param localPortRanges
         *            value of {@code localPortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRanges(List<String> localPortRanges) {
            this.localPortRanges = localPortRanges;
            this.changedFields = changedFields.add("localPortRanges");
            return this;
        }

        /**
         * <i>“List of local port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param localPortRanges
         *            value of {@code localPortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRanges(String... localPortRanges) {
            return localPortRanges(Arrays.asList(localPortRanges));
        }

        /**
         * <i>“List of local port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param localPortRangesNextLink
         *            value of {@code localPortRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRangesNextLink(String localPortRangesNextLink) {
            this.localPortRangesNextLink = localPortRangesNextLink;
            this.changedFields = changedFields.add("localPortRanges");
            return this;
        }

        /**
         * <i>“Specifies the list of authorized local users for the app container. This is a
         * string in Security Descriptor Definition Language (SDDL) format.”</i>
         * 
         * @param localUserAuthorizations
         *            value of {@code localUserAuthorizations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localUserAuthorizations(String localUserAuthorizations) {
            this.localUserAuthorizations = localUserAuthorizations;
            this.changedFields = changedFields.add("localUserAuthorizations");
            return this;
        }

        /**
         * <i>“The package family name of a Microsoft Store application that's affected by the
         * firewall rule.”</i>
         * 
         * @param packageFamilyName
         *            value of {@code packageFamilyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageFamilyName(String packageFamilyName) {
            this.packageFamilyName = packageFamilyName;
            this.changedFields = changedFields.add("packageFamilyName");
            return this;
        }

        /**
         * <i>“Specifies the profiles to which the rule belongs. If not specified, the default
         * is All.”</i>
         * 
         * @param profileTypes
         *            value of {@code profileTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileTypes(WindowsFirewallRuleNetworkProfileTypes profileTypes) {
            this.profileTypes = profileTypes;
            this.changedFields = changedFields.add("profileTypes");
            return this;
        }

        /**
         * <i>“0-255 number representing the IP protocol (TCP = 6, UDP = 17). If not specified,
         * the default is All. Valid values 0 to 255”</i>
         * 
         * @param protocol
         *            value of {@code protocol} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder protocol(Integer protocol) {
            this.protocol = protocol;
            this.changedFields = changedFields.add("protocol");
            return this;
        }

        /**
         * <i>“List of tokens specifying the remote addresses covered by the rule. Tokens are
         * case insensitive. Default is any address. Valid tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*"
         * indicates any remote address. If present, this must be the only token included.&amp;lt;
         * /li&amp;gt;&amp;lt;li&amp;gt;"Defaultgateway"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DHCP"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DNS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"WINS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * Intranet" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"RmtIntranet" (supported
         * on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Internet" (supported on Windows versions
         * 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Ply2Renders" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * LocalSubnet" indicates any local address on the local subnet.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet
         * can be specified using either the subnet mask or network prefix notation. If
         * neither a subnet mask nor a network prefix is specified, the subnet mask
         * defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4
         * address range in the format of "start address - end address" with no spaces
         * included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in the format of "start address - end
         * address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param remoteAddressRanges
         *            value of {@code remoteAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRanges(List<String> remoteAddressRanges) {
            this.remoteAddressRanges = remoteAddressRanges;
            this.changedFields = changedFields.add("remoteAddressRanges");
            return this;
        }

        /**
         * <i>“List of tokens specifying the remote addresses covered by the rule. Tokens are
         * case insensitive. Default is any address. Valid tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*"
         * indicates any remote address. If present, this must be the only token included.&amp;lt;
         * /li&amp;gt;&amp;lt;li&amp;gt;"Defaultgateway"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DHCP"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DNS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"WINS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * Intranet" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"RmtIntranet" (supported
         * on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Internet" (supported on Windows versions
         * 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Ply2Renders" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * LocalSubnet" indicates any local address on the local subnet.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet
         * can be specified using either the subnet mask or network prefix notation. If
         * neither a subnet mask nor a network prefix is specified, the subnet mask
         * defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4
         * address range in the format of "start address - end address" with no spaces
         * included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in the format of "start address - end
         * address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param remoteAddressRanges
         *            value of {@code remoteAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRanges(String... remoteAddressRanges) {
            return remoteAddressRanges(Arrays.asList(remoteAddressRanges));
        }

        /**
         * <i>“List of tokens specifying the remote addresses covered by the rule. Tokens are
         * case insensitive. Default is any address. Valid tokens include:&amp;lt;ul&amp;gt;&amp;lt;li&amp;gt;"*"
         * indicates any remote address. If present, this must be the only token included.&amp;lt;
         * /li&amp;gt;&amp;lt;li&amp;gt;"Defaultgateway"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DHCP"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"DNS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"WINS"&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * Intranet" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"RmtIntranet" (supported
         * on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Internet" (supported on Windows versions
         * 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"Ply2Renders" (supported on Windows versions 1809+)&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;"
         * LocalSubnet" indicates any local address on the local subnet.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A subnet
         * can be specified using either the subnet mask or network prefix notation. If
         * neither a subnet mask nor a network prefix is specified, the subnet mask
         * defaults to 255.255.255.255.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;A valid IPv6 address.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv4
         * address range in the format of "start address - end address" with no spaces
         * included.&amp;lt;/li&amp;gt;&amp;lt;li&amp;gt;An IPv6 address range in the format of "start address - end
         * address" with no spaces included.&amp;lt;/li&amp;gt;&amp;lt;/ul&amp;gt;”</i>
         * 
         * @param remoteAddressRangesNextLink
         *            value of {@code remoteAddressRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRangesNextLink(String remoteAddressRangesNextLink) {
            this.remoteAddressRangesNextLink = remoteAddressRangesNextLink;
            this.changedFields = changedFields.add("remoteAddressRanges");
            return this;
        }

        /**
         * <i>“List of remote port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param remotePortRanges
         *            value of {@code remotePortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRanges(List<String> remotePortRanges) {
            this.remotePortRanges = remotePortRanges;
            this.changedFields = changedFields.add("remotePortRanges");
            return this;
        }

        /**
         * <i>“List of remote port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param remotePortRanges
         *            value of {@code remotePortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRanges(String... remotePortRanges) {
            return remotePortRanges(Arrays.asList(remotePortRanges));
        }

        /**
         * <i>“List of remote port ranges. For example, "100-120", "200", "300-320". If not
         * specified, the default is All.”</i>
         * 
         * @param remotePortRangesNextLink
         *            value of {@code remotePortRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRangesNextLink(String remotePortRangesNextLink) {
            this.remotePortRangesNextLink = remotePortRangesNextLink;
            this.changedFields = changedFields.add("remotePortRanges");
            return this;
        }

        /**
         * <i>“The name used in cases when a service, not an application, is sending or
         * receiving traffic.”</i>
         * 
         * @param serviceName
         *            value of {@code serviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.changedFields = changedFields.add("serviceName");
            return this;
        }

        /**
         * <i>“The traffic direction that the rule is enabled for. If not specified, the
         * default is Out.”</i>
         * 
         * @param trafficDirection
         *            value of {@code trafficDirection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trafficDirection(WindowsFirewallRuleTrafficDirectionType trafficDirection) {
            this.trafficDirection = trafficDirection;
            this.changedFields = changedFields.add("trafficDirection");
            return this;
        }

        public WindowsFirewallRule build() {
            WindowsFirewallRule _x = new WindowsFirewallRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsFirewallRule";
            _x.action = action;
            _x.description = description;
            _x.displayName = displayName;
            _x.edgeTraversal = edgeTraversal;
            _x.filePath = filePath;
            _x.interfaceTypes = interfaceTypes;
            _x.localAddressRanges = localAddressRanges;
            _x.localAddressRangesNextLink = localAddressRangesNextLink;
            _x.localPortRanges = localPortRanges;
            _x.localPortRangesNextLink = localPortRangesNextLink;
            _x.localUserAuthorizations = localUserAuthorizations;
            _x.packageFamilyName = packageFamilyName;
            _x.profileTypes = profileTypes;
            _x.protocol = protocol;
            _x.remoteAddressRanges = remoteAddressRanges;
            _x.remoteAddressRangesNextLink = remoteAddressRangesNextLink;
            _x.remotePortRanges = remotePortRanges;
            _x.remotePortRangesNextLink = remotePortRangesNextLink;
            _x.serviceName = serviceName;
            _x.trafficDirection = trafficDirection;
            return _x;
        }
    }

    private WindowsFirewallRule _copy() {
        WindowsFirewallRule _x = new WindowsFirewallRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.action = action;
        _x.description = description;
        _x.displayName = displayName;
        _x.edgeTraversal = edgeTraversal;
        _x.filePath = filePath;
        _x.interfaceTypes = interfaceTypes;
        _x.localAddressRanges = localAddressRanges;
        _x.localPortRanges = localPortRanges;
        _x.localUserAuthorizations = localUserAuthorizations;
        _x.packageFamilyName = packageFamilyName;
        _x.profileTypes = profileTypes;
        _x.protocol = protocol;
        _x.remoteAddressRanges = remoteAddressRanges;
        _x.remotePortRanges = remotePortRanges;
        _x.serviceName = serviceName;
        _x.trafficDirection = trafficDirection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsFirewallRule[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("edgeTraversal=");
        b.append(this.edgeTraversal);
        b.append(", ");
        b.append("filePath=");
        b.append(this.filePath);
        b.append(", ");
        b.append("interfaceTypes=");
        b.append(this.interfaceTypes);
        b.append(", ");
        b.append("localAddressRanges=");
        b.append(this.localAddressRanges);
        b.append(", ");
        b.append("localPortRanges=");
        b.append(this.localPortRanges);
        b.append(", ");
        b.append("localUserAuthorizations=");
        b.append(this.localUserAuthorizations);
        b.append(", ");
        b.append("packageFamilyName=");
        b.append(this.packageFamilyName);
        b.append(", ");
        b.append("profileTypes=");
        b.append(this.profileTypes);
        b.append(", ");
        b.append("protocol=");
        b.append(this.protocol);
        b.append(", ");
        b.append("remoteAddressRanges=");
        b.append(this.remoteAddressRanges);
        b.append(", ");
        b.append("remotePortRanges=");
        b.append(this.remotePortRanges);
        b.append(", ");
        b.append("serviceName=");
        b.append(this.serviceName);
        b.append(", ");
        b.append("trafficDirection=");
        b.append(this.trafficDirection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
