package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "domainName", 
    "userName"})
@JsonInclude(Include.NON_NULL)
public class WindowsDeviceADAccount extends WindowsDeviceAccount implements ODataType {

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("userName")
    protected String userName;

    protected WindowsDeviceADAccount() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDeviceADAccount";
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public WindowsDeviceADAccount withDomainName(String domainName) {
        WindowsDeviceADAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceADAccount");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    public WindowsDeviceADAccount withUserName(String userName) {
        WindowsDeviceADAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceADAccount");
        _x.userName = userName;
        return _x;
    }

    public WindowsDeviceADAccount withUnmappedField(String name, Object value) {
        WindowsDeviceADAccount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDeviceADAccount() {
        return new Builder();
    }

    public static final class Builder {
        private String password;
        private String domainName;
        private String userName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder password(String password) {
            this.password = password;
            this.changedFields = changedFields.add("password");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public WindowsDeviceADAccount build() {
            WindowsDeviceADAccount _x = new WindowsDeviceADAccount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsDeviceADAccount";
            _x.password = password;
            _x.domainName = domainName;
            _x.userName = userName;
            return _x;
        }
    }

    private WindowsDeviceADAccount _copy() {
        WindowsDeviceADAccount _x = new WindowsDeviceADAccount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.password = password;
        _x.domainName = domainName;
        _x.userName = userName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDeviceADAccount[");
        b.append("password=");
        b.append(this.password);
        b.append(", ");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
