package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The identifier for a Windows app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "windowsAppId"})
@JsonInclude(Include.NON_NULL)
public class WindowsAppIdentifier extends MobileAppIdentifier implements ODataType {

    @JsonProperty("windowsAppId")
    protected String windowsAppId;

    protected WindowsAppIdentifier() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsAppIdentifier";
    }

    /**
     * <i>“The identifier for an app, as specified in the app store.”</i>
     * 
     * @return property windowsAppId
     */
    @Property(name="windowsAppId")
    @JsonIgnore
    public Optional<String> getWindowsAppId() {
        return Optional.ofNullable(windowsAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsAppId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identifier for an app, as specified in the app store.”</i>
     * 
     * @param windowsAppId
     *            new value of {@code windowsAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsAppId} field changed
     */
    public WindowsAppIdentifier withWindowsAppId(String windowsAppId) {
        WindowsAppIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAppIdentifier");
        _x.windowsAppId = windowsAppId;
        return _x;
    }

    public WindowsAppIdentifier withUnmappedField(String name, Object value) {
        WindowsAppIdentifier _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsAppIdentifier() {
        return new Builder();
    }

    public static final class Builder {
        private String windowsAppId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The identifier for an app, as specified in the app store.”</i>
         * 
         * @param windowsAppId
         *            value of {@code windowsAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAppId(String windowsAppId) {
            this.windowsAppId = windowsAppId;
            this.changedFields = changedFields.add("windowsAppId");
            return this;
        }

        public WindowsAppIdentifier build() {
            WindowsAppIdentifier _x = new WindowsAppIdentifier();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsAppIdentifier";
            _x.windowsAppId = windowsAppId;
            return _x;
        }
    }

    private WindowsAppIdentifier _copy() {
        WindowsAppIdentifier _x = new WindowsAppIdentifier();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.windowsAppId = windowsAppId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsAppIdentifier[");
        b.append("windowsAppId=");
        b.append(this.windowsAppId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
