package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“VPN Proxy Server.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bypassProxyServerForLocalAddress"})
@JsonInclude(Include.NON_NULL)
public class Windows10VpnProxyServer extends VpnProxyServer implements ODataType {

    @JsonProperty("bypassProxyServerForLocalAddress")
    protected Boolean bypassProxyServerForLocalAddress;

    protected Windows10VpnProxyServer() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10VpnProxyServer";
    }

    /**
     * <i>“Bypass proxy server for local address.”</i>
     * 
     * @return property bypassProxyServerForLocalAddress
     */
    @Property(name="bypassProxyServerForLocalAddress")
    @JsonIgnore
    public Optional<Boolean> getBypassProxyServerForLocalAddress() {
        return Optional.ofNullable(bypassProxyServerForLocalAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bypassProxyServerForLocalAddress} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Bypass proxy server for local address.”</i>
     * 
     * @param bypassProxyServerForLocalAddress
     *            new value of {@code bypassProxyServerForLocalAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bypassProxyServerForLocalAddress} field changed
     */
    public Windows10VpnProxyServer withBypassProxyServerForLocalAddress(Boolean bypassProxyServerForLocalAddress) {
        Windows10VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnProxyServer");
        _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
        return _x;
    }

    public Windows10VpnProxyServer withUnmappedField(String name, Object value) {
        Windows10VpnProxyServer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10VpnProxyServer() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private String automaticConfigurationScriptUrl;
        private Integer port;
        private Boolean bypassProxyServerForLocalAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder automaticConfigurationScriptUrl(String automaticConfigurationScriptUrl) {
            this.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            this.changedFields = changedFields.add("automaticConfigurationScriptUrl");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        /**
         * <i>“Bypass proxy server for local address.”</i>
         * 
         * @param bypassProxyServerForLocalAddress
         *            value of {@code bypassProxyServerForLocalAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bypassProxyServerForLocalAddress(Boolean bypassProxyServerForLocalAddress) {
            this.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
            this.changedFields = changedFields.add("bypassProxyServerForLocalAddress");
            return this;
        }

        public Windows10VpnProxyServer build() {
            Windows10VpnProxyServer _x = new Windows10VpnProxyServer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10VpnProxyServer";
            _x.address = address;
            _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            _x.port = port;
            _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
            return _x;
        }
    }

    private Windows10VpnProxyServer _copy() {
        Windows10VpnProxyServer _x = new Windows10VpnProxyServer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
        _x.port = port;
        _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10VpnProxyServer[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("automaticConfigurationScriptUrl=");
        b.append(this.automaticConfigurationScriptUrl);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append(", ");
        b.append("bypassProxyServerForLocalAddress=");
        b.append(this.bypassProxyServerForLocalAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
