package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppRuleType;


/**
 * <i>“A base complex type to store the detection or requirement rule data for a Win32
 * LOB app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ruleType"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ruleType")
    protected Win32LobAppRuleType ruleType;

    protected Win32LobAppRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppRule";
    }

    /**
     * <i>“The rule type indicating the purpose of the rule.”</i>
     * 
     * @return property ruleType
     */
    @Property(name="ruleType")
    @JsonIgnore
    public Optional<Win32LobAppRuleType> getRuleType() {
        return Optional.ofNullable(ruleType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ruleType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The rule type indicating the purpose of the rule.”</i>
     * 
     * @param ruleType
     *            new value of {@code ruleType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ruleType} field changed
     */
    public Win32LobAppRule withRuleType(Win32LobAppRuleType ruleType) {
        Win32LobAppRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRule");
        _x.ruleType = ruleType;
        return _x;
    }

    public Win32LobAppRule withUnmappedField(String name, Object value) {
        Win32LobAppRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private Win32LobAppRule _copy() {
        Win32LobAppRule _x = new Win32LobAppRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ruleType = ruleType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppRule[");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
